/*
 * Decompiled with CFR 0.152.
 */
package serverutils.net;

import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.gui.ranks.RankInst;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.data.ForgePlayer;
import serverutils.lib.data.Universe;
import serverutils.lib.io.DataIn;
import serverutils.lib.io.DataOut;
import serverutils.lib.net.MessageToServer;
import serverutils.lib.net.NetworkWrapper;
import serverutils.lib.util.permission.PermissionAPI;
import serverutils.net.MessageUpdateTabName;
import serverutils.net.ServerUtilitiesNetHandler;
import serverutils.ranks.PlayerRank;
import serverutils.ranks.Rank;
import serverutils.ranks.Ranks;

public class MessageRankModify
extends MessageToServer {
    private RankInst inst;
    private Collection<String> removedEntries;

    public MessageRankModify() {
    }

    public MessageRankModify(RankInst rank, Collection<String> removedEntries) {
        this.inst = rank;
        this.removedEntries = removedEntries;
    }

    @Override
    public NetworkWrapper getWrapper() {
        return ServerUtilitiesNetHandler.FILES;
    }

    @Override
    public void writeData(DataOut data) {
        RankInst.SERIALIZER.write(data, this.inst);
        data.writeCollection(this.removedEntries, DataOut.STRING);
    }

    @Override
    public void readData(DataIn data) {
        this.inst = RankInst.DESERIALIZER.read(data);
        this.removedEntries = data.readCollection(DataIn.STRING);
    }

    @Override
    public void onMessage(EntityPlayerMP player) {
        Rank.Entry entry;
        if (!PermissionAPI.hasPermission((EntityPlayer)player, "serverutilities.admin_panel.ranks.view")) {
            return;
        }
        Rank rank = Ranks.INSTANCE.getRank(this.inst.getId());
        if (rank == null) {
            player.func_145747_a((IChatComponent)new ChatComponentText("Rank: " + this.inst.getId() + " not found"));
            return;
        }
        boolean updateNames = false;
        boolean shouldSave = false;
        for (ConfigValueInstance value : this.inst.group.getValues()) {
            entry = rank.setPermission(value.getId(), value.getValue());
            if (entry == null) continue;
            if (entry.node.equals("serverutilities.chat.name_format")) {
                updateNames = true;
            }
            shouldSave = true;
        }
        for (String removed : this.removedEntries) {
            entry = rank.setPermission(removed, "");
            if (entry == null) continue;
            if (entry.node.equals("serverutilities.chat.name_format")) {
                updateNames = true;
            }
            shouldSave = true;
        }
        if (shouldSave) {
            Ranks.INSTANCE.save();
        }
        if (ServerUtilitiesConfig.chat.replace_tab_names && updateNames) {
            ArrayList<ForgePlayer> toUpdate = new ArrayList<ForgePlayer>();
            for (PlayerRank playerRank : Ranks.INSTANCE.playerRanks.values()) {
                ForgePlayer fp;
                if (!playerRank.getParents().contains(rank) || (fp = Universe.get().getPlayer(playerRank.profile)) == null || !fp.isOnline()) continue;
                toUpdate.add(fp);
            }
            new MessageUpdateTabName(toUpdate).sendToAll();
        }
    }
}

