/*
 * Decompiled with CFR 0.152.
 */
package gcewing.projectblue;

import com.google.gson.Gson;
import gcewing.projectblue.IPBRenderer;
import gcewing.projectblue.PBTexture;
import gcewing.projectblue.Trans3;
import gcewing.projectblue.Vector3;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class PBModel {
    public double[] bounds;
    public Face[] faces;
    static Gson gson = new Gson();

    public static PBModel fromResource(ResourceLocation location) {
        try {
            InputStream in = Minecraft.func_71410_x().func_110442_L().func_110536_a(location).func_110527_b();
            PBModel model = (PBModel)gson.fromJson((Reader)new InputStreamReader(in), PBModel.class);
            model.prepare();
            return model;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public AxisAlignedBB getBounds() {
        return AxisAlignedBB.func_72330_a((double)this.bounds[0], (double)this.bounds[1], (double)this.bounds[2], (double)this.bounds[3], (double)this.bounds[4], (double)this.bounds[5]);
    }

    void prepare() {
        for (Face face : this.faces) {
            double[][] p = face.vertices;
            int[] t = face.triangles[0];
            face.centroid = Vector3.average(p[t[0]], p[t[1]], p[t[2]]);
            face.normal = Vector3.unit(Vector3.sub(p[t[1]], p[t[0]]).cross(Vector3.sub(p[t[2]], p[t[0]])));
        }
    }

    public void tessellate(Trans3 t, IIcon ... icons) {
        Tessellator tess = Tessellator.field_78398_a;
        Vector3 p = null;
        Vector3 n = null;
        double u = 0.0;
        double v = 0.0;
        for (Face face : this.faces) {
            IIcon icon = icons[face.texture];
            double u0 = icon.func_94209_e();
            double v0 = icon.func_94206_g();
            double usize = (double)icon.func_94212_f() - u0;
            double vsize = (double)icon.func_94210_h() - v0;
            int[][] nArray = face.triangles;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int[] tri;
                for (int i2 : tri = nArray[i]) {
                    double[] c = face.vertices[i2];
                    p = t.p(c[0], c[1], c[2]);
                    n = t.v(c[3], c[4], c[5]);
                    u = u0 + usize * c[6];
                    v = v0 + vsize * c[7];
                    tess.func_78375_b((float)n.x, (float)n.y, (float)n.z);
                    tess.func_78374_a(p.x, p.y, p.z, u, v);
                }
                tess.func_78375_b((float)n.x, (float)n.y, (float)n.z);
                tess.func_78374_a(p.x, p.y, p.z, u, v);
            }
        }
    }

    public void draw(Trans3 t, IIcon ... icons) {
        Vector3 p = null;
        Vector3 n = null;
        double u = 0.0;
        double v = 0.0;
        GL11.glBegin((int)4);
        for (Face face : this.faces) {
            IIcon icon = icons[face.texture];
            double u0 = icon.func_94209_e();
            double v0 = icon.func_94206_g();
            double usize = (double)icon.func_94212_f() - u0;
            double vsize = (double)icon.func_94210_h() - v0;
            int[][] nArray = face.triangles;
            int n2 = nArray.length;
            for (int i = 0; i < n2; ++i) {
                int[] tri;
                for (int i2 : tri = nArray[i]) {
                    double[] c = face.vertices[i2];
                    p = t.p(c[0], c[1], c[2]);
                    n = t.v(c[3], c[4], c[5]);
                    u = u0 + usize * c[6];
                    v = v0 + vsize * c[7];
                    GL11.glNormal3d((double)n.x, (double)n.y, (double)n.z);
                    GL11.glTexCoord2d((double)u, (double)v);
                    GL11.glVertex3d((double)p.x, (double)p.y, (double)p.z);
                }
            }
        }
        GL11.glEnd();
    }

    public void render(Trans3 t, IPBRenderer pbr, PBTexture ... textures) {
        Vector3 p = null;
        Vector3 n = null;
        PBTexture currentTexture = null;
        pbr.begin(4);
        for (Face face : this.faces) {
            PBTexture texture = textures[face.texture];
            if (currentTexture != texture) {
                texture.activate(pbr);
                currentTexture = texture;
            }
            pbr.lightFace(t.p(face.centroid), t.v(face.normal));
            for (int[] tri : face.triangles) {
                for (int i = 0; i < 3; ++i) {
                    int j = tri[i];
                    double[] c = face.vertices[j];
                    p = t.p(c[0], c[1], c[2]);
                    n = t.v(c[3], c[4], c[5]);
                    texture.renderVertex(pbr, i, p, n, c[6], c[7]);
                }
            }
        }
        pbr.end();
    }

    public static class Face {
        int texture;
        double[][] vertices;
        int[][] triangles;
        Vector3 centroid;
        Vector3 normal;
    }
}

