/*
 * Decompiled with CFR 0.152.
 */
package openmods.renderer;

import com.google.common.base.Preconditions;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

@SideOnly(value=Side.CLIENT)
public class DisposableDynamicTexture
extends AbstractTexture {
    private int[] dynamicTextureData;
    private int width;
    private int height;
    private static int textureCounter;

    public void resize(int width, int height) {
        if (width != this.width || height != this.height) {
            this.width = width;
            this.height = height;
            TextureUtil.func_110991_a((int)this.func_110552_b(), (int)width, (int)height);
        }
    }

    public void func_110551_a(IResourceManager par1ResourceManager) {
    }

    public void update() {
        Preconditions.checkNotNull((Object)this.dynamicTextureData, (Object)"Texture not allocated");
        TextureUtil.func_110988_a((int)this.func_110552_b(), (int[])this.dynamicTextureData, (int)this.width, (int)this.height);
    }

    public void updateAndDeallocate() {
        this.update();
        this.dynamicTextureData = null;
    }

    public int[] allocate() {
        if (this.dynamicTextureData == null) {
            this.dynamicTextureData = new int[this.width * this.height];
        }
        return this.dynamicTextureData;
    }

    public ResourceLocation register(TextureManager manager, String prefix) {
        ResourceLocation location = new ResourceLocation(String.format("dynamic_o/%s_%d", prefix, textureCounter));
        ++textureCounter;
        manager.func_110579_a(location, (ITextureObject)this);
        return location;
    }
}

