/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.integration.model.layers;

import com.gtnewhorizons.navigator.api.model.SupportedMods;
import com.gtnewhorizons.navigator.api.model.buttons.ButtonManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerManager;
import com.gtnewhorizons.navigator.api.model.layers.LayerRenderer;
import com.gtnewhorizons.navigator.api.model.layers.UniversalLayerRenderer;
import com.gtnewhorizons.navigator.api.model.locations.ILocationProvider;
import com.sinthoras.visualprospecting.database.ClientCache;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.integration.model.buttons.UndergroundFluidButtonManager;
import com.sinthoras.visualprospecting.integration.model.locations.UndergroundFluidLocation;
import com.sinthoras.visualprospecting.integration.model.render.UndergroundFluidRenderStep;
import org.jetbrains.annotations.Nullable;

public class UndergroundFluidLayerManager
extends LayerManager {
    public static final UndergroundFluidLayerManager instance = new UndergroundFluidLayerManager();

    public UndergroundFluidLayerManager() {
        super((ButtonManager)UndergroundFluidButtonManager.instance);
    }

    @Nullable
    protected LayerRenderer addLayerRenderer(LayerManager manager, SupportedMods mod) {
        return new UniversalLayerRenderer(manager).withRenderStep(location -> new UndergroundFluidRenderStep((UndergroundFluidLocation)location)).withRenderPriority(1);
    }

    protected ILocationProvider generateLocation(int chunkX, int chunkZ, int dim) {
        if (chunkX % 8 != 0 || chunkZ % 8 != 0) {
            return null;
        }
        UndergroundFluidPosition undergroundFluid = ClientCache.instance.getUndergroundFluid(dim, chunkX, chunkZ);
        if (undergroundFluid.isProspected()) {
            return new UndergroundFluidLocation(undergroundFluid);
        }
        return null;
    }

    public int getElementSize() {
        return 8;
    }
}

