/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.packets.server;

import chylex.hee.mechanics.compendium.content.KnowledgeFragment;
import chylex.hee.mechanics.compendium.content.KnowledgeObject;
import chylex.hee.mechanics.compendium.events.CompendiumEvents;
import chylex.hee.mechanics.compendium.player.PlayerCompendiumData;
import chylex.hee.packets.AbstractServerPacket;
import chylex.hee.packets.PacketPipeline;
import chylex.hee.packets.client.C19CompendiumData;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class S02CompendiumPurchase
extends AbstractServerPacket {
    private boolean isFragment;
    private int id;

    public S02CompendiumPurchase() {
    }

    public S02CompendiumPurchase(KnowledgeObject<?> object) {
        this.isFragment = false;
        this.id = object.globalID;
    }

    public S02CompendiumPurchase(KnowledgeFragment fragment) {
        this.isFragment = true;
        this.id = fragment.globalID;
    }

    @Override
    public void write(ByteBuf buffer) {
        buffer.writeBoolean(this.isFragment).writeInt(this.id);
    }

    @Override
    public void read(ByteBuf buffer) {
        this.isFragment = buffer.readBoolean();
        this.id = buffer.readInt();
    }

    @Override
    protected void handle(EntityPlayerMP player) {
        PlayerCompendiumData compendiumData = CompendiumEvents.getPlayerData((EntityPlayer)player);
        int points = 0;
        if (this.isFragment) {
            KnowledgeFragment fragment = KnowledgeFragment.getById(this.id);
            if (fragment != null && compendiumData.getPoints() >= fragment.getPrice() && compendiumData.tryUnlockFragment(fragment)) {
                points = fragment.getPrice();
            }
        } else {
            KnowledgeObject object = KnowledgeObject.getObjectById(this.id);
            if (object != null && compendiumData.getPoints() >= object.getUnlockPrice() && compendiumData.tryDiscoverObject(object, false)) {
                points = object.getUnlockPrice();
            }
        }
        if (points > 0) {
            compendiumData.payPoints(points);
        }
        PacketPipeline.sendToPlayer((EntityPlayer)player, new C19CompendiumData(compendiumData));
    }
}

