/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.properties.icons;

import com.github.weisj.darklaf.properties.icons.DarkSVGIcon;
import com.github.weisj.darklaf.properties.icons.IconLoader;
import com.github.weisj.darklaf.properties.icons.ThemedIcon;
import com.github.weisj.darklaf.properties.icons.ThemedSVGIconParserProvider;
import com.github.weisj.jsvg.parser.ParserProvider;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;

public class ThemedSVGIcon
extends DarkSVGIcon
implements ThemedIcon {
    private final List<ThemedSVGIconParserProvider.ThemedSolidColorPaint> paints;
    private Object currentTheme;
    private boolean updatedNotDuringPaint;

    public ThemedSVGIcon(URI uri, int displayWidth, int displayHeight) {
        super(uri, displayWidth, displayHeight);
        this.paints = new ArrayList<ThemedSVGIconParserProvider.ThemedSolidColorPaint>();
    }

    protected ThemedSVGIcon(int width, int height, ThemedSVGIcon icon) {
        super(width, height, icon);
        this.paints = icon.paints;
        this.currentTheme = icon.currentTheme;
        this.updatedNotDuringPaint = icon.updatedNotDuringPaint;
    }

    @Override
    public ThemedSVGIcon derive(int width, int height) {
        if (width == this.getIconWidth() && height == this.getIconHeight()) {
            return this;
        }
        return new ThemedSVGIcon(width, height, this);
    }

    @Override
    protected boolean ensureLoaded(boolean painting) {
        return super.ensureLoaded(painting) | this.ensureTheme(painting);
    }

    protected boolean ensureTheme(boolean painting) {
        Object theme = IconLoader.getThemeStatus();
        if (this.currentTheme != theme) {
            this.patchColors();
            this.currentTheme = theme;
            this.updatedNotDuringPaint = !painting;
            return true;
        }
        if (this.updatedNotDuringPaint) {
            this.updatedNotDuringPaint = false;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected ParserProvider createParserProvider() {
        return new ThemedSVGIconParserProvider(this);
    }

    @Override
    public String toString() {
        return "ThemedSVGIcon{parentState= " + super.toString() + "paints=" + this.paints + ", currentTheme=" + this.currentTheme + ", updatedNotDuringPaint=" + this.updatedNotDuringPaint + '}';
    }

    void registerPaint(ThemedSVGIconParserProvider.ThemedSolidColorPaint paint) {
        this.paints.add(paint);
    }

    List<ThemedSVGIconParserProvider.ThemedSolidColorPaint> paints() {
        return this.paints;
    }

    public void invalidate() {
        this.currentTheme = new Object();
    }

    protected UIDefaults getContextDefaults() {
        return UIManager.getDefaults();
    }

    protected void patchColors() {
        ThemedSVGIconParserProvider.patchColors(this.paints, this.getContextDefaults(), null);
    }
}

