/*
 * Decompiled with CFR 0.152.
 */
package gcewing.sg.renderers;

import gcewing.sg.SGCraft;
import gcewing.sg.interfaces.IBlock;
import gcewing.sg.interfaces.IBlockState;
import gcewing.sg.interfaces.ICustomRenderer;
import gcewing.sg.interfaces.IModel;
import gcewing.sg.interfaces.IRenderTarget;
import gcewing.sg.interfaces.ITexture;
import gcewing.sg.utils.EnumWorldBlockLayer;
import gcewing.sg.utils.Trans3;
import net.minecraft.item.ItemStack;
import net.minecraft.world.IBlockAccess;
import org.joml.Vector3d;
import org.joml.Vector3i;

public class BaseModelRenderer
implements ICustomRenderer {
    public static boolean debugRenderModel = false;
    protected IModel model;
    protected ITexture[] textures;
    protected Vector3d origin;

    public BaseModelRenderer(IModel model, Vector3d origin, ITexture ... textures) {
        this.model = model;
        this.textures = textures;
        this.origin = origin;
    }

    @Override
    public void renderBlock(IBlockAccess world, Vector3i pos, IBlockState state, IRenderTarget target, EnumWorldBlockLayer layer, Trans3 t) {
        IBlock block = (IBlock)state.getBlock();
        Trans3 t2 = t.t(block.localToGlobalTransformation(world, pos, state, new Vector3d())).translate(this.origin);
        this.model.render(t2, target, this.textures);
    }

    @Override
    public void renderItemStack(ItemStack stack, IRenderTarget target, Trans3 t) {
        if (debugRenderModel) {
            SGCraft.log.debug(String.format("BaseModelRenderer.renderItemStack: %s", stack));
            SGCraft.log.debug(String.format("BaseModelRenderer.renderItemStack: model = %s", this.model));
            for (int i = 0; i < this.textures.length; ++i) {
                SGCraft.log.debug(String.format("BaseModelRenderer.renderItemStack: textures[%s] = %s", i, this.textures[i]));
            }
        }
        this.model.render(t.translate(this.origin), target, this.textures);
    }
}

