/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.integration;

import appeng.api.AEApi;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.recipes.IIngredient;
import appeng.api.storage.IExternalStorageHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.data.IAEItemStack;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.integration.IntegrationModule;
import com.jaquadro.minecraft.storagedrawers.integration.ae2.DrawerExternalStorageHandler;
import com.jaquadro.minecraft.storagedrawers.integration.ae2.IStorageBusMonitorFactory;
import com.jaquadro.minecraft.storagedrawers.integration.ae2.IngredientHandler;
import com.jaquadro.minecraft.storagedrawers.integration.ae2.ShapedRecipeHandler;
import com.jaquadro.minecraft.storagedrawers.integration.ae2.ShapelessRecipeHandler;
import java.lang.reflect.Constructor;

public class AppliedEnergistics
extends IntegrationModule {
    private IStorageBusMonitorFactory factory;

    @Override
    public String getModID() {
        return "appliedenergistics2";
    }

    @Override
    public void init() throws Throwable {
        ShapelessRecipeHandler shapelessHandler;
        ShapedRecipeHandler shapedHandler = new ShapedRecipeHandler();
        if (shapedHandler.isValid()) {
            StorageDrawers.recipeHandlerRegistry.registerRecipeHandler(shapedHandler.getRecipeClass(), shapedHandler);
        }
        if ((shapelessHandler = new ShapelessRecipeHandler()).isValid()) {
            StorageDrawers.recipeHandlerRegistry.registerRecipeHandler(shapelessHandler.getRecipeClass(), shapelessHandler);
        }
        StorageDrawers.recipeHandlerRegistry.registerIngredientHandler(IIngredient.class, new IngredientHandler());
        ReflectionFactory rfactory = new ReflectionFactory();
        if (!rfactory.init()) {
            throw new Exception("No valid Storage Bus Monitor factory");
        }
        this.factory = rfactory;
    }

    @Override
    public void postInit() {
        AEApi.instance().registries().externalStorage().addExternalStorageInterface((IExternalStorageHandler)new DrawerExternalStorageHandler(this.factory));
    }

    private static class APIFactory
    implements IStorageBusMonitorFactory {
        private APIFactory() {
        }

        @Override
        public IMEMonitor<IAEItemStack> createStorageBusMonitor(IMEInventory<IAEItemStack> inventory, BaseActionSource src) {
            return null;
        }
    }

    private static class ReflectionFactory
    implements IStorageBusMonitorFactory {
        private Class classInventoryAdaptor;
        private Class classMEAdaptor;
        private Class classMonitor;
        private Constructor constMEAdaptor;
        private Constructor constMonitor;

        private ReflectionFactory() {
        }

        public boolean init() {
            try {
                this.classInventoryAdaptor = Class.forName("appeng.util.InventoryAdaptor");
                this.classMEAdaptor = Class.forName("appeng.util.inv.IMEAdaptor");
                this.classMonitor = Class.forName("appeng.me.storage.MEMonitorIInventory");
                this.constMEAdaptor = this.classMEAdaptor.getConstructor(IMEInventory.class, BaseActionSource.class);
                this.constMonitor = this.classMonitor.getConstructor(this.classInventoryAdaptor);
                return true;
            }
            catch (Throwable t) {
                return false;
            }
        }

        @Override
        public IMEMonitor<IAEItemStack> createStorageBusMonitor(IMEInventory<IAEItemStack> inventory, BaseActionSource src) {
            try {
                Object adaptor = this.constMEAdaptor.newInstance(inventory, src);
                Object monitor = this.constMonitor.newInstance(adaptor);
                return (IMEMonitor)monitor;
            }
            catch (Throwable t) {
                return null;
            }
        }
    }
}

