/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.transform.compat.transformers.specific;

import com.gtnewhorizons.angelica.loading.AngelicaTweaker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.spongepowered.asm.lib.ClassReader;
import org.spongepowered.asm.lib.ClassVisitor;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.ClassNode;
import org.spongepowered.asm.lib.tree.FieldInsnNode;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.JumpInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.transformers.MixinClassWriter;

public class ImmersiveEngineeringTransformer
implements IClassTransformer {
    private static final String BlockRenderClothDevices = "blusunrize.immersiveengineering.client.render.BlockRenderClothDevices";
    private static final String BlockRenderMetalDevices2 = "blusunrize.immersiveengineering.client.render.BlockRenderMetalDevices2";
    private static final String BlockRenderStoneDevices = "blusunrize.immersiveengineering.client.render.BlockRenderStoneDevices";
    private static final String ClientUtils = "blusunrize.immersiveengineering.client.ClientUtils";
    private static final List<String> transformedClasses = new ArrayList<String>();
    private static final List<String> staticRenderPassPatches = new ArrayList<String>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        if (!transformedClasses.contains(transformedName)) {
            return basicClass;
        }
        ClassReader cr = new ClassReader(basicClass);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 0);
        if (transformedName.equals(ClientUtils)) {
            this.transformClientUtils(cn);
        }
        if (staticRenderPassPatches.contains(transformedName)) {
            this.staticRenderPassPatcher(cn);
        }
        MixinClassWriter cw = new MixinClassWriter(2);
        cn.accept((ClassVisitor)cw);
        byte[] bytes = cw.toByteArray();
        AngelicaTweaker.LOGGER.info("[AngelicaCompat]Extra Transformers: Applied ImmersiveEngineeringTransformer");
        AngelicaTweaker.dumpClass(transformedName, basicClass, bytes, this);
        return bytes;
    }

    private void staticRenderPassPatcher(ClassNode cn) {
        for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("renderWorldBlock")) continue;
            for (int i = 0; i < mn.instructions.size(); ++i) {
                FieldInsnNode fin;
                AbstractInsnNode ain = mn.instructions.get(i);
                if (!(ain instanceof FieldInsnNode) || (fin = (FieldInsnNode)ain).getOpcode() != 178 || !fin.name.equals("renderPass")) continue;
                MethodInsnNode getRenderPass = new MethodInsnNode(184, "net/minecraftforge/client/ForgeHooksClient", "getWorldRenderPass", "()I");
                mn.instructions.insert((AbstractInsnNode)fin, (AbstractInsnNode)getRenderPass);
                mn.instructions.remove((AbstractInsnNode)fin);
            }
        }
    }

    private void transformClientUtils(ClassNode cn) {
        block0: for (MethodNode mn : cn.methods) {
            if (!mn.name.equals("renderStaticWavefrontModelWithIcon") && !mn.name.equals("renderStaticWavefrontModel") || !mn.desc.equals("(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/client/model/obj/WavefrontObject;Lnet/minecraft/util/IIcon;Lnet/minecraft/client/renderer/Tessellator;Lblusunrize/immersiveengineering/common/util/chickenbones/Matrix4;Lblusunrize/immersiveengineering/common/util/chickenbones/Matrix4;IZFFF[Ljava/lang/String;)V") && !mn.desc.equals("(Lnet/minecraft/world/IBlockAccess;IIILnet/minecraftforge/client/model/obj/WavefrontObject;Lnet/minecraft/client/renderer/Tessellator;Lblusunrize/immersiveengineering/common/util/chickenbones/Matrix4;Lblusunrize/immersiveengineering/common/util/chickenbones/Matrix4;IZFFF[Ljava/lang/String;)V")) continue;
            for (int i = 0; i < mn.instructions.size(); ++i) {
                JumpInsnNode jump;
                AbstractInsnNode ain = mn.instructions.get(i);
                if (!(ain instanceof JumpInsnNode) || (jump = (JumpInsnNode)ain).getOpcode() != 198) continue;
                InsnNode iconst = new InsnNode(3);
                jump.setOpcode(153);
                mn.instructions.insertBefore((AbstractInsnNode)jump, (AbstractInsnNode)iconst);
                continue block0;
            }
        }
    }

    static {
        transformedClasses.add(BlockRenderClothDevices);
        transformedClasses.add(BlockRenderMetalDevices2);
        transformedClasses.add(BlockRenderStoneDevices);
        transformedClasses.add(ClientUtils);
        staticRenderPassPatches.add(BlockRenderClothDevices);
        staticRenderPassPatches.add(BlockRenderMetalDevices2);
        staticRenderPassPatches.add(BlockRenderStoneDevices);
    }
}

