/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.common.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import me.jellysquid.mods.sodium.common.config.Option;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SodiumConfig {
    private static final Logger LOGGER = LogManager.getLogger((String)"EmbeddiumConfig");
    private final Map<String, Option> options = new HashMap<String, Option>();

    private SodiumConfig() {
    }

    private void readProperties(Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            boolean enabled;
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            Option option = this.options.get(key);
            if (option == null) {
                LOGGER.warn("No configuration key exists with name '{}', ignoring", new Object[]{key});
                continue;
            }
            if (value.equalsIgnoreCase("true")) {
                enabled = true;
            } else if (value.equalsIgnoreCase("false")) {
                enabled = false;
            } else {
                LOGGER.warn("Invalid value '{}' encountered for configuration key '{}', ignoring", new Object[]{value, key});
                continue;
            }
            option.setEnabled(enabled, true);
        }
    }

    public static SodiumConfig load(File file) {
        if (!file.exists()) {
            try {
                SodiumConfig.writeDefaultConfig(file);
            }
            catch (IOException e) {
                LOGGER.warn("Could not write default configuration file", (Throwable)e);
            }
            return new SodiumConfig();
        }
        Properties props = new Properties();
        try (FileInputStream fin = new FileInputStream(file);){
            props.load(fin);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not load config file", e);
        }
        SodiumConfig config = new SodiumConfig();
        config.readProperties(props);
        return config;
    }

    private static void writeDefaultConfig(File file) throws IOException {
        File dir = file.getParentFile();
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                throw new IOException("Could not create parent directories");
            }
        } else if (!dir.isDirectory()) {
            throw new IOException("The parent file is not a directory");
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write("# This is the configuration file for Sodium.\n");
            writer.write("#\n");
            writer.write("# You can find information on editing this file and all the available options here:\n");
            writer.write("# https://github.com/jellysquid3/sodium-fabric/wiki/Configuration-File\n");
            writer.write("#\n");
            writer.write("# By default, this file will be empty except for this notice.\n");
        }
    }
}

