/*
 * Decompiled with CFR 0.152.
 */
package betterquesting.api2.client.gui.panels.content;

import betterquesting.api.utils.BigItemStack;
import betterquesting.api2.client.gui.controls.PanelButtonStorage;
import betterquesting.api2.client.gui.misc.GuiPadding;
import betterquesting.api2.client.gui.misc.IGuiRect;
import betterquesting.api2.client.gui.resources.textures.ColorTexture;
import betterquesting.api2.client.gui.resources.textures.ItemTexture;
import betterquesting.api2.client.gui.resources.textures.LayeredTexture;
import betterquesting.api2.client.gui.resources.textures.OreDictTexture;
import betterquesting.api2.client.gui.themes.presets.PresetColor;
import betterquesting.api2.client.gui.themes.presets.PresetTexture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumChatFormatting;

public class PanelItemSlot
extends PanelButtonStorage<BigItemStack> {
    private final boolean showCount;
    private final boolean oreDict;
    private final float interval;
    private final List<BigItemStack> oreVariants = new ArrayList<BigItemStack>();

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value) {
        this(rect, id, value, false, false);
    }

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value, boolean showCount) {
        this(rect, id, value, showCount, false);
    }

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value, boolean showCount, boolean oreDict) {
        this(rect, id, value, showCount, showCount, 1.0f);
    }

    public PanelItemSlot(IGuiRect rect, int id, BigItemStack value, boolean showCount, boolean oreDict, float interval) {
        super(rect, id, "", value);
        this.showCount = showCount;
        this.oreDict = oreDict;
        this.interval = interval;
        this.setTextures(PresetTexture.ITEM_FRAME.getTexture(), PresetTexture.ITEM_FRAME.getTexture(), new LayeredTexture(PresetTexture.ITEM_FRAME.getTexture(), new ColorTexture(PresetColor.ITEM_HIGHLIGHT.getColor(), new GuiPadding(1, 1, 1, 1))));
        this.setStoredValue(value);
    }

    @Override
    public BigItemStack getStoredValue() {
        if (!this.oreVariants.isEmpty()) {
            return this.oreVariants.get((int)Math.floor((double)System.currentTimeMillis() / 1000.0 % (double)((float)this.oreVariants.size() * this.interval) / (double)this.interval));
        }
        return (BigItemStack)super.getStoredValue();
    }

    public PanelItemSlot setStoredValue(BigItemStack value) {
        super.setStoredValue(value);
        if (value != null) {
            Minecraft mc = Minecraft.func_71410_x();
            this.setIcon(this.oreDict || value.getBaseStack().func_77960_j() == Short.MAX_VALUE ? new OreDictTexture(this.interval, value, this.showCount, true) : new ItemTexture(value, this.showCount, true), 1);
            try {
                this.setTooltip(value.getBaseStack().func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x));
            }
            catch (NullPointerException ignored) {
                this.setTooltip(Collections.singletonList("" + EnumChatFormatting.RED + EnumChatFormatting.BOLD + EnumChatFormatting.ITALIC + "Broken tooltip. Please REPORT TO DEV."));
            }
        } else {
            this.setIcon(null);
            this.setTooltip(null);
        }
        this.updateOreStacks();
        return this;
    }

    @Override
    public List<String> getTooltip(int mx, int my) {
        BigItemStack ttStack = this.getStoredValue();
        if (ttStack == null || !this.getTransform().contains(mx, my)) {
            return null;
        }
        if (this.oreDict && this.oreVariants.size() > 0) {
            ttStack = this.oreVariants.get((int)((double)System.currentTimeMillis() / 1000.0) % this.oreVariants.size());
        }
        if (ttStack != null) {
            Minecraft mc = Minecraft.func_71410_x();
            return ttStack.getBaseStack().func_82840_a((EntityPlayer)mc.field_71439_g, mc.field_71474_y.field_82882_x);
        }
        return null;
    }

    private void updateOreStacks() {
        if (this.oreVariants == null) {
            return;
        }
        this.oreVariants.clear();
        BigItemStack stack = this.getStoredValue();
        if (stack == null) {
            return;
        }
        if (!stack.hasOreDict()) {
            if (stack.getBaseStack().func_77960_j() == Short.MAX_VALUE) {
                ArrayList subItems = new ArrayList();
                stack.getBaseStack().func_77973_b().func_150895_a(stack.getBaseStack().func_77973_b(), CreativeTabs.field_78027_g, subItems);
                for (ItemStack sStack : subItems) {
                    BigItemStack bStack = new BigItemStack(sStack);
                    bStack.stackSize = stack.stackSize;
                    this.oreVariants.add(bStack);
                }
            } else {
                this.oreVariants.add(stack);
            }
            return;
        }
        for (ItemStack iStack : stack.getOreIngredient().getMatchingStacks()) {
            if (iStack.func_77960_j() == Short.MAX_VALUE) {
                ArrayList subItems = new ArrayList();
                iStack.func_77973_b().func_150895_a(iStack.func_77973_b(), CreativeTabs.field_78027_g, subItems);
                for (ItemStack sStack : subItems) {
                    BigItemStack bStack = new BigItemStack(sStack);
                    bStack.stackSize = stack.stackSize;
                    this.oreVariants.add(bStack);
                }
                continue;
            }
            BigItemStack bStack = new BigItemStack(iStack);
            bStack.stackSize = stack.stackSize;
            this.oreVariants.add(bStack);
        }
    }
}

