/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widgets;

import com.cleanroommc.modularui.ModularUI;
import com.cleanroommc.modularui.api.ITheme;
import com.cleanroommc.modularui.api.drawable.IDrawable;
import com.cleanroommc.modularui.api.drawable.IKey;
import com.cleanroommc.modularui.api.widget.Interactable;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.drawable.text.TextRenderer;
import com.cleanroommc.modularui.integration.nei.NEIDragAndDropHandler;
import com.cleanroommc.modularui.integration.nei.NEIIngredientProvider;
import com.cleanroommc.modularui.network.NetworkUtils;
import com.cleanroommc.modularui.screen.ModularScreen;
import com.cleanroommc.modularui.screen.RichTooltip;
import com.cleanroommc.modularui.screen.viewport.GuiContext;
import com.cleanroommc.modularui.screen.viewport.ModularGuiContext;
import com.cleanroommc.modularui.theme.WidgetSlotTheme;
import com.cleanroommc.modularui.theme.WidgetTheme;
import com.cleanroommc.modularui.utils.Alignment;
import com.cleanroommc.modularui.utils.Color;
import com.cleanroommc.modularui.utils.MouseData;
import com.cleanroommc.modularui.utils.NumberFormat;
import com.cleanroommc.modularui.value.sync.FluidSlotSyncHandler;
import com.cleanroommc.modularui.value.sync.SyncHandler;
import com.cleanroommc.modularui.widget.Widget;
import gregtech.api.util.GTUtility;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class FluidSlot
extends Widget<FluidSlot>
implements Interactable,
NEIDragAndDropHandler,
NEIIngredientProvider {
    public static final int DEFAULT_SIZE = 18;
    private static final String UNIT_BUCKET = "B";
    private static final String UNIT_LITER = "L";
    private static final IFluidTank EMPTY = new FluidTank(0);
    private final TextRenderer textRenderer = new TextRenderer();
    private FluidSlotSyncHandler syncHandler;
    private int contentOffsetX = 1;
    private int contentOffsetY = 1;
    private boolean alwaysShowFull = true;
    @Nullable
    private IDrawable overlayTexture = null;

    public FluidSlot() {
        this.size(18);
        this.tooltip().setAutoUpdate(true);
        this.tooltipBuilder(this::addToolTip);
    }

    protected void addToolTip(RichTooltip tooltip) {
        IFluidTank fluidTank = this.getFluidTank();
        FluidStack fluid = this.syncHandler.getValue();
        if (this.syncHandler.isPhantom()) {
            if (fluid != null) {
                tooltip.addFromFluid(fluid);
                if (this.syncHandler.controlsAmount()) {
                    tooltip.addLine(IKey.lang("modularui2.fluid.phantom.amount", this.formatFluidAmount(fluid.amount), this.getBaseUnit()));
                }
                this.addAdditionalFluidInfo(tooltip, fluid);
            } else {
                tooltip.addLine(IKey.lang("modularui2.fluid.empty"));
            }
            if (this.syncHandler.controlsAmount()) {
                tooltip.addLine(IKey.lang("modularui2.fluid.phantom.control"));
            } else {
                tooltip.addLine(IKey.lang("modularui2.fluid.phantom.clear"));
            }
        } else {
            if (fluid != null) {
                tooltip.addFromFluid(fluid);
                tooltip.addLine(IKey.lang("modularui2.fluid.amount", this.formatFluidAmount(fluid.amount), this.formatFluidAmount(fluidTank.getCapacity()), this.getBaseUnit()));
                this.addAdditionalFluidInfo(tooltip, fluid);
            } else {
                tooltip.addLine(IKey.lang("modularui2.fluid.empty"));
            }
            if (this.syncHandler.canFillSlot() || this.syncHandler.canDrainSlot()) {
                tooltip.addLine(IKey.EMPTY);
                if (Interactable.hasShiftDown()) {
                    if (this.syncHandler.canFillSlot() && this.syncHandler.canDrainSlot()) {
                        tooltip.addLine(IKey.lang("modularui2.fluid.click_combined"));
                    } else if (this.syncHandler.canDrainSlot()) {
                        tooltip.addLine(IKey.lang("modularui2.fluid.click_to_fill"));
                    } else if (this.syncHandler.canFillSlot()) {
                        tooltip.addLine(IKey.lang("modularui2.fluid.click_to_empty"));
                    }
                } else {
                    tooltip.addLine(IKey.lang("modularui.tooltip.shift"));
                }
            }
        }
    }

    public void addAdditionalFluidInfo(RichTooltip tooltip, FluidStack fluidStack) {
        tooltip.addAdditionalInfoFromFluid(fluidStack);
    }

    public String formatFluidAmount(double amount) {
        NumberFormat.FORMAT.setMaximumFractionDigits(3);
        return NumberFormat.FORMAT.format(this.getBaseUnitAmount(amount));
    }

    protected double getBaseUnitAmount(double amount) {
        return amount;
    }

    protected String getBaseUnit() {
        return UNIT_LITER;
    }

    @Override
    public void onInit() {
        this.textRenderer.setShadow(true);
        this.textRenderer.setScale(0.5f);
        this.textRenderer.setColor(Color.WHITE.main);
    }

    @Override
    public boolean isValidSyncHandler(SyncHandler syncHandler) {
        this.syncHandler = this.castIfTypeElseNull(syncHandler, FluidSlotSyncHandler.class);
        return this.syncHandler != null;
    }

    @Override
    public void draw(ModularGuiContext context, WidgetTheme widgetTheme) {
        IFluidTank fluidTank = this.getFluidTank();
        FluidStack content = this.getFluidStack();
        if (content != null) {
            int y = this.contentOffsetY;
            float height = this.getArea().height - y * 2;
            if (!this.alwaysShowFull) {
                float newHeight = height * (float)content.amount * 1.0f / (float)fluidTank.getCapacity();
                y += (int)(height - newHeight);
                height = newHeight;
            }
            GuiDraw.drawFluidTexture(content, this.contentOffsetX, y, this.getArea().width - this.contentOffsetX * 2, height, 0.0f);
        }
        if (this.overlayTexture != null) {
            this.overlayTexture.drawAtZero((GuiContext)context, this.getArea(), widgetTheme);
        }
        if (content != null && this.syncHandler.controlsAmount()) {
            String s = NumberFormat.formatWithMaxDigits(this.getBaseUnitAmount(content.amount)) + this.getBaseUnit();
            this.textRenderer.setAlignment(Alignment.CenterRight, (float)(this.getArea().width - this.contentOffsetX) - 1.0f);
            this.textRenderer.setPos((int)((float)this.contentOffsetX + 0.5f), (int)((float)this.getArea().height - 5.5f));
            this.textRenderer.draw(s);
        }
        if (this.isHovering()) {
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            GuiDraw.drawRect(1.0f, 1.0f, this.getArea().w() - 2, this.getArea().h() - 2, this.getSlotHoverColor());
            GL11.glColorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @Override
    public WidgetSlotTheme getWidgetThemeInternal(ITheme theme) {
        return theme.getFluidSlotTheme();
    }

    public int getSlotHoverColor() {
        WidgetTheme theme = this.getWidgetTheme(this.getContext().getTheme());
        if (theme instanceof WidgetSlotTheme) {
            WidgetSlotTheme slotTheme = (WidgetSlotTheme)theme;
            return slotTheme.getSlotHoverColor();
        }
        return ITheme.getDefault().getFluidSlotTheme().getSlotHoverColor();
    }

    @Override
    @NotNull
    public Interactable.Result onMouseTapped(int mouseButton) {
        if (!this.syncHandler.canFillSlot() && !this.syncHandler.canDrainSlot()) {
            return Interactable.Result.IGNORE;
        }
        ItemStack cursorStack = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (this.syncHandler.isPhantom() || cursorStack != null) {
            MouseData mouseData = MouseData.create(mouseButton);
            this.syncHandler.syncToServer(1, mouseData::writeToPacket);
        }
        return Interactable.Result.SUCCESS;
    }

    @Override
    public boolean onMouseScroll(ModularScreen.UpOrDown scrollDirection, int amount) {
        if (this.syncHandler.isPhantom()) {
            if (scrollDirection.isUp() && !this.syncHandler.canFillSlot() || scrollDirection.isDown() && !this.syncHandler.canDrainSlot()) {
                return false;
            }
            MouseData mouseData = MouseData.create(scrollDirection.modifier);
            this.syncHandler.syncToServer(2, mouseData::writeToPacket);
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public Interactable.Result onKeyPressed(char typedChar, int keyCode) {
        if (keyCode == 42 || keyCode == 54) {
            this.markTooltipDirty();
        }
        return Interactable.super.onKeyPressed(typedChar, keyCode);
    }

    @Override
    public boolean onKeyRelease(char typedChar, int keyCode) {
        if (keyCode == 42 || keyCode == 54) {
            this.markTooltipDirty();
        }
        return Interactable.super.onKeyRelease(typedChar, keyCode);
    }

    @Nullable
    public FluidStack getFluidStack() {
        return this.syncHandler == null ? null : this.syncHandler.getValue();
    }

    public IFluidTank getFluidTank() {
        return this.syncHandler == null ? EMPTY : this.syncHandler.getFluidTank();
    }

    public FluidSlot contentOffset(int x, int y) {
        this.contentOffsetX = x;
        this.contentOffsetY = y;
        return this;
    }

    public FluidSlot alwaysShowFull(boolean alwaysShowFull) {
        this.alwaysShowFull = alwaysShowFull;
        return this;
    }

    public FluidSlot overlayTexture(@Nullable IDrawable overlayTexture) {
        this.overlayTexture = overlayTexture;
        return this;
    }

    public FluidSlot syncHandler(IFluidTank fluidTank) {
        return this.syncHandler(new FluidSlotSyncHandler(fluidTank));
    }

    public FluidSlot syncHandler(FluidSlotSyncHandler syncHandler) {
        this.setSyncHandler(syncHandler);
        this.syncHandler = syncHandler;
        return this;
    }

    @Override
    public boolean handleDragAndDrop(@NotNull ItemStack draggedStack, int button) {
        if (!this.syncHandler.isPhantom()) {
            return false;
        }
        MouseData mouseData = MouseData.create(button);
        this.syncHandler.syncToServer(4, buffer -> {
            mouseData.writeToPacket(buffer);
            NetworkUtils.writeItemStack(buffer, draggedStack);
        });
        draggedStack.field_77994_a = 0;
        return true;
    }

    protected void setPhantomValue(@NotNull ItemStack draggedStack) {
        this.syncHandler.setValue(FluidContainerRegistry.getFluidForFilledItem((ItemStack)draggedStack));
    }

    @Override
    @Nullable
    public ItemStack getStackForNEI() {
        if (ModularUI.isGT5ULoaded) {
            return GTUtility.getFluidDisplayStack((FluidStack)this.getFluidStack(), (boolean)false);
        }
        return null;
    }
}

