/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.utils.vect;

import forestry.api.farming.FarmDirection;
import forestry.core.utils.vect.IVect;
import forestry.core.utils.vect.Vect;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class MutableVect
implements IVect {
    public int x;
    public int y;
    public int z;

    public MutableVect() {
        this(0, 0, 0);
    }

    public MutableVect(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public MutableVect(ForgeDirection direction) {
        this.x = direction.offsetX;
        this.y = direction.offsetY;
        this.z = direction.offsetZ;
    }

    public MutableVect(int[] dim) {
        if (dim.length != 3) {
            throw new RuntimeException("Cannot instantiate a vector with less or more than 3 points.");
        }
        this.x = dim[0];
        this.y = dim[1];
        this.z = dim[2];
    }

    public MutableVect(ChunkCoordinates coordinates) {
        this.x = coordinates.field_71574_a;
        this.y = coordinates.field_71572_b;
        this.z = coordinates.field_71573_c;
    }

    public MutableVect(IVect vect) {
        this.x = vect.getX();
        this.y = vect.getY();
        this.z = vect.getZ();
    }

    @Override
    public MutableVect add(IVect other) {
        this.x += other.getX();
        this.y += other.getY();
        this.z += other.getZ();
        return this;
    }

    @Override
    public MutableVect add(int x, int y, int z) {
        this.x += x;
        this.y += y;
        this.z += z;
        return this;
    }

    @Override
    public MutableVect add(ForgeDirection direction) {
        this.x += direction.offsetX;
        this.y += direction.offsetY;
        this.z += direction.offsetZ;
        return this;
    }

    @Override
    public MutableVect add(FarmDirection direction) {
        return this.add(direction.getForgeDirection());
    }

    @Override
    public MutableVect add(ChunkCoordinates coordinates) {
        this.x += coordinates.field_71574_a;
        this.y += coordinates.field_71572_b;
        this.z += coordinates.field_71573_c;
        return this;
    }

    @Override
    public int[] toArray() {
        return new int[]{this.x, this.y, this.z};
    }

    @Override
    public MutableVect multiply(float factor) {
        this.x = Math.round((float)this.x * factor);
        this.y = Math.round((float)this.y * factor);
        this.z = Math.round((float)this.z * factor);
        return this;
    }

    @Override
    public IVect multiply(int factor) {
        this.x *= factor;
        this.y *= factor;
        this.z *= factor;
        return this;
    }

    public boolean advancePositionInArea(Vect area) {
        if (this.z < area.z - 1) {
            ++this.z;
        } else {
            this.z = 0;
            if (this.x < area.x - 1) {
                ++this.x;
            } else {
                this.x = 0;
                if (this.y < area.y - 1) {
                    ++this.y;
                } else {
                    return false;
                }
            }
        }
        return true;
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getZ() {
        return this.z;
    }

    public MutableVect setX(int x) {
        this.x = x;
        return this;
    }

    public MutableVect setY(int y) {
        this.y = y;
        return this;
    }

    public MutableVect setZ(int z) {
        this.z = z;
        return this;
    }

    public MutableVect set(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public MutableVect set(IVect vect) {
        this.x = vect.getX();
        this.y = vect.getY();
        this.z = vect.getZ();
        return this;
    }

    public MutableVect set(ChunkCoordinates coordinates) {
        this.x = coordinates.field_71574_a;
        this.y = coordinates.field_71572_b;
        this.z = coordinates.field_71573_c;
        return this;
    }

    public MutableVect set(ForgeDirection direction) {
        this.x = direction.offsetX;
        this.y = direction.offsetY;
        this.z = direction.offsetZ;
        return this;
    }

    public MutableVect set(FarmDirection direction) {
        return this.set(direction.getForgeDirection());
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof IVect) {
            IVect other = (IVect)obj;
            return this.x == other.getX() && this.y == other.getY() && this.z == other.getZ();
        }
        return false;
    }

    @Override
    public Vect asImmutable() {
        return new Vect(this.x, this.y, this.z);
    }

    @Override
    public MutableVect asMutable() {
        return this;
    }
}

