/*
 * Decompiled with CFR 0.152.
 */
package com.kuba6000.mobsinfo.mixin;

import com.kuba6000.mobsinfo.mixin.TargetedMod;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

public enum Mixin {
    EnchantmentHelperMixin("minecraft.EnchantmentHelperMixin", TargetedMod.VANILLA),
    EntityAccessor("minecraft.EntityAccessor", TargetedMod.VANILLA),
    EntityLivingAccessor("minecraft.EntityLivingAccessor", TargetedMod.VANILLA),
    EntityLivingBaseAccessor("minecraft.EntityLivingBaseAccessor", TargetedMod.VANILLA),
    EntitySlimeAccessor("minecraft.EntitySlimeAccessor", TargetedMod.VANILLA),
    EntityVillagerAccessor("minecraft.EntityVillagerAccessor", TargetedMod.VANILLA),
    EventBusAccessor("minecraft.EventBusAccessor", TargetedMod.VANILLA),
    RendererLivingEntityAccessor("minecraft.RendererLivingEntityAccessor", TargetedMod.VANILLA),
    GuiAccessor("minecraft.GuiAccessor", TargetedMod.VANILLA),
    GuiContainerAccessor("minecraft.GuiContainerAccessor", TargetedMod.VANILLA),
    ASMEventHandlerAccessor("minecraft.ASMEventHandlerAccessor", TargetedMod.VANILLA),
    VillagerRegistryAccessor("minecraft.VillagerRegistryAccessor", TargetedMod.VANILLA),
    InfernalMobsCoreAccessor("InfernalMobs.InfernalMobsCoreAccessor", TargetedMod.INFERNAL_MOBS),
    ItemSoulVesselAccessor("EnderIO.ItemSoulVesselAccessor", TargetedMod.ENDER_IO),
    BlockPoweredSpawnerAccessor("EnderIO.BlockPoweredSpawnerAccessor", TargetedMod.ENDER_IO),
    MinecraftForgeEventHandlerAccessor("DraconicEvolution.MinecraftForgeEventHandlerAccessor", TargetedMod.DRACONIC_EVOLUTION),
    RenderMobSoulMixin("DraconicEvolution.RenderMobSoulMixin", TargetedMod.DRACONIC_EVOLUTION, TargetedMod.BATTLE_GEAR_2),
    FuncCalcMobParamMixin("DQRespect.FuncCalcMobParamMixin", TargetedMod.DQ_RESPECT),
    DqmEntitySweetbagMixin("DQRespect.DqmEntitySweetbagMixin", TargetedMod.DQ_RESPECT),
    EntityAnimalChocoboMixin("ChocoCraft.EntityAnimalChocoboMixin", TargetedMod.CHOCO_CRAFT),
    EntityMobLouseMixin("HardcoreEnderExpansion.EntityMobLouseMixin", TargetedMod.HARDCORE_ENDER_EXPANSION),
    EntityMobHomelandEndermanMixin("HardcoreEnderExpansion.EntityMobHomelandEndermanMixin", TargetedMod.HARDCORE_ENDER_EXPANSION),
    EntityButterflyMixin("Forestry.EntityButterflyMixin", TargetedMod.FORESTRY);

    public final String mixinClass;
    public final List<TargetedMod> targetedMods;
    private final Side side;
    private final Phase phase;

    private Mixin(String mixinClass, TargetedMod ... targetedMods) {
        this.mixinClass = mixinClass;
        this.targetedMods = Arrays.asList(targetedMods);
        this.side = Side.BOTH;
        this.phase = this.targetedMods.size() == 1 && this.targetedMods.contains((Object)TargetedMod.VANILLA) ? Phase.EARLY : Phase.LATE;
    }

    public static List<String> getEarlyMixins(Set<String> loadedCoreMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        for (Mixin mixin : Mixin.values()) {
            if (mixin.phase != Phase.EARLY) continue;
            mixins.add(mixin.mixinClass);
        }
        return mixins;
    }

    public static List<String> getLateMixins(Set<String> loadedMods) {
        ArrayList<String> mixins = new ArrayList<String>();
        for (Mixin mixin : Mixin.values()) {
            if (mixin.phase != Phase.LATE || !mixin.shouldLoad(loadedMods)) continue;
            mixins.add(mixin.mixinClass);
        }
        return mixins;
    }

    private boolean shouldLoad(Set<String> loadedMods) {
        return this.shouldLoadSide() && this.allModsLoaded(loadedMods);
    }

    private boolean shouldLoadSide() {
        return this.side == Side.BOTH || this.side == Side.SERVER && FMLLaunchHandler.side().isServer() || this.side == Side.CLIENT && FMLLaunchHandler.side().isClient();
    }

    private boolean allModsLoaded(Set<String> loadedMods) {
        if (this.targetedMods.isEmpty()) {
            return false;
        }
        for (TargetedMod target : this.targetedMods) {
            if (target == TargetedMod.VANILLA || target.modId == null || loadedMods.isEmpty() || loadedMods.contains(target.modId)) continue;
            return false;
        }
        return true;
    }

    private static enum Side {
        BOTH,
        CLIENT,
        SERVER;

    }

    private static enum Phase {
        EARLY,
        LATE;

    }
}

