/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.biome;

import chylex.hee.entity.boss.EntityBossDragon;
import chylex.hee.system.logging.Log;
import chylex.hee.system.logging.Stopwatch;
import chylex.hee.system.util.MathUtil;
import chylex.hee.world.biome.BiomeGenHardcoreEnd;
import chylex.hee.world.feature.WorldGenBlob;
import chylex.hee.world.feature.WorldGenEndPowderOre;
import chylex.hee.world.feature.WorldGenEndiumOre;
import chylex.hee.world.feature.WorldGenEnergyCluster;
import chylex.hee.world.feature.WorldGenMeteoroid;
import chylex.hee.world.feature.WorldGenObsidianSpike;
import chylex.hee.world.util.WorldGenChance;
import cpw.mods.fml.common.eventhandler.Event;
import net.minecraft.entity.Entity;
import net.minecraft.world.biome.BiomeEndDecorator;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.terraingen.OreGenEvent;

public class BiomeDecoratorHardcoreEnd
extends BiomeEndDecorator {
    private final WorldGenBlob blobGen;
    private final WorldGenMeteoroid meteoroidGen;
    private final WorldGenEndPowderOre endPowderOreGen;
    private final WorldGenEndiumOre endiumOreGen;
    private final WorldGenEnergyCluster clusterGen;

    public BiomeDecoratorHardcoreEnd() {
        this.field_76835_L = new WorldGenObsidianSpike();
        this.blobGen = new WorldGenBlob();
        this.meteoroidGen = new WorldGenMeteoroid();
        this.endPowderOreGen = new WorldGenEndPowderOre();
        this.endiumOreGen = new WorldGenEndiumOre();
        this.clusterGen = new WorldGenEnergyCluster();
    }

    protected void func_150513_a(BiomeGenBase biome) {
        int attempt;
        if (this.field_76815_a.field_73011_w.field_76574_g != 1) {
            super.func_150513_a(biome);
            return;
        }
        this.func_76797_b();
        double distFromCenter = MathUtil.distance(this.field_76814_c >> 4, this.field_76811_d >> 4) * 16.0;
        if (distFromCenter < 120.0 && this.field_76813_b.nextInt(5) == 0) {
            Stopwatch.timeAverage("WorldGenObsidianSpike", 4);
            int xx = this.randX();
            int zz = this.randZ();
            this.field_76835_L.func_76484_a(this.field_76815_a, this.field_76813_b, xx, this.field_76815_a.func_72825_h(xx, zz), zz);
            Stopwatch.finish("WorldGenObsidianSpike");
        }
        if (distFromCenter > 102.0 && Math.abs(this.field_76813_b.nextGaussian()) < 0.285) {
            Stopwatch.timeAverage("WorldGenBlob", 64);
            this.tryGenerate(this.blobGen, this.field_76814_c + 16, 32 + this.field_76813_b.nextInt(60), this.field_76811_d + 16);
            Stopwatch.finish("WorldGenBlob");
        }
        if (distFromCenter > 320.0 && this.checkChance(0.12 + 0.45 * WorldGenChance.cubic2Incr.calculate(distFromCenter, 320.0, 6400.0)) && this.field_76813_b.nextDouble() * this.field_76813_b.nextDouble() > 0.65) {
            Stopwatch.timeAverage("WorldGenEnergyCluster", 64);
            for (int a = 0; a < this.field_76813_b.nextInt(4); ++a) {
                this.clusterGen.func_76484_a(this.field_76815_a, this.field_76813_b, this.field_76814_c + 8, 0, this.field_76811_d + 8);
                if (!this.checkChance(0.1 + 0.8 * WorldGenChance.linear2Incr.calculate(distFromCenter, 320.0, 6400.0))) break;
            }
            Stopwatch.finish("WorldGenEnergyCluster");
        }
        if (distFromCenter > 500.0 && this.checkChance(0.34 + 0.6 * WorldGenChance.cubic2Incr.calculate(distFromCenter, 500.0, 12000.0))) {
            Stopwatch.timeAverage("WorldGenEndiumOre", 64);
            int max = 1 + this.field_76813_b.nextInt(1 + this.field_76813_b.nextInt(2 + MathUtil.ceil(9.0 * WorldGenChance.linear2Incr.calculate(distFromCenter, 1500.0, 21000.0))));
            for (attempt = 0; !(attempt >= 440 || this.tryGenerate(this.endiumOreGen, this.randX(), 10 + this.field_76813_b.nextInt(100), this.randZ()) && --max <= 0); ++attempt) {
            }
            Stopwatch.finish("WorldGenEndiumOre");
        }
        if (distFromCenter > 1280.0 && this.checkChance(WorldGenChance.linear3IncrDecr.calculate(distFromCenter, 1280.0, 2700.0, 15000.0)) && this.field_76813_b.nextFloat() * this.field_76813_b.nextFloat() > 0.666f) {
            Stopwatch.timeAverage("WorldGenMeteoroid", 64);
            for (attempt = 0; attempt < this.field_76813_b.nextInt(3); ++attempt) {
                this.tryGenerate(this.meteoroidGen, this.randX(), 8 + this.field_76813_b.nextInt(112), this.randZ());
            }
            Stopwatch.finish("WorldGenMeteoroid");
        }
        Stopwatch.timeAverage("WorldGenEndPowderOre", 64);
        int placed = 0;
        for (attempt = 0; attempt < 22 && placed < 4 + this.field_76813_b.nextInt(5); ++attempt) {
            if (!this.tryGenerate(this.endPowderOreGen, this.randX(), 35 + this.field_76813_b.nextInt(92), this.randZ())) continue;
            ++placed;
        }
        Stopwatch.finish("WorldGenEndPowderOre");
        if (this.field_76814_c == 0 && this.field_76811_d == 0) {
            EntityBossDragon dragon = new EntityBossDragon(this.field_76815_a);
            dragon.func_70012_b(0.0, 128.0, 0.0, this.field_76813_b.nextFloat() * 360.0f, 0.0f);
            this.field_76815_a.func_72838_d((Entity)dragon);
        }
    }

    protected void func_76797_b() {
        if (!BiomeGenHardcoreEnd.overrideWorldGen) {
            MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Pre(this.field_76815_a, this.field_76813_b, this.field_76814_c, this.field_76811_d));
            MinecraftForge.ORE_GEN_BUS.post((Event)new OreGenEvent.Post(this.field_76815_a, this.field_76813_b, this.field_76814_c, this.field_76811_d));
        }
    }

    private int randX() {
        return this.field_76814_c + this.field_76813_b.nextInt(16) + 8;
    }

    private int randZ() {
        return this.field_76811_d + this.field_76813_b.nextInt(16) + 8;
    }

    private boolean checkChance(double chance) {
        return WorldGenChance.checkChance(chance, this.field_76813_b);
    }

    private boolean tryGenerate(WorldGenerator generator, int x, int y, int z) {
        try {
            return generator.func_76484_a(this.field_76815_a, this.field_76813_b, x, y, z);
        }
        catch (RuntimeException e) {
            Log.warn("Failed generating " + generator.getClass().getSimpleName() + " at " + (this.field_76814_c + x) + "," + (this.field_76811_d + z) + ", there might be an empty chunk.", new Object[0]);
            return false;
        }
    }
}

