/*
 * Decompiled with CFR 0.152.
 */
package chylex.hee.world.structure.island.biome.feature.island;

import chylex.hee.system.logging.Stopwatch;
import chylex.hee.world.structure.island.biome.feature.AbstractIslandStructure;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryGenerator;
import chylex.hee.world.structure.island.biome.feature.island.laboratory.LaboratoryPlan;
import java.util.Random;

public class StructureLaboratory
extends AbstractIslandStructure {
    @Override
    protected boolean generate(Random rand) {
        LaboratoryPlan plan = new LaboratoryPlan();
        LaboratoryPlan bestPlan = null;
        int attemptsGeneral = 500;
        int attemptsSuccess = 120;
        Stopwatch.time("StructureLaboratory - generate plan");
        do {
            if (!plan.generate(this.world, rand)) continue;
            --attemptsSuccess;
            if (bestPlan != null && plan.getScore() <= bestPlan.getScore()) continue;
            bestPlan = plan.copy();
        } while (--attemptsGeneral > 0 && attemptsSuccess > 0 && (bestPlan == null || bestPlan.getScore() < 400));
        Stopwatch.finish("StructureLaboratory - generate plan");
        if (bestPlan == null) {
            return false;
        }
        Stopwatch.time("StructureLaboratory - generate blocks");
        new LaboratoryGenerator(bestPlan).generateInWorld(this.world, rand);
        Stopwatch.finish("StructureLaboratory - generate blocks");
        return true;
    }
}

