/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.glsm.stacks;

import com.gtnewhorizon.gtnhlib.client.renderer.stacks.IStateStack;
import com.gtnewhorizons.angelica.glsm.GLStateManager;
import com.gtnewhorizons.angelica.glsm.states.IntegerState;

public class IntegerStateStack
extends IntegerState
implements IStateStack<IntegerStateStack> {
    protected final IntegerState[] stack;
    protected int pointer;

    public IntegerStateStack(int val) {
        this.setValue(val);
        this.stack = new IntegerState[GLStateManager.MAX_ATTRIB_STACK_DEPTH];
        for (int i = 0; i < GLStateManager.MAX_ATTRIB_STACK_DEPTH; ++i) {
            this.stack[i] = new IntegerState();
            this.stack[i].setValue(val);
        }
    }

    public IntegerStateStack push() {
        if (this.pointer == this.stack.length) {
            throw new IllegalStateException("Stack overflow size " + (this.pointer + 1) + " reached");
        }
        this.stack[this.pointer++].set(this);
        return this;
    }

    public IntegerStateStack push(int value) {
        this.push().setValue(value);
        return this;
    }

    public IntegerStateStack pop() {
        if (this.pointer == 0) {
            throw new IllegalStateException("Stack underflow");
        }
        this.set(this.stack[--this.pointer]);
        return this;
    }

    public boolean isEmpty() {
        return this.pointer == 0;
    }
}

