/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.sodium.vertex_format.terrain_xhfp;

import com.gtnewhorizons.angelica.compat.lwjgl.CompatMemoryUtil;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferView;
import me.jellysquid.mods.sodium.client.model.vertex.buffer.VertexBufferWriterUnsafe;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexSink;
import me.jellysquid.mods.sodium.client.render.chunk.format.ModelVertexUtil;
import net.coderbot.iris.sodium.block_context.BlockContextHolder;
import net.coderbot.iris.sodium.block_context.ContextAwareVertexWriter;
import net.coderbot.iris.sodium.vertex_format.IrisModelVertexFormats;
import net.coderbot.iris.sodium.vertex_format.terrain_xhfp.QuadViewTerrain;
import net.coderbot.iris.vertices.ExtendedDataHelper;
import net.coderbot.iris.vertices.NormalHelper;
import org.joml.Vector3f;

public class XHFPModelVertexBufferWriterUnsafe
extends VertexBufferWriterUnsafe
implements ModelVertexSink,
ContextAwareVertexWriter {
    private final QuadViewTerrain.QuadViewTerrainUnsafe quad = new QuadViewTerrain.QuadViewTerrainUnsafe();
    private final Vector3f normal = new Vector3f();
    private BlockContextHolder contextHolder;
    private int vertexCount;
    private float uSum;
    private float vSum;

    public XHFPModelVertexBufferWriterUnsafe(VertexBufferView backingBuffer) {
        super(backingBuffer, IrisModelVertexFormats.MODEL_VERTEX_XHFP);
    }

    @Override
    public void writeQuad(float x, float y, float z, int color, float u, float v, int light) {
        this.uSum += u;
        this.vSum += v;
        this.writeQuadInternal(ModelVertexUtil.denormalizeVertexPositionFloatAsShort(x), ModelVertexUtil.denormalizeVertexPositionFloatAsShort(y), ModelVertexUtil.denormalizeVertexPositionFloatAsShort(z), color, ModelVertexUtil.denormalizeVertexTextureFloatAsShort(u), ModelVertexUtil.denormalizeVertexTextureFloatAsShort(v), light, this.contextHolder.blockId, this.contextHolder.renderType, ExtendedDataHelper.computeMidBlock(x, y, z, this.contextHolder.localPosX, this.contextHolder.localPosY, this.contextHolder.localPosZ));
    }

    private void writeQuadInternal(short x, short y, short z, int color, short u, short v, int light, short materialId, short renderType, int packedMidBlock) {
        long i = this.writePointer;
        ++this.vertexCount;
        CompatMemoryUtil.memPutShort(i, x);
        CompatMemoryUtil.memPutShort(i + 2L, y);
        CompatMemoryUtil.memPutShort(i + 4L, z);
        CompatMemoryUtil.memPutInt(i + 8L, color);
        CompatMemoryUtil.memPutShort(i + 12L, u);
        CompatMemoryUtil.memPutShort(i + 14L, v);
        CompatMemoryUtil.memPutShort(i + 16L, (short)(light & 0xFFFF));
        CompatMemoryUtil.memPutShort(i + 18L, (short)(light >> 16 & 0xFFFF));
        CompatMemoryUtil.memPutShort(i + 36L, materialId);
        CompatMemoryUtil.memPutShort(i + 38L, renderType);
        CompatMemoryUtil.memPutInt(i + 40L, packedMidBlock);
        if (this.vertexCount == 4) {
            this.vertexCount = 0;
            this.uSum *= 0.25f;
            this.vSum *= 0.25f;
            CompatMemoryUtil.memPutFloat(i + 20L, this.uSum);
            CompatMemoryUtil.memPutFloat(i + 20L - 44L, this.uSum);
            CompatMemoryUtil.memPutFloat(i + 20L - 88L, this.uSum);
            CompatMemoryUtil.memPutFloat(i + 20L - 132L, this.uSum);
            CompatMemoryUtil.memPutFloat(i + 24L, this.vSum);
            CompatMemoryUtil.memPutFloat(i + 24L - 44L, this.vSum);
            CompatMemoryUtil.memPutFloat(i + 24L - 88L, this.vSum);
            CompatMemoryUtil.memPutFloat(i + 24L - 132L, this.vSum);
            this.uSum = 0.0f;
            this.vSum = 0.0f;
            this.quad.setup(i, 44);
            NormalHelper.computeFaceNormal(this.normal, this.quad);
            int packedNormal = NormalHelper.packNormal(this.normal, 0.0f);
            CompatMemoryUtil.memPutInt(i + 32L, packedNormal);
            CompatMemoryUtil.memPutInt(i + 32L - 44L, packedNormal);
            CompatMemoryUtil.memPutInt(i + 32L - 88L, packedNormal);
            CompatMemoryUtil.memPutInt(i + 32L - 132L, packedNormal);
            int tangent = NormalHelper.computeTangent(this.normal.x, this.normal.y, this.normal.z, this.quad);
            CompatMemoryUtil.memPutInt(i + 28L, tangent);
            CompatMemoryUtil.memPutInt(i + 28L - 44L, tangent);
            CompatMemoryUtil.memPutInt(i + 28L - 88L, tangent);
            CompatMemoryUtil.memPutInt(i + 28L - 132L, tangent);
        }
        this.advance();
    }

    @Override
    public void iris$setContextHolder(BlockContextHolder holder) {
        this.contextHolder = holder;
    }
}

