/*
 * Decompiled with CFR 0.152.
 */
package goodgenerator.blocks.tileEntity;

import com.gtnewhorizon.structurelib.alignment.constructable.IConstructable;
import com.gtnewhorizon.structurelib.alignment.constructable.ISurvivalConstructable;
import com.gtnewhorizon.structurelib.structure.IStructureDefinition;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import com.gtnewhorizon.structurelib.structure.ISurvivalBuildEnvironment;
import com.gtnewhorizon.structurelib.structure.StructureDefinition;
import com.gtnewhorizon.structurelib.structure.StructureUtility;
import goodgenerator.api.recipe.ExtremeHeatExchangerRecipe;
import goodgenerator.api.recipe.GoodGeneratorRecipeMaps;
import goodgenerator.blocks.tileEntity.base.MTETooltipMultiBlockBaseEM;
import goodgenerator.loader.Loaders;
import goodgenerator.util.DescTextLocalization;
import gregtech.api.GregTechAPI;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.HatchElement;
import gregtech.api.enums.Textures;
import gregtech.api.interfaces.IHatchElement;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.metatileentity.implementations.MTEHatchInput;
import gregtech.api.metatileentity.implementations.MTEHatchOutput;
import gregtech.api.multitileentity.multiblock.casing.Glasses;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTStructureUtility;
import gregtech.api.util.GTUtility;
import gregtech.api.util.IGTHatchAdder;
import gregtech.api.util.MultiblockTooltipBuilder;
import gregtech.common.tileentities.machines.IRecipeProcessingAwareHatch;
import gregtech.common.tileentities.machines.MTEHatchInputME;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class MTEExtremeHeatExchanger
extends MTETooltipMultiBlockBaseEM
implements IConstructable,
ISurvivalConstructable {
    protected IStructureDefinition<MTEExtremeHeatExchanger> multiDefinition = null;
    public static double penalty_per_config = 0.015;
    protected int casingAmount = 0;
    protected MTEHatchInput mHotFluidHatch;
    protected MTEHatchOutput mCooledFluidHatch;
    private boolean transformed = false;
    private String hotName;
    private ExtremeHeatExchangerRecipe tRunningRecipe;

    public MTEExtremeHeatExchanger(String name) {
        super(name);
    }

    public MTEExtremeHeatExchanger(int id, String name, String nameRegional) {
        super(id, name, nameRegional);
    }

    public IStructureDefinition<MTEExtremeHeatExchanger> getStructure_EM() {
        if (this.multiDefinition == null) {
            this.multiDefinition = StructureDefinition.builder().addShape(this.mName, StructureUtility.transpose((String[][])new String[][]{{" CCC ", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", "TTTTT", " CCC "}, {" CCC ", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", " CCC "}, {" CFC ", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", " CEC "}, {" CCC ", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", " CCC "}, {" CCC ", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", "GWWWG", "GPPPG", " CCC "}, {" C~C ", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", "BBBBB", " CCC "}})).addElement('B', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEExtremeHeatExchanger.class).atLeast(HatchElement.InputHatch, HatchElement.Maintenance).casingIndex(48).dot(1).build(), StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)0))})).addElement('T', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEExtremeHeatExchanger.class).atLeast(HatchElement.OutputHatch, HatchElement.Maintenance).casingIndex(48).dot(2).build(), StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)0))})).addElement('F', EHEHatches.HotInputHatch.newAny(48, 3)).addElement('E', EHEHatches.ColdOutputHatch.newAny(48, 4)).addElement('C', (IStructureElement)StructureUtility.ofChain((IStructureElement[])new IStructureElement[]{GTStructureUtility.buildHatchAdder(MTEExtremeHeatExchanger.class).atLeast(HatchElement.Maintenance).casingIndex(48).dot(5).build(), StructureUtility.onElementPass(x -> ++x.casingAmount, (IStructureElement)StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings4, (int)0))})).addElement('G', Glasses.chainAllGlasses()).addElement('P', StructureUtility.ofBlock((Block)GregTechAPI.sBlockCasings2, (int)15)).addElement('W', StructureUtility.ofBlock((Block)Loaders.pressureResistantWalls, (int)0)).build();
        }
        return this.multiDefinition;
    }

    public boolean addHotFluidInputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchInput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mHotFluidHatch = (MTEHatchInput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    public boolean addColdFluidOutputToMachineList(IGregTechTileEntity aTileEntity, int aBaseCasingIndex) {
        if (aTileEntity == null) {
            return false;
        }
        IMetaTileEntity aMetaTileEntity = aTileEntity.getMetaTileEntity();
        if (aMetaTileEntity == null) {
            return false;
        }
        if (aMetaTileEntity instanceof MTEHatchOutput) {
            ((MTEHatch)aMetaTileEntity).updateTexture(aBaseCasingIndex);
            this.mCooledFluidHatch = (MTEHatchOutput)aMetaTileEntity;
            return true;
        }
        return false;
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.transformed = aNBT.func_74767_n("transformed");
        if (aNBT.func_150297_b("hotName", 8)) {
            String loadedHotName = aNBT.func_74779_i("hotName");
            Fluid hotFluid = FluidRegistry.getFluid((String)loadedHotName);
            if (hotFluid != null) {
                this.hotName = loadedHotName;
                this.tRunningRecipe = (ExtremeHeatExchangerRecipe)GoodGeneratorRecipeMaps.extremeHeatExchangerFuels.getBackend().findFuel(hotFluid);
            }
        } else {
            this.hotName = null;
            this.tRunningRecipe = null;
        }
        super.loadNBTData(aNBT);
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74757_a("transformed", this.transformed);
        if (this.hotName != null) {
            aNBT.func_74778_a("hotName", this.hotName);
        }
        super.saveNBTData(aNBT);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return GoodGeneratorRecipeMaps.extremeHeatExchangerFuels;
    }

    @Override
    protected void clearHatches_EM() {
        super.clearHatches_EM();
        this.mCooledFluidHatch = null;
        this.mHotFluidHatch = null;
    }

    @Override
    public boolean checkMachine_EM(IGregTechTileEntity aBaseMetaTileEntity, ItemStack aStack) {
        this.casingAmount = 0;
        return this.structureCheck_EM(this.mName, 2, 5, 0) && this.mMaintenanceHatches.size() == 1 && this.casingAmount >= 25;
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType("Heat Exchanger, EHE").addInfo("Outputs SH steam by cooling hot fluids with distilled water.").addInfo("Supplying more hot fluid than the threshold causes overheating,").addInfo("producing SC steam instead.").addInfo("Plasma always produces SC steam.").addInfo("Maximum input and output values per second are shown in NEI.").addInfo("Actual output is proportional to the amount of hot fluid inserted.").addInfo("Explodes if it runs out of water.").addController("Front bottom").addCasingInfoRange("Robust Tungstensteel Machine Casings", 25, 120, false).addCasingInfoExactly("EV+ Glass", 72, false).addCasingInfoExactly("Pressure Resistant Wall", 48, false).addCasingInfoExactly("Tungstensteel Pipe Casing", 60, false).addOtherStructurePart("Input Hatch", "Distilled water", 1).addOtherStructurePart("Output Hatch", "SC Steam/SH Steam", 2).addOtherStructurePart("Input Hatch", "Hot fluid or plasma", 3).addOtherStructurePart("Output Hatch", "Cold fluid", 4).addMaintenanceHatch("Any Casing", 1, 2, 5).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    @NotNull
    public CheckRecipeResult checkProcessing_EM() {
        int circuit_config;
        this.tRunningRecipe = null;
        FluidStack hotFluid = null;
        MTEHatchInput mTEHatchInput = this.mHotFluidHatch;
        if (mTEHatchInput instanceof MTEHatchInputME) {
            MTEHatchInputME inputME = (MTEHatchInputME)mTEHatchInput;
            FluidStack[] fluids = inputME.getStoredFluids();
            if (fluids.length > 0) {
                hotFluid = fluids[0];
            }
        } else {
            hotFluid = this.mHotFluidHatch.getFluid();
        }
        if (hotFluid == null) {
            return CheckRecipeResultRegistry.SUCCESSFUL;
        }
        ExtremeHeatExchangerRecipe tRecipe = (ExtremeHeatExchangerRecipe)GoodGeneratorRecipeMaps.extremeHeatExchangerFuels.getBackend().findFuel(hotFluid);
        if (tRecipe == null) {
            return CheckRecipeResultRegistry.NO_RECIPE;
        }
        this.tRunningRecipe = tRecipe;
        this.hotName = hotFluid.getFluid().getName();
        int tMaxConsume = tRecipe.getMaxHotFluidConsume();
        int transformed_threshold = tRecipe.mSpecialValue;
        int tRealConsume = Math.min(tMaxConsume, hotFluid.amount);
        double penalty = 0.0;
        double efficiency = 1.0;
        int shs_reduction_per_config = 150;
        if (this.mInventory[1] != null && this.mInventory[1].func_77977_a().startsWith("gt.integrated_circuit") && (circuit_config = this.mInventory[1].func_77960_j()) >= 1 && circuit_config <= 25) {
            penalty = (double)(circuit_config - 1) * penalty_per_config;
            transformed_threshold -= shs_reduction_per_config * (circuit_config - 1);
        }
        efficiency -= penalty;
        if (transformed_threshold <= 0) {
            transformed_threshold = 1;
        }
        this.transformed = tRealConsume >= transformed_threshold;
        this.mMaxProgresstime = 20;
        this.mEUt = (int)((double)tRecipe.getEUt() * efficiency * ((double)tRealConsume / (double)tMaxConsume));
        this.mHotFluidHatch.drain(ForgeDirection.UNKNOWN, new FluidStack(hotFluid.getFluid(), tRealConsume), true);
        this.mCooledFluidHatch.fill(new FluidStack(tRecipe.getCooledFluid(), tRealConsume), true);
        this.mEfficiencyIncrease = 160;
        return CheckRecipeResultRegistry.SUCCESSFUL;
    }

    @Override
    public boolean onRunningTick(ItemStack aStack) {
        if (this.mEUt > 0 && this.tRunningRecipe != null) {
            Fluid tReadySteam = this.transformed ? this.tRunningRecipe.getHeatedSteam() : this.tRunningRecipe.getNormalSteam();
            int waterAmount = (int)((double)this.mEUt / this.getUnitSteamPower(tReadySteam.getName())) / 160;
            if (waterAmount < 0) {
                return false;
            }
            this.startRecipeProcessing();
            boolean isDepleteSuccess = this.depleteInput(GTModHandler.getDistilledWater(waterAmount));
            this.endRecipeProcessing();
            if (isDepleteSuccess) {
                int steamToOutput = this.tRunningRecipe.mFluidInputs[0].getUnlocalizedName().contains("plasma") ? waterAmount * 160 / 1000 : waterAmount * 160;
                this.addOutput(new FluidStack(tReadySteam, steamToOutput));
            } else {
                GTLog.exp.println(this.mName + " had no more Distilled water!");
                this.mHotFluidHatch.getBaseMetaTileEntity().doExplosion(GTValues.V[8]);
                return false;
            }
        }
        return true;
    }

    public double getUnitSteamPower(String steam) {
        double d;
        switch (steam) {
            case "steam": {
                d = 0.5;
                break;
            }
            case "ic2superheatedsteam": 
            case "supercriticalsteam": 
            case "densesupercriticalsteam": {
                d = 1.0;
                break;
            }
            default: {
                d = -1.0;
            }
        }
        return d;
    }

    public void construct(ItemStack stackSize, boolean hintsOnly) {
        this.structureBuild_EM(this.mName, 2, 5, 0, stackSize, hintsOnly);
    }

    @Override
    public String[] getStructureDescription(ItemStack stackSize) {
        return DescTextLocalization.addText("ExtremeHeatExchanger.hint", 6);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEExtremeHeatExchanger(this.mName);
    }

    @Override
    public int getMaxEfficiency(ItemStack aStack) {
        return 10000;
    }

    @Override
    public String[] getInfoData() {
        int tThreshold = this.tRunningRecipe != null ? this.tRunningRecipe.mSpecialValue : 0;
        return new String[]{StatCollector.func_74838_a((String)"GT5U.multiblock.Progress") + ": " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(this.mProgresstime / 20) + EnumChatFormatting.RESET + " s / " + EnumChatFormatting.YELLOW + GTUtility.formatNumbers(this.mMaxProgresstime / 20) + EnumChatFormatting.RESET + " s", StatCollector.func_74838_a((String)"GT5U.multiblock.problems") + ": " + EnumChatFormatting.RED + (this.getIdealStatus() - this.getRepairStatus()) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.multiblock.efficiency") + ": " + EnumChatFormatting.YELLOW + (float)this.mEfficiency / 100.0f + EnumChatFormatting.RESET + " %", StatCollector.func_74838_a((String)"scanner.info.XHE.0") + " " + (this.transformed ? EnumChatFormatting.RED : EnumChatFormatting.YELLOW) + GTUtility.formatNumbers(this.mEUt) + EnumChatFormatting.RESET + " EU/t", StatCollector.func_74838_a((String)"scanner.info.XHE.1") + " " + EnumChatFormatting.GREEN + GTUtility.formatNumbers(tThreshold) + EnumChatFormatting.RESET + " L/s"};
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        if (side == facing) {
            if (aActive) {
                return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_ACTIVE_GLOW).extFacing().glow().build()};
            }
            return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48], TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER).extFacing().build(), TextureFactory.builder().addIcon(Textures.BlockIcons.OVERLAY_FRONT_HEAT_EXCHANGER_GLOW).extFacing().glow().build()};
        }
        return new ITexture[]{Textures.BlockIcons.casingTexturePages[0][48]};
    }

    public int survivalConstruct(ItemStack stackSize, int elementBudget, ISurvivalBuildEnvironment env) {
        if (this.mMachine) {
            return -1;
        }
        return this.survivialBuildPiece(this.mName, stackSize, 2, 5, 0, elementBudget, env, false, true);
    }

    @Override
    public void startRecipeProcessing() {
        super.startRecipeProcessing();
        MTEHatchInput mTEHatchInput = this.mHotFluidHatch;
        if (mTEHatchInput instanceof IRecipeProcessingAwareHatch) {
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)mTEHatchInput);
            if (this.mHotFluidHatch.isValid()) {
                aware.startRecipeProcessing();
            }
        }
    }

    @Override
    public void endRecipeProcessing() {
        super.endRecipeProcessing();
        MTEHatchInput mTEHatchInput = this.mHotFluidHatch;
        if (mTEHatchInput instanceof IRecipeProcessingAwareHatch) {
            IRecipeProcessingAwareHatch aware = (IRecipeProcessingAwareHatch)((Object)mTEHatchInput);
            if (this.mHotFluidHatch.isValid()) {
                aware.endRecipeProcessing(this);
            }
        }
    }

    private static enum EHEHatches implements IHatchElement<MTEExtremeHeatExchanger>
    {
        HotInputHatch(MTEExtremeHeatExchanger::addHotFluidInputToMachineList, new Class[]{MTEHatchInput.class}){

            @Override
            public long count(MTEExtremeHeatExchanger t) {
                if (t.mHotFluidHatch == null) {
                    return 0L;
                }
                return 1L;
            }
        }
        ,
        ColdOutputHatch(MTEExtremeHeatExchanger::addColdFluidOutputToMachineList, new Class[]{MTEHatchOutput.class}){

            @Override
            public long count(MTEExtremeHeatExchanger t) {
                if (t.mCooledFluidHatch == null) {
                    return 0L;
                }
                return 1L;
            }
        };

        private final List<Class<? extends IMetaTileEntity>> mteClasses;
        private final IGTHatchAdder<MTEExtremeHeatExchanger> adder;

        private EHEHatches(IGTHatchAdder<MTEExtremeHeatExchanger> adder, Class<? extends IMetaTileEntity> ... mteClasses) {
            this.mteClasses = Collections.unmodifiableList(Arrays.asList(mteClasses));
            this.adder = adder;
        }

        @Override
        public List<? extends Class<? extends IMetaTileEntity>> mteClasses() {
            return this.mteClasses;
        }

        @Override
        public IGTHatchAdder<? super MTEExtremeHeatExchanger> adder() {
            return this.adder;
        }
    }
}

