/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.render.items;

import com.google.common.base.Objects;
import gregtech.api.enums.ItemList;
import gregtech.api.interfaces.IGT_ItemWithMaterialRenderer;
import gregtech.api.objects.ItemData;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import gregtech.common.render.GTRenderUtil;
import gregtech.common.render.items.GeneratedItemRenderer;
import gregtech.common.render.items.GeneratedMaterialRenderer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;

public class MetaGeneratedItemRenderer
implements IItemRenderer {
    private final IItemRenderer mItemRenderer = new GeneratedItemRenderer();
    private final IItemRenderer mMaterialRenderer = new GeneratedMaterialRenderer();
    private static final Map<RendererKey, IItemRenderer> specialRenderers = new HashMap<RendererKey, IItemRenderer>();

    public <T extends Item> void registerItem(T item) {
        MinecraftForgeClient.registerItemRenderer(item, (IItemRenderer)this);
    }

    public static void registerSpecialRenderer(ItemList item, IItemRenderer renderer) {
        specialRenderers.put(new RendererKey(item.getItem(), (short)item.getInternalStack_unsafe().func_77960_j()), renderer);
    }

    public boolean handleRenderType(ItemStack aStack, IItemRenderer.ItemRenderType aType) {
        if (GTUtility.isStackInvalid(aStack) || aStack.func_77960_j() < 0 || !(aStack.func_77973_b() instanceof IGT_ItemWithMaterialRenderer) || !((IGT_ItemWithMaterialRenderer)aStack.func_77973_b()).shouldUseCustomRenderer(aStack.func_77960_j())) {
            return false;
        }
        return this.getRendererForItemStack(aStack).handleRenderType(aStack, aType);
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType aType, ItemStack aStack, IItemRenderer.ItemRendererHelper aHelper) {
        if (GTUtility.isStackInvalid(aStack)) {
            return false;
        }
        return this.getRendererForItemStack(aStack).shouldUseRenderHelper(aType, aStack, aHelper);
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack aStack, Object ... data) {
        GTRenderUtil.applyStandardItemTransform(type);
        IItemRenderer itemRenderer = this.getRendererForItemStack(aStack);
        itemRenderer.renderItem(type, aStack, data);
    }

    private IItemRenderer getRendererForItemStack(ItemStack aStack) {
        short aMetaData = (short)aStack.func_77960_j();
        RendererKey key = new RendererKey(aStack.func_77973_b(), aMetaData);
        if (specialRenderers.containsKey(key)) {
            return specialRenderers.get(key);
        }
        IGT_ItemWithMaterialRenderer aItem = (IGT_ItemWithMaterialRenderer)aStack.func_77973_b();
        if (aItem != null && aItem.allowMaterialRenderer(aMetaData)) {
            ItemData itemData;
            GeneratedMaterialRenderer aMaterialRenderer = aItem.getMaterialRenderer(aMetaData);
            if (aMaterialRenderer == null && (itemData = GTOreDictUnificator.getAssociation(aStack)) != null && itemData.mMaterial != null && itemData.mMaterial.mMaterial.renderer != null) {
                aMaterialRenderer = itemData.mMaterial.mMaterial.renderer;
            }
            return aMaterialRenderer != null ? aMaterialRenderer : this.mMaterialRenderer;
        }
        return this.mItemRenderer;
    }

    private static class RendererKey {
        private final Item item;
        private final short metadata;

        private RendererKey(Item item, short metadata) {
            this.item = item;
            this.metadata = metadata;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RendererKey that = (RendererKey)o;
            return this.item == that.item && this.metadata == that.metadata;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.item, this.metadata});
        }
    }
}

