/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.tileentities.machines.basic;

import com.gtnewhorizons.modularui.api.drawable.FallbackableUITexture;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.BaseTileEntity;
import gregtech.api.metatileentity.implementations.MTEBasicMachine;
import gregtech.api.recipe.BasicUIProperties;
import gregtech.api.render.TextureFactory;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTUtility;
import gregtech.common.misc.DrillingLogicDelegate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidBlock;

public class MTEPump
extends MTEBasicMachine {
    private static final ItemStack MINING_PIPE = GTModHandler.getIC2Item("miningPipe", 0L);
    private static final ItemStack MINING_PIPE_ONE = GTModHandler.getIC2Item("miningPipe", 1L);
    private static final Block MINING_PIPE_BLOCK = GTUtility.getBlockFromStack(MINING_PIPE);
    private static final Block MINING_PIPE_TIP_BLOCK = GTUtility.getBlockFromStack(GTModHandler.getIC2Item("miningPipeTip", 0L));
    public ArrayDeque<ChunkPosition> mPumpList = new ArrayDeque();
    public boolean wasPumping = false;
    public int mPumpTimer = 0;
    public int mPumpCountBelow = 0;
    public Block mPrimaryPumpedBlock = null;
    public Block mSecondaryPumpedBlock = null;
    private int radiusConfig = MTEPump.getMaxDistanceForTier(this.mTier);
    private boolean mRetractDone = false;
    private boolean mDisallowRetract = true;
    private static final FallbackableUITexture progressBarTexture = GTUITextures.fallbackableProgressbar("pump", GTUITextures.PROGRESSBAR_CANNER);
    private FakePlayer mFakePlayer = null;

    public static int getMaxDistanceForTier(int aTier) {
        return 10 * (int)Math.pow(1.6, aTier);
    }

    public static long getEuUsagePerTier(int aTier) {
        return 16L * (long)Math.pow(4.0, aTier);
    }

    public MTEPump(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 1, new String[]{"The best way to empty Oceans!", MTEPump.getEuUsagePerTier(aTier) + " EU/operation, " + GTUtility.safeInt(8L / (long)Math.pow(2.0, aTier)) + " sec per bucket, no stuttering", "Maximum pumping area: " + (MTEPump.getMaxDistanceForTier(aTier) * 2 + 1) + "x" + (MTEPump.getMaxDistanceForTier(aTier) * 2 + 1), "Use Screwdriver to regulate pumping area", "Use Soft Mallet to disable and retract the pipe", "Disable the bottom pump to retract the pipe!", "Use Soldering Iron to auto retract the pipe when hitting a rock"}, 2, 2, TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_SIDE_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_SIDE_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_SIDE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_SIDE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_FRONT_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_FRONT_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_FRONT")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_FRONT_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_TOP_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_TOP_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_TOP")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_TOP_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_BOTTOM_ACTIVE")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_BOTTOM_ACTIVE_GLOW")).glow().build()), TextureFactory.of(TextureFactory.of(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_BOTTOM")), TextureFactory.builder().addIcon(new Textures.BlockIcons.CustomIcon("basicmachines/pump/OVERLAY_BOTTOM_GLOW")).glow().build()));
    }

    public MTEPump(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 1, aDescription, aTextures, 2, 2);
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEPump(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    protected BasicUIProperties getUIProperties() {
        return BasicUIProperties.builder().maxItemInputs(2).maxItemOutputs(2).slotOverlays((index, isFluid, isOutput, isSpecial) -> {
            if (!(isFluid || isOutput || isSpecial)) {
                return GTUITextures.OVERLAY_SLOT_MINING_PIPE;
            }
            return null;
        }).maxFluidInputs(0).maxFluidOutputs(1).progressBarTexture(progressBarTexture).build();
    }

    @Override
    public int getCapacity() {
        return MTEPump.getCapacityForTier(this.mTier);
    }

    @Override
    protected boolean allowPutStackValidated(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return super.allowPutStackValidated(aBaseMetaTileEntity, aIndex, side, aStack) && aStack.func_77973_b() == DrillingLogicDelegate.MINING_PIPE_STACK.func_77973_b();
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        boolean wasPumping;
        boolean bl = wasPumping = this.wasPumping || !this.mPumpList.isEmpty();
        if (GTValues.debugBlockPump) {
            GTLog.out.println("PUMP: NBT:Save - WasPumping - " + wasPumping + " blocks (" + this.mPrimaryPumpedBlock + ", " + this.mSecondaryPumpedBlock + ")");
        }
        super.saveNBTData(aNBT);
        aNBT.func_74778_a("mPumpedBlock1", this.mPrimaryPumpedBlock == null ? "" : Block.field_149771_c.func_148750_c((Object)this.mPrimaryPumpedBlock));
        aNBT.func_74778_a("mPumpedBlock2", this.mSecondaryPumpedBlock == null ? "" : Block.field_149771_c.func_148750_c((Object)this.mSecondaryPumpedBlock));
        aNBT.func_74757_a("wasPumping", wasPumping);
        aNBT.func_74768_a("radiusConfig", this.radiusConfig);
        aNBT.func_74757_a("mRetractDone", this.mRetractDone);
        aNBT.func_74757_a("mDisallowRetract", this.mDisallowRetract);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        super.loadNBTData(aNBT);
        this.wasPumping = aNBT.func_74767_n("wasPumping");
        if (aNBT.func_74764_b("radiusConfig")) {
            this.radiusConfig = aNBT.func_74762_e("radiusConfig");
        }
        this.mPrimaryPumpedBlock = Block.func_149684_b((String)aNBT.func_74779_i("mPumpedBlock1"));
        this.mSecondaryPumpedBlock = Block.func_149684_b((String)aNBT.func_74779_i("mPumpedBlock2"));
        this.mRetractDone = aNBT.func_74767_n("mRetractDone");
        this.mDisallowRetract = aNBT.func_74767_n("mDisallowRetract");
        if (!aNBT.func_74764_b("mEUt")) {
            this.getBaseMetaTileEntity().setFrontFacing(ForgeDirection.UP);
            this.mFluidTransfer = true;
            if (this.mFluid != null && this.mFluid.amount > 0) {
                this.fluidOutputTank.fill(this.mFluid, true);
                this.mFluid = null;
            }
            if (this.mInventory[1] != null && this.mInventory[1].field_77994_a > 0) {
                this.mInventory[this.getInputSlot() + 1] = this.mInventory[1];
                this.mInventory[1] = null;
            }
            if (this.mInventory[0] != null && this.mInventory[0].field_77994_a > 0) {
                this.mInventory[this.getInputSlot()] = this.mInventory[0];
                this.mInventory[0] = null;
            }
        }
        if (GTValues.debugBlockPump) {
            GTLog.out.println("PUMP: NBT:Load - WasPumping - " + this.wasPumping + "(" + aNBT.func_74779_i("mPumpedBlock1") + ") " + this.mPrimaryPumpedBlock);
        }
    }

    @Override
    public void setItemNBT(NBTTagCompound aNBT) {
        super.setItemNBT(aNBT);
        if (this.radiusConfig != MTEPump.getMaxDistanceForTier(this.mTier)) {
            aNBT.func_74768_a("radiusConfig", this.radiusConfig);
        }
        if (!this.mDisallowRetract) {
            aNBT.func_74757_a("mDisallowRetract", false);
        }
    }

    @Override
    public void onScrewdriverRightClick(ForgeDirection side, EntityPlayer aPlayer, float aX, float aY, float aZ) {
        super.onScrewdriverRightClick(side, aPlayer, aX, aY, aZ);
        if (side == this.getBaseMetaTileEntity().getFrontFacing() || side == this.mMainFacing) {
            return;
        }
        int max = this.getMaxPumpableDistance();
        if (aPlayer.func_70093_af()) {
            if (this.radiusConfig >= 0) {
                --this.radiusConfig;
            }
            if (this.radiusConfig < 0) {
                this.radiusConfig = max;
            }
        } else {
            if (this.radiusConfig <= max) {
                ++this.radiusConfig;
            }
            if (this.radiusConfig > max) {
                this.radiusConfig = 0;
            }
        }
        GTUtility.sendChatToPlayer(aPlayer, StatCollector.func_74838_a((String)"GT5U.machines.workareaset") + " " + (this.radiusConfig * 2 + 1) + "x" + (this.radiusConfig * 2 + 1));
        this.clearQueue(false);
    }

    @Override
    public boolean onSolderingToolRightClick(ForgeDirection side, ForgeDirection wrenchingSide, EntityPlayer entityPlayer, float aX, float aY, float aZ) {
        if (super.onSolderingToolRightClick(side, wrenchingSide, entityPlayer, aX, aY, aZ)) {
            return true;
        }
        this.mDisallowRetract = !this.mDisallowRetract;
        GTUtility.sendChatToPlayer(entityPlayer, StatCollector.func_74838_a((String)(this.mDisallowRetract ? "GT5U.machines.autoretract.disabled" : "GT5U.machines.autoretract.enabled")));
        return true;
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPostTick(aBaseMetaTileEntity, aTick);
        if (this.getBaseMetaTileEntity().isServerSide()) {
            IGregTechTileEntity tTileEntity;
            --this.mPumpTimer;
            if (this.getBaseMetaTileEntity() instanceof BaseTileEntity) {
                ((BaseTileEntity)((Object)this.getBaseMetaTileEntity())).ignoreUnloadedChunks = false;
            }
            this.doTickProfilingInThisTick = true;
            this.mPumpCountBelow = 0;
            for (int i = 1; i < 21 && (tTileEntity = this.getBaseMetaTileEntity().getIGregTechTileEntityAtSideAndDistance(ForgeDirection.DOWN, i)) != null && tTileEntity.getMetaTileEntity() instanceof MTEPump; ++i) {
                this.getBaseMetaTileEntity().setActive(tTileEntity.isActive());
                ++this.mPumpCountBelow;
                --((MTEPump)tTileEntity.getMetaTileEntity()).mPumpTimer;
                ++((MTEPump)tTileEntity.getMetaTileEntity()).mProgresstime;
            }
            if (GTValues.debugBlockPump && this.mPumpCountBelow != 0) {
                GTLog.out.println("PUMP: Detected " + this.mPumpCountBelow + " pumps below this pump.");
            }
            if (this.mPumpCountBelow <= 0) {
                if (this.getBaseMetaTileEntity().isAllowedToWork()) {
                    this.mRetractDone = false;
                    if (this.getBaseMetaTileEntity().isUniversalEnergyStored(this.getEuUsagePerAction()) && this.fluidOutputTank.getFluidAmount() + 1000 <= this.fluidOutputTank.getCapacity()) {
                        boolean tMovedOneDown = false;
                        if (this.mPumpList.isEmpty() && this.getBaseMetaTileEntity().getTimer() % 100L == 0L) {
                            if (!this.wasPumping) {
                                tMovedOneDown = this.moveOneDown();
                                if (!tMovedOneDown) {
                                    if (this.canMoveDown(this.getBaseMetaTileEntity().getXCoord(), Math.max(this.getYOfPumpHead() - 1, 1), this.getBaseMetaTileEntity().getZCoord())) {
                                        if (GTValues.debugBlockPump) {
                                            GTLog.out.println("PUMP: No pipe left. Idle for a little longer.");
                                        }
                                        this.mPumpTimer = 160;
                                    } else {
                                        this.getBaseMetaTileEntity().disableWorking();
                                        if (GTValues.debugBlockPump) {
                                            GTLog.out.println("PUMP: Can't move. Retracting in next few ticks");
                                        }
                                    }
                                } else if (GTValues.debugBlockPump) {
                                    GTLog.out.println("PUMP: Moved down");
                                }
                            } else if (GTValues.debugBlockPump) {
                                GTLog.out.println("PUMP: Was pumping, didn't move down");
                            }
                        }
                        int x = this.getBaseMetaTileEntity().getXCoord();
                        int z = this.getBaseMetaTileEntity().getZCoord();
                        if (!this.hasValidFluid()) {
                            int y = this.getYOfPumpHead();
                            if (GTValues.debugBlockPump && this.mPrimaryPumpedBlock != null) {
                                GTLog.out.println("PUMP: Had an invalid pump block. Trying to find a fluid at Y: " + y + " Previous blocks 1: " + this.mPrimaryPumpedBlock + " 2: " + this.mSecondaryPumpedBlock);
                            }
                            this.checkForFluidToPump(x, y - 1, z);
                            this.checkForFluidToPump(x, y, z + 1);
                            this.checkForFluidToPump(x, y, z - 1);
                            this.checkForFluidToPump(x + 1, y, z);
                            this.checkForFluidToPump(x - 1, y, z);
                            this.clearQueue(false);
                            if (this.hasValidFluid()) {
                                this.wasPumping = true;
                            }
                        } else if (this.getYOfPumpHead() < this.getBaseMetaTileEntity().getYCoord()) {
                            if (tMovedOneDown || this.wasPumping || this.mPumpList.isEmpty() && this.getBaseMetaTileEntity().getTimer() % 200L == 100L || this.getBaseMetaTileEntity().getTimer() % 72000L == 100L) {
                                if (GTValues.debugBlockPump) {
                                    GTLog.out.println("PUMP: Rebuilding pump list - Size " + this.mPumpList.size() + " WasPumping: " + this.wasPumping + " Timer " + this.getBaseMetaTileEntity().getTimer());
                                }
                                int yPump = this.getBaseMetaTileEntity().getYCoord() - 1;
                                int yHead = this.getYOfPumpHead();
                                this.rebuildPumpQueue(x, yPump, z, yHead);
                                if (GTValues.debugBlockPump) {
                                    GTLog.out.println("PUMP: Rebuilt pump list - Size " + this.mPumpList.size());
                                }
                            }
                            if (!tMovedOneDown && this.mPumpTimer <= 0) {
                                while (!this.mPumpList.isEmpty()) {
                                    ChunkPosition pos = this.mPumpList.pollLast();
                                    if (!this.consumeFluid(pos.field_151329_a, pos.field_151327_b, pos.field_151328_c)) continue;
                                    break;
                                }
                                this.mPumpTimer = GTUtility.safeInt(160L / (long)Math.pow(2.0, this.mTier));
                                this.mMaxProgresstime = this.mPumpTimer = this.mPumpTimer == 0 ? 1 : this.mPumpTimer;
                                this.mProgresstime = 0;
                            }
                        } else {
                            this.clearQueue(false);
                        }
                    } else if (GTValues.debugBlockPump) {
                        GTLog.out.println("PUMP: Not enough energy? Free space?");
                    }
                } else {
                    this.mMaxProgresstime = 0;
                    if (!this.mRetractDone && aTick % 5L == 0L && this.canOutput(MINING_PIPE_ONE)) {
                        int tHeadY = this.getYOfPumpHead();
                        if (tHeadY < this.getBaseMetaTileEntity().getYCoord()) {
                            int tXCoord = this.getBaseMetaTileEntity().getXCoord();
                            int tZCoord = this.getBaseMetaTileEntity().getZCoord();
                            this.getBaseMetaTileEntity().getWorld().func_147468_f(tXCoord, tHeadY, tZCoord);
                            if (tHeadY < this.getBaseMetaTileEntity().getYCoord() - 1) {
                                this.getBaseMetaTileEntity().getWorld().func_147449_b(tXCoord, tHeadY + 1, tZCoord, MINING_PIPE_TIP_BLOCK);
                            }
                            for (int i = 0; i < this.mOutputItems.length && !aBaseMetaTileEntity.addStackToSlot(this.getOutputSlot() + i, MINING_PIPE_ONE.func_77946_l()); ++i) {
                            }
                            if (GTValues.debugBlockPump) {
                                GTLog.out.println("PUMP: Retracted one pipe");
                            }
                        } else {
                            this.mRetractDone = true;
                            if (GTValues.debugBlockPump) {
                                GTLog.out.println("PUMP: Retract done");
                            }
                        }
                    }
                }
                if (!this.mDisallowRetract) {
                    this.getBaseMetaTileEntity().setActive(!this.mPumpList.isEmpty());
                }
            }
        }
    }

    private int getMaxPumpableDistance() {
        return MTEPump.getMaxDistanceForTier(this.mTier);
    }

    private long getEuUsagePerAction() {
        return MTEPump.getEuUsagePerTier(this.mTier);
    }

    private boolean hasValidFluid() {
        return this.mPrimaryPumpedBlock != null && this.mSecondaryPumpedBlock != null;
    }

    private boolean moveOneDown() {
        boolean foundPipe = false;
        for (int i = 0; i < this.mInputSlotCount; ++i) {
            ItemStack stack = this.getInputAt(i);
            if (!GTUtility.areStacksEqual(stack, MINING_PIPE) || stack.field_77994_a <= 0) continue;
            foundPipe = true;
            break;
        }
        if (!foundPipe) {
            if (GTValues.debugBlockPump) {
                GTLog.out.println("PUMP: No mining pipes");
            }
            return false;
        }
        int yHead = this.getYOfPumpHead();
        if (yHead <= 1) {
            if (GTValues.debugBlockPump) {
                GTLog.out.println("PUMP: At bottom");
            }
            return false;
        }
        int x = this.getBaseMetaTileEntity().getXCoord();
        int z = this.getBaseMetaTileEntity().getZCoord();
        Block aBlock = this.getBaseMetaTileEntity().getBlock(x, yHead - 1, z);
        boolean canReplaceBlock = aBlock.isReplaceable((IBlockAccess)this.getBaseMetaTileEntity().getWorld(), x, yHead - 1, z);
        if (!canReplaceBlock || MTEPump.isFluid(aBlock) && !this.consumeFluid(x, yHead - 1, z) && !MTEPump.isWater(aBlock)) {
            if (GTValues.debugBlockPump) {
                GTLog.out.println("PUMP: Did not consume fluid, or non-replaceable block found");
            }
            return false;
        }
        if (!GTUtility.setBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), x, yHead - 1, z, MINING_PIPE_TIP_BLOCK, 0, false)) {
            if (GTValues.debugBlockPump) {
                GTLog.out.println("PUMP: Could not set block below to new tip");
            }
            return false;
        }
        if (yHead != this.getBaseMetaTileEntity().getYCoord()) {
            this.getBaseMetaTileEntity().getWorld().func_147449_b(x, yHead, z, MINING_PIPE_BLOCK);
        }
        foundPipe = false;
        for (int i = 0; i < this.mInputSlotCount; ++i) {
            ItemStack stack = this.getInputAt(i);
            if (!GTUtility.areStacksEqual(stack, MINING_PIPE) || stack.field_77994_a <= 0) continue;
            foundPipe = true;
            --stack.field_77994_a;
            if (stack.field_77994_a != 0) break;
            this.mInventory[this.getInputSlot() + i] = null;
            break;
        }
        if (GTValues.debugBlockPump) {
            if (foundPipe) {
                GTLog.out.println("PUMP: Using 1 pipe");
            } else {
                GTLog.err.println("PUMP: Lowered pipe but could not find pipe in input");
            }
        }
        return true;
    }

    private int getYOfPumpHead() {
        int y = this.getBaseMetaTileEntity().getYCoord() - 1;
        int x = this.getBaseMetaTileEntity().getXCoord();
        int z = this.getBaseMetaTileEntity().getZCoord();
        while (y > 0) {
            Block curBlock = this.getBaseMetaTileEntity().getBlock(x, y, z);
            if (curBlock == MINING_PIPE_BLOCK) {
                --y;
                continue;
            }
            if (curBlock != MINING_PIPE_TIP_BLOCK) break;
            Block nextBlock = this.getBaseMetaTileEntity().getBlock(x, y - 1, z);
            if (nextBlock == MINING_PIPE_BLOCK || nextBlock == MINING_PIPE_TIP_BLOCK) {
                this.clearQueue(true);
                this.getBaseMetaTileEntity().getWorld().func_147449_b(x, y, z, MINING_PIPE_BLOCK);
                if (GTValues.debugBlockPump) {
                    GTLog.out.println("PUMP: Hit pipes already in place, trying to merge");
                }
            }
            --y;
        }
        if (this.getBaseMetaTileEntity().getBlock(x, y, z) != MINING_PIPE_TIP_BLOCK) {
            if (y != this.getBaseMetaTileEntity().getYCoord() - 1 && this.getBaseMetaTileEntity().getBlock(x, y + 1, z) == MINING_PIPE_BLOCK) {
                this.clearQueue(true);
                this.getBaseMetaTileEntity().getWorld().func_147449_b(x, y + 1, z, MINING_PIPE_TIP_BLOCK);
                if (GTValues.debugBlockPump) {
                    GTLog.out.println("PUMP: Did not find a tip at bottom, setting last pipe as tip");
                }
            }
            return y + 1;
        }
        return y;
    }

    private void clearQueue(boolean checkPumping) {
        this.wasPumping = checkPumping ? !this.mPumpList.isEmpty() : false;
        this.mPumpList.clear();
    }

    private void rebuildPumpQueue(int aX, int yStart, int aZ, int yEnd) {
        int mDist = this.radiusConfig;
        this.doTickProfilingInThisTick = false;
        ArrayDeque<ChunkPosition> fluidsToSearch = new ArrayDeque<ChunkPosition>();
        ArrayDeque<ChunkPosition> fluidsFound = new ArrayDeque<ChunkPosition>();
        HashSet<ChunkPosition> checked = new HashSet<ChunkPosition>();
        this.clearQueue(false);
        for (int aY = yStart; this.mPumpList.isEmpty() && aY >= yEnd; --aY) {
            fluidsToSearch.add(new ChunkPosition(aX, aY, aZ));
            while (!fluidsToSearch.isEmpty()) {
                for (ChunkPosition tPos : fluidsToSearch) {
                    if (tPos.field_151329_a < aX + mDist) {
                        this.queueFluid(tPos.field_151329_a + 1, tPos.field_151327_b, tPos.field_151328_c, fluidsFound, checked);
                    }
                    if (tPos.field_151329_a > aX - mDist) {
                        this.queueFluid(tPos.field_151329_a - 1, tPos.field_151327_b, tPos.field_151328_c, fluidsFound, checked);
                    }
                    if (tPos.field_151328_c < aZ + mDist) {
                        this.queueFluid(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c + 1, fluidsFound, checked);
                    }
                    if (tPos.field_151328_c > aZ - mDist) {
                        this.queueFluid(tPos.field_151329_a, tPos.field_151327_b, tPos.field_151328_c - 1, fluidsFound, checked);
                    }
                    this.queueFluid(tPos.field_151329_a, tPos.field_151327_b + 1, tPos.field_151328_c, this.mPumpList, checked);
                }
                this.mPumpList.addAll(fluidsFound);
                fluidsToSearch = fluidsFound;
                fluidsFound = new ArrayDeque();
            }
            this.mPumpList.remove(new ChunkPosition(aX, aY, aZ));
        }
    }

    private boolean queueFluid(int aX, int aY, int aZ, ArrayDeque<ChunkPosition> fluidsFound, Set<ChunkPosition> checked) {
        Block aBlock;
        ChunkPosition tCoordinate = new ChunkPosition(aX, aY, aZ);
        if (checked.add(tCoordinate) && !fluidsFound.contains(tCoordinate) && (this.mPrimaryPumpedBlock == (aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ)) || this.mSecondaryPumpedBlock == aBlock)) {
            fluidsFound.addFirst(tCoordinate);
            return true;
        }
        return false;
    }

    private void checkForFluidToPump(int aX, int aY, int aZ) {
        if (this.hasValidFluid()) {
            return;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        if (aBlock != null) {
            if (MTEPump.isWater(aBlock)) {
                this.mPrimaryPumpedBlock = Blocks.field_150355_j;
                this.mSecondaryPumpedBlock = Blocks.field_150358_i;
                return;
            }
            if (MTEPump.isLava(aBlock)) {
                this.mPrimaryPumpedBlock = Blocks.field_150353_l;
                this.mSecondaryPumpedBlock = Blocks.field_150356_k;
                return;
            }
            if (aBlock instanceof IFluidBlock) {
                this.mPrimaryPumpedBlock = aBlock;
                this.mSecondaryPumpedBlock = aBlock;
                return;
            }
        }
        this.mPrimaryPumpedBlock = null;
        this.mSecondaryPumpedBlock = null;
    }

    private boolean canMoveDown(int aX, int aY, int aZ) {
        if (!GTUtility.eraseBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), aX, aY, aZ, true)) {
            return false;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        return aBlock != null && aBlock.isReplaceable((IBlockAccess)this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ);
    }

    private boolean consumeFluid(int aX, int aY, int aZ) {
        if (!GTUtility.eraseBlockByFakePlayer(this.getFakePlayer(this.getBaseMetaTileEntity()), aX, aY, aZ, true)) {
            return false;
        }
        Block aBlock = this.getBaseMetaTileEntity().getBlock(aX, aY, aZ);
        if (!MTEPump.isFluid(aBlock)) {
            return false;
        }
        if (aBlock != null && (this.mPrimaryPumpedBlock == aBlock || this.mSecondaryPumpedBlock == aBlock)) {
            boolean isWaterOrLava;
            boolean bl = isWaterOrLava = this.mPrimaryPumpedBlock == Blocks.field_150355_j || this.mPrimaryPumpedBlock == Blocks.field_150353_l;
            if (isWaterOrLava && this.getBaseMetaTileEntity().getMetaID(aX, aY, aZ) != 0) {
                if (GTValues.debugBlockPump) {
                    GTLog.out.println("PUMP: Water/Lava - Not a source block");
                }
            } else if (this.getDrainableStack() == null) {
                if (this.mPrimaryPumpedBlock == Blocks.field_150355_j) {
                    this.setDrainableStack(GTModHandler.getWater(1000L));
                } else if (this.mPrimaryPumpedBlock == Blocks.field_150353_l) {
                    this.setDrainableStack(GTModHandler.getLava(1000L));
                } else {
                    this.setDrainableStack(((IFluidBlock)aBlock).drain(this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ, true));
                }
            } else if (GTModHandler.isWater(this.getDrainableStack()) || GTModHandler.isLava(this.getDrainableStack()) || this.getDrainableStack().isFluidEqual(((IFluidBlock)aBlock).drain(this.getBaseMetaTileEntity().getWorld(), aX, aY, aZ, false))) {
                if (!isWaterOrLava) {
                    this.getBaseMetaTileEntity().getWorld().func_147468_f(aX, aY, aZ);
                }
                this.getDrainableStack().amount += 1000;
            } else {
                if (GTValues.debugBlockPump) {
                    GTLog.out.println("PUMP: Couldn't consume " + aBlock);
                }
                return false;
            }
            this.getBaseMetaTileEntity().decreaseStoredEnergyUnits(this.getEuUsagePerAction(), true);
            this.getBaseMetaTileEntity().getWorld().func_147465_d(aX, aY, aZ, Blocks.field_150350_a, 0, 2);
            return true;
        }
        return false;
    }

    private static boolean isWater(Block aBlock) {
        return aBlock == Blocks.field_150355_j || aBlock == Blocks.field_150358_i;
    }

    private static boolean isLava(Block aBlock) {
        return aBlock == Blocks.field_150353_l || aBlock == Blocks.field_150356_k;
    }

    private static boolean isFluid(Block aBlock) {
        return MTEPump.isWater(aBlock) || MTEPump.isLava(aBlock) || aBlock instanceof IFluidBlock;
    }

    @Override
    public ArrayList<String> getSpecialDebugInfo(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer, int aLogLevel, ArrayList<String> aList) {
        aList.addAll(Arrays.asList(EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.pump") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + (this.radiusConfig * 2 + 1) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.blocks"), "Primary pumping fluid:   " + (this.mPrimaryPumpedBlock != null ? this.mPrimaryPumpedBlock.func_149732_F() : "None"), "Secondary pumping fluid: " + (this.mSecondaryPumpedBlock != null ? this.mSecondaryPumpedBlock.func_149732_F() : "None"), "Pumps below: " + this.mPumpCountBelow, "Queue size: " + this.mPumpList.size(), "Pump head at Y: " + this.getYOfPumpHead(), "Pump timer: " + this.mPumpTimer, "Meta Entity Timer: " + this.getBaseMetaTileEntity().getTimer()));
        return aList;
    }

    protected FakePlayer getFakePlayer(IGregTechTileEntity aBaseTile) {
        if (this.mFakePlayer == null) {
            this.mFakePlayer = GTUtility.getFakePlayer(aBaseTile);
        }
        this.mFakePlayer.func_70029_a(aBaseTile.getWorld());
        this.mFakePlayer.func_70107_b((double)aBaseTile.getXCoord(), (double)aBaseTile.getYCoord(), (double)aBaseTile.getZCoord());
        return this.mFakePlayer;
    }

    @Override
    public String[] getInfoData() {
        return new String[]{EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"GT5U.machines.pump") + EnumChatFormatting.RESET, StatCollector.func_74838_a((String)"GT5U.machines.workarea") + ": " + EnumChatFormatting.GREEN + (this.radiusConfig * 2 + 1) + EnumChatFormatting.RESET + " " + StatCollector.func_74838_a((String)"GT5U.machines.blocks")};
    }
}

