/*
 * Decompiled with CFR 0.152.
 */
package kubatech.api.enums;

import gregtech.api.util.MultiblockTooltipBuilder;
import java.util.HashMap;
import kubatech.api.eig.EIGMode;
import kubatech.tileentity.gregtech.multiblock.eigmodes.EIGIC2Mode;
import kubatech.tileentity.gregtech.multiblock.eigmodes.EIGNormalMode;

public class EIGModes {
    private static final HashMap<String, EIGMode> modes = new HashMap();
    public static final EIGMode Normal = EIGModes.addMode(EIGNormalMode.instance);
    public static final EIGMode IC2 = EIGModes.addMode(EIGIC2Mode.instance);

    private EIGModes() {
    }

    private static EIGMode addMode(EIGMode mode) {
        modes.put(mode.getName(), mode);
        return mode;
    }

    public static EIGMode getModeFromName(String name) {
        return modes.get(name);
    }

    public static EIGMode getNextMode(EIGMode from) {
        int id = (from.getUIIndex() + 1) % modes.size();
        for (EIGMode mode : modes.values()) {
            if (mode.getUIIndex() != id) continue;
            return mode;
        }
        return Normal;
    }

    public static void addTooltipInfo(MultiblockTooltipBuilder tt) {
        Normal.addTooltipInfo(tt);
        IC2.addTooltipInfo(tt);
    }
}

