/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.hatch;

import com.google.common.math.LongMath;
import com.gtnewhorizon.gtnhlib.util.AnimatedTooltipHandler;
import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.interfaces.tileentity.IWirelessEnergyHatchInformation;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTEHatch;
import gregtech.api.util.GTUtility;
import gregtech.common.misc.WirelessNetworkManager;
import java.math.BigInteger;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.thing.metaTileEntity.Textures;
import tectech.thing.metaTileEntity.hatch.MTEHatchEnergyMulti;
import tectech.util.TTUtility;

public class MTEHatchWirelessMulti
extends MTEHatchEnergyMulti
implements IWirelessEnergyHatchInformation {
    private final long precisionMultiplier = LongMath.pow((long)10L, (int)15);
    private final BigInteger eu_transferred_per_operation = BigInteger.valueOf((long)this.Amperes * GTValues.V[this.mTier]).multiply(BigInteger.valueOf(2000L));
    private final double overflowDivisor = this.getOverflowDivisor(this.eu_transferred_per_operation);
    private final long actualTicksBetweenEnergyAddition = this.overflowDivisor > 1.0 ? (long)(2000.0 / (this.overflowDivisor * 2.0)) : 2000L;
    private final long eu_transferred_per_operation_long = this.overflowDivisor > 1.0 ? this.eu_transferred_per_operation.divide(BigInteger.valueOf((long)(this.overflowDivisor * (double)this.precisionMultiplier * 2.0))).multiply(BigInteger.valueOf(this.precisionMultiplier)).longValue() : this.eu_transferred_per_operation.longValue();
    private UUID owner_uuid;
    private ITexture[] TEXTURE_OVERLAY;

    public MTEHatchWirelessMulti(int aID, String aName, String aNameRegional, int aTier, int aAmp) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{AnimatedTooltipHandler.GRAY + "Stores energy globally in a network, up to 2^(2^31) EU.", AnimatedTooltipHandler.GRAY + "Does not connect to wires. This block withdraws EU from the network.", GTValues.AuthorColen + AnimatedTooltipHandler.GRAY + AnimatedTooltipHandler.BOLD + " & " + AnimatedTooltipHandler.BLUE + AnimatedTooltipHandler.BOLD + "Cloud", StatCollector.func_74838_a((String)"gt.blockmachines.hatch.energytunnel.desc.1") + ": " + AnimatedTooltipHandler.YELLOW + GTUtility.formatNumbers((long)aAmp * GTValues.V[aTier]) + AnimatedTooltipHandler.GRAY + " EU/t"}, aAmp);
        TTUtility.setTier(aTier, this);
    }

    public MTEHatchWirelessMulti(String aName, int aTier, int aAmp, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, aAmp, aDescription, aTextures);
    }

    private double getOverflowDivisor(BigInteger euTransferredPerOperation) {
        if (euTransferredPerOperation.compareTo(BigInteger.valueOf(Long.MAX_VALUE)) > 0) {
            return euTransferredPerOperation.doubleValue() / 9.223372036854776E18;
        }
        return 1.0;
    }

    @Override
    public ITexture[] getTexturesActive(ITexture aBaseTexture) {
        switch (this.Amperes) {
            case 4: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_4A;
                break;
            }
            case 16: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_16A;
                break;
            }
            case 64: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_64A;
                break;
            }
            default: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_LASER;
            }
        }
        return new ITexture[]{aBaseTexture, this.TEXTURE_OVERLAY[this.mTier]};
    }

    @Override
    public ITexture[] getTexturesInactive(ITexture aBaseTexture) {
        switch (this.Amperes) {
            case 4: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_4A;
                break;
            }
            case 16: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_16A;
                break;
            }
            case 64: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_MULTI_64A;
                break;
            }
            default: {
                this.TEXTURE_OVERLAY = Textures.OVERLAYS_ENERGY_IN_WIRELESS_LASER;
            }
        }
        return new ITexture[]{aBaseTexture, this.TEXTURE_OVERLAY[this.mTier]};
    }

    @Override
    public boolean isSimpleMachine() {
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isAccessAllowed(EntityPlayer aPlayer) {
        return true;
    }

    @Override
    public boolean isEnetInput() {
        return false;
    }

    @Override
    public boolean isInputFacing(ForgeDirection side) {
        return side == this.getBaseMetaTileEntity().getFrontFacing();
    }

    @Override
    public boolean isValidSlot(int aIndex) {
        return false;
    }

    @Override
    public long getMinimumStoredEU() {
        return (long)this.Amperes * GTValues.V[this.mTier];
    }

    @Override
    public long maxEUInput() {
        return GTValues.V[this.mTier];
    }

    @Override
    public long maxEUStore() {
        return (long)((double)this.totalStorage(GTValues.V[this.mTier]) / (2.0 * this.overflowDivisor) * (double)this.Amperes);
    }

    @Override
    public long maxAmperesIn() {
        return this.Amperes;
    }

    @Override
    public long maxWorkingAmperesIn() {
        return this.Amperes;
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEHatchWirelessMulti(this.mName, (int)this.mTier, this.Amperes, this.mDescriptionArray, this.mTextures);
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity aBaseMetaTileEntity, int aIndex, ForgeDirection side, ItemStack aStack) {
        return false;
    }

    @Override
    public MTEHatch.ConnectionType getConnectionType() {
        return MTEHatch.ConnectionType.WIRELESS;
    }

    @Override
    public void onFirstTick(IGregTechTileEntity aBaseMetaTileEntity) {
        if (aBaseMetaTileEntity.isServerSide()) {
            this.owner_uuid = aBaseMetaTileEntity.getOwnerUuid();
            WirelessNetworkManager.strongCheckOrAddUser(this.owner_uuid);
            this.tryFetchingEnergy();
        }
    }

    @Override
    public void onPreTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        super.onPreTick(aBaseMetaTileEntity, aTick);
        if (aBaseMetaTileEntity.isServerSide() && aTick % this.actualTicksBetweenEnergyAddition == 0L) {
            this.tryFetchingEnergy();
        }
    }

    private void tryFetchingEnergy() {
        long currentEU = this.getBaseMetaTileEntity().getStoredEU();
        long maxEU = this.maxEUStore();
        long euToTransfer = Long.min(maxEU - currentEU, this.eu_transferred_per_operation_long);
        if (euToTransfer <= 0L) {
            return;
        }
        if (!WirelessNetworkManager.addEUToGlobalEnergyMap(this.owner_uuid, -euToTransfer)) {
            return;
        }
        this.setEUVar(currentEU + euToTransfer);
    }
}

