/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.handler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import galaxyspace.GalaxySpace;
import galaxyspace.SolarSystem.moons.deimos.dimension.WorldProviderDeimos;
import galaxyspace.SolarSystem.moons.enceladus.dimension.WorldProviderEnceladus;
import galaxyspace.SolarSystem.moons.europa.dimension.WorldProviderEuropa;
import galaxyspace.SolarSystem.moons.io.dimension.WorldProviderIo;
import galaxyspace.SolarSystem.moons.phobos.dimension.WorldProviderPhobos;
import galaxyspace.SolarSystem.planets.ceres.dimension.WorldProviderCeres;
import galaxyspace.SolarSystem.planets.mercury.dimension.WorldProviderMercury;
import galaxyspace.SolarSystem.planets.venus.dimension.WorldProviderVenus;
import galaxyspace.core.config.GSConfigCore;
import galaxyspace.core.register.GSBlocks;
import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.event.wgen.GCCoreEventPopulate;
import micdoodle8.mods.galacticraft.api.vector.BlockTuple;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.GCBlocks;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderOrbit;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.world.gen.WorldGenMinableMeta;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.gen.feature.WorldGenerator;

public class GSOreGenOtherMods {
    private World worldObj;
    private Random randomGenerator;
    private int chunkX;
    private int chunkZ;
    private WorldGenerator oreGen;
    public static ArrayList<OreGenData> data = new ArrayList();

    public static void addOre(Block block, int meta, int rarity, int depth, int clumpSize, boolean extraRandom, int dim) {
        int clusters = 12;
        int size = 4;
        int min = 0;
        int max = 64;
        switch (depth) {
            case 0: {
                size = 6;
                clusters = 20;
                max = 80;
                if (rarity == 1) {
                    clusters = 9;
                    size = 4;
                    break;
                }
                if (rarity != 2) break;
                clusters = 6;
                size = 3;
                max = 96;
                break;
            }
            case 1: {
                size = 5;
                clusters = 12;
                max = 32;
                if (rarity == 1) {
                    clusters = 6;
                    size = 4;
                    max = 20;
                    break;
                }
                if (rarity != 2) break;
                clusters = 2;
                size = 3;
                max = 16;
                break;
            }
            case 2: {
                size = 6;
                clusters = 15;
                min = 32;
                max = 80;
                if (rarity == 1) {
                    clusters = 8;
                    size = 4;
                    min = 32;
                    max = 72;
                    break;
                }
                if (rarity != 2) break;
                clusters = 3;
                size = 3;
                min = 40;
                max = 64;
            }
        }
        if (clumpSize == 0) {
            size = 1;
            clusters = 3 * clusters / 2;
        } else if (clumpSize == 2) {
            size *= 4;
            clusters /= 2;
        }
        if (extraRandom) {
            if (depth == 1) {
                min = -max * 3;
            } else {
                max *= 4;
            }
        }
        OreGenData ore = new OreGenData(block, meta, clusters, size, min, max, dim);
        data.add(ore);
    }

    @SubscribeEvent
    public void onPlanetDecorated(GCCoreEventPopulate.Post event) {
        this.worldObj = event.worldObj;
        this.randomGenerator = event.rand;
        this.chunkX = event.chunkX;
        this.chunkZ = event.chunkZ;
        int dimDetected = 0;
        WorldProvider prov = this.worldObj.field_73011_w;
        if (!(prov instanceof IGalacticraftWorldProvider) || prov instanceof WorldProviderOrbit) {
            return;
        }
        Block stoneBlock = null;
        int stoneMeta = 0;
        if (GalacticraftCore.isPlanetsLoaded && prov instanceof WorldProviderPhobos) {
            stoneBlock = GSBlocks.PhobosBlocks;
            stoneMeta = 2;
            dimDetected = 3;
        } else if (GalacticraftCore.isPlanetsLoaded && prov instanceof WorldProviderDeimos) {
            stoneBlock = GSBlocks.DeimosBlocks;
            stoneMeta = 1;
            dimDetected = 4;
        } else if (GalacticraftCore.isPlanetsLoaded && prov instanceof WorldProviderEuropa) {
            stoneBlock = Blocks.field_150355_j;
            stoneMeta = 0;
            dimDetected = 5;
        } else if (GalacticraftCore.isPlanetsLoaded && prov instanceof WorldProviderIo) {
            stoneBlock = GSBlocks.IoBlocks;
            stoneMeta = 2;
            dimDetected = 6;
        } else if (GalacticraftCore.isPlanetsLoaded && prov instanceof WorldProviderEnceladus) {
            stoneBlock = GSBlocks.EnceladusBlocks;
            stoneMeta = 1;
            dimDetected = 7;
        } else if (GalacticraftCore.isPlanetsLoaded && prov instanceof WorldProviderVenus) {
            stoneBlock = GSBlocks.VenusBlocks;
            stoneMeta = 1;
            dimDetected = 8;
        } else if (GalacticraftCore.isPlanetsLoaded && prov instanceof WorldProviderMercury) {
            stoneBlock = GSBlocks.MercuryBlocks;
            stoneMeta = 2;
            dimDetected = 9;
        } else if (GalacticraftCore.isPlanetsLoaded && prov instanceof WorldProviderCeres) {
            stoneBlock = GSBlocks.CeresBlocks;
            stoneMeta = 1;
            dimDetected = 10;
        }
        if (stoneBlock == null) {
            return;
        }
        for (OreGenData ore : data) {
            if (ore.dimRestrict != 0 && ore.dimRestrict != dimDetected) continue;
            this.oreGen = new WorldGenMinableMeta(ore.oreBlock, ore.sizeCluster, ore.oreMeta, true, stoneBlock, stoneMeta);
            this.genStandardOre1(ore.numClusters, this.oreGen, ore.minHeight, ore.maxHeight);
        }
    }

    void genStandardOre1(int amountPerChunk, WorldGenerator worldGenerator, int minY, int maxY) {
        for (int var5 = 0; var5 < amountPerChunk; ++var5) {
            int var6 = this.chunkX + this.randomGenerator.nextInt(16);
            int var7 = this.randomGenerator.nextInt(maxY - minY) + minY;
            if (var7 < 0) continue;
            int var8 = this.chunkZ + this.randomGenerator.nextInt(16);
            worldGenerator.func_76484_a(this.worldObj, this.randomGenerator, var6, var7, var8);
        }
    }

    static {
        for (String str : GSConfigCore.oregenIDs) {
            try {
                String s;
                int slash = str.indexOf(47);
                int rarity = 0;
                int depth = 0;
                int size = 1;
                boolean extraRandom = false;
                int dim = 0;
                if (slash >= 0) {
                    s = str.substring(0, slash).trim();
                    String params = str.substring(slash).toUpperCase();
                    if (params.contains("UNCOMMON")) {
                        rarity = 1;
                    } else if (params.contains("RARE")) {
                        rarity = 2;
                    }
                    if (params.contains("DEEP")) {
                        depth = 1;
                    } else if (params.contains("SHALLOW")) {
                        depth = 2;
                    }
                    if (params.contains("SINGLE")) {
                        size = 0;
                    } else if (params.contains("LARGE")) {
                        size = 2;
                    }
                    if (params.contains("XTRARANDOM")) {
                        extraRandom = true;
                    }
                    if (params.contains("ONLYMOON")) {
                        dim = 1;
                    } else if (params.contains("ONLYMARS")) {
                        dim = 2;
                    } else if (params.contains("ONLYPHOBOS")) {
                        dim = 3;
                    } else if (params.contains("ONLYDEIMOS")) {
                        dim = 4;
                    } else if (params.contains("ONLYEUROPA")) {
                        dim = 5;
                    } else if (params.contains("ONLYIO")) {
                        dim = 6;
                    } else if (params.contains("ONLYENCELADUS")) {
                        dim = 7;
                    } else if (params.contains("ONLYVENUS")) {
                        dim = 8;
                    } else if (params.contains("ONLYMERCURY")) {
                        dim = 9;
                    } else if (params.contains("ONLYCERES")) {
                        dim = 10;
                    }
                } else {
                    s = str;
                }
                BlockTuple bt = ConfigManagerCore.stringToBlock((String)s, (String)"Other mod ore generate IDs", (boolean)true);
                if (bt == null) continue;
                int meta = bt.meta;
                if (meta == -1) {
                    meta = 0;
                }
                GSOreGenOtherMods.addOre(bt.block, meta, rarity, depth, size, extraRandom, dim);
            }
            catch (Exception e) {
                GalaxySpace.error("[config] External Sealable IDs: error parsing '" + str + "'. Must be in the form Blockname or BlockName:metadata followed by / parameters ");
            }
        }
    }

    public static class OreGenData {
        public Block oreBlock = GCBlocks.blockMoon;
        public int oreMeta = 0;
        public int sizeCluster = 4;
        public int numClusters = 8;
        public int minHeight = 0;
        public int maxHeight = 128;
        public int dimRestrict = 0;

        public OreGenData(Block block, int meta, int num, int cluster, int min, int max, int dim) {
            this.oreBlock = block;
            this.oreMeta = meta;
            this.sizeCluster = cluster;
            this.numClusters = num;
            this.minHeight = min;
            this.maxHeight = max;
            this.dimRestrict = dim;
        }

        public OreGenData(Block block, int meta, int num, int cluster) {
            this.oreBlock = block;
            this.oreMeta = meta;
            this.sizeCluster = cluster;
            this.numClusters = num;
            this.minHeight = 0;
            this.maxHeight = 128;
        }

        public OreGenData(Block block, int meta, int num) {
            this.oreBlock = block;
            this.oreMeta = meta;
            this.sizeCluster = 4;
            this.numClusters = num;
            this.minHeight = 0;
            this.maxHeight = 128;
        }
    }
}

