/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.core.tile.machine;

import cpw.mods.fml.relauncher.Side;
import galaxyspace.core.recipe.AssemblyRecipes;
import java.util.ArrayList;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.energy.tile.TileBaseElectricBlock;
import micdoodle8.mods.galacticraft.core.inventory.PersistantInventoryCrafting;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.util.Annotations;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class TileEntityAssemblyMachine
extends TileBaseElectricBlock
implements IInventory,
ISidedInventory,
IPacketReceiver {
    public static final int PROCESS_TIME_REQUIRED_BASE = 200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTimeRequired = 200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    private ItemStack producingStack = null;
    private long ticks;
    private static Random randnum = new Random();
    private ItemStack[] containingItems = new ItemStack[2];
    public PersistantInventoryCrafting testCraftMatrix = new PersistantInventoryCrafting();

    public TileEntityAssemblyMachine() {
        this.storage.setMaxExtract(ConfigManagerCore.hardMode ? 90.0f : 75.0f);
        this.setTierGC(1);
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K) {
            boolean updateInv = false;
            if (this.hasEnoughEnergyToRun && this.canCompress()) {
                ++this.processTicks;
                this.processTimeRequired = 400 / (1 + this.poweredByTierGC);
                if (this.processTicks >= this.processTimeRequired) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.anvil_land", 0.2f, 0.5f);
                    this.processTicks = 0;
                    this.compressIntoSlot(1);
                    updateInv = true;
                }
            } else {
                this.processTicks = 0;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 0L;
        }
        ++this.ticks;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    private boolean canCompress() {
        ItemStack itemstack = this.producingStack;
        if (itemstack == null) {
            return false;
        }
        if (this.containingItems[1] == null) {
            return true;
        }
        if (this.containingItems[1] != null && !this.containingItems[1].func_77969_a(itemstack)) {
            return false;
        }
        int result = this.containingItems[1] == null ? 0 : this.containingItems[1].field_77994_a + itemstack.field_77994_a;
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public void updateInput() {
        this.producingStack = AssemblyRecipes.findMatchingRecipe((IInventory)this.testCraftMatrix, this.field_145850_b);
    }

    private void compressIntoSlot(int slot) {
        if (this.canCompress()) {
            ItemStack resultItemStack = this.producingStack;
            if (this.containingItems[slot] == null) {
                this.containingItems[slot] = resultItemStack.func_77946_l();
            } else if (this.containingItems[slot].func_77969_a(resultItemStack)) {
                if (this.containingItems[slot].field_77994_a + resultItemStack.field_77994_a > 64) {
                    for (int i = 0; i < this.containingItems[slot].field_77994_a + resultItemStack.field_77994_a - 64; ++i) {
                        float var = 0.7f;
                        double dx = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                        double dy = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                        double dz = (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.7f) + (double)0.15f;
                        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + dx, (double)this.field_145848_d + dy, (double)this.field_145849_e + dz, new ItemStack(resultItemStack.func_77973_b(), 1, resultItemStack.func_77960_j()));
                        entityitem.field_145804_b = 10;
                        this.field_145850_b.func_72838_d((Entity)entityitem);
                    }
                }
                ItemStack itemStack = this.containingItems[slot];
                itemStack.field_77994_a += resultItemStack.field_77994_a;
            }
            for (int i = 0; i < this.testCraftMatrix.func_70302_i_(); ++i) {
                this.testCraftMatrix.func_70298_a(i, 1);
            }
            this.updateInput();
        }
    }

    public void func_145839_a(NBTTagCompound par1NBTTagCompound) {
        super.func_145839_a(par1NBTTagCompound);
        this.processTicks = par1NBTTagCompound.func_74762_e("smeltingTicks");
        NBTTagList var2 = par1NBTTagCompound.func_150295_c("Items", 10);
        this.containingItems = new ItemStack[this.func_70302_i_() - this.testCraftMatrix.func_70302_i_()];
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            int var5 = var4.func_74771_c("Slot") & 0xFF;
            if (var5 < this.containingItems.length) {
                this.containingItems[var5] = ItemStack.func_77949_a((NBTTagCompound)var4);
                continue;
            }
            if (var5 >= this.containingItems.length + this.testCraftMatrix.func_70302_i_()) continue;
            this.testCraftMatrix.func_70299_a(var5 - this.containingItems.length, ItemStack.func_77949_a((NBTTagCompound)var4));
        }
        this.updateInput();
    }

    public void func_145841_b(NBTTagCompound par1NBTTagCompound) {
        NBTTagCompound var4;
        int var3;
        super.func_145841_b(par1NBTTagCompound);
        par1NBTTagCompound.func_74768_a("smeltingTicks", this.processTicks);
        NBTTagList var2 = new NBTTagList();
        for (var3 = 0; var3 < this.containingItems.length; ++var3) {
            if (this.containingItems[var3] == null) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)var3);
            this.containingItems[var3].func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        for (var3 = 0; var3 < this.testCraftMatrix.func_70302_i_(); ++var3) {
            if (this.testCraftMatrix.func_70301_a(var3) == null) continue;
            var4 = new NBTTagCompound();
            var4.func_74774_a("Slot", (byte)(var3 + this.containingItems.length));
            this.testCraftMatrix.func_70301_a(var3).func_77955_b(var4);
            var2.func_74742_a((NBTBase)var4);
        }
        par1NBTTagCompound.func_74782_a("Items", (NBTBase)var2);
    }

    public int func_70302_i_() {
        return this.containingItems.length + this.testCraftMatrix.func_70302_i_();
    }

    public ItemStack func_70301_a(int par1) {
        if (par1 >= this.containingItems.length) {
            return this.testCraftMatrix.func_70301_a(par1 - this.containingItems.length);
        }
        return this.containingItems[par1];
    }

    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 >= this.containingItems.length) {
            ItemStack result = this.testCraftMatrix.func_70298_a(par1 - this.containingItems.length, par2);
            if (result != null) {
                this.updateInput();
            }
            return result;
        }
        if (this.containingItems[par1] == null) {
            return null;
        }
        if (this.containingItems[par1].field_77994_a <= par2) {
            ItemStack var3 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var3;
        }
        ItemStack var3 = this.containingItems[par1].func_77979_a(par2);
        if (this.containingItems[par1].field_77994_a == 0) {
            this.containingItems[par1] = null;
        }
        return var3;
    }

    public ItemStack func_70304_b(int par1) {
        if (par1 >= this.containingItems.length) {
            return this.testCraftMatrix.func_70304_b(par1 - this.containingItems.length);
        }
        if (this.containingItems[par1] != null) {
            ItemStack var2 = this.containingItems[par1];
            this.containingItems[par1] = null;
            return var2;
        }
        return null;
    }

    public void func_70299_a(int par1, ItemStack par2ItemStack) {
        if (par1 >= this.containingItems.length) {
            this.testCraftMatrix.func_70299_a(par1 - this.containingItems.length, par2ItemStack);
            this.updateInput();
        } else {
            this.containingItems[par1] = par2ItemStack;
            if (par2ItemStack != null && par2ItemStack.field_77994_a > this.func_70297_j_()) {
                par2ItemStack.field_77994_a = this.func_70297_j_();
            }
        }
    }

    public String func_145825_b() {
        return GCCoreUtil.translate((String)"tile.AssemblyMachine.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityplayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return itemStack != null && ItemElectricBase.isElectricItem((Item)itemStack.func_77973_b());
        }
        if (slotID < 3) {
            return false;
        }
        if (this.producingStack != null) {
            ItemStack stackInSlot = this.func_70301_a(slotID);
            return stackInSlot != null && stackInSlot.func_77969_a(itemStack);
        }
        return TileEntityAssemblyMachine.isItemCompressorInput(itemStack);
    }

    public int[] func_94128_d(int side) {
        if (side == 0) {
            return new int[]{1, 2};
        }
        int[] slots = new int[]{0, 3, 4, 5, 6, 7, 8, 9, 10, 11};
        ArrayList<Integer> removeSlots = new ArrayList<Integer>();
        block0: for (int i = 3; i < 12; ++i) {
            ItemStack stack1;
            if (removeSlots.contains(i) || (stack1 = this.func_70301_a(i)) == null || stack1.field_77994_a <= 0) continue;
            for (int j = i + 1; j < 12; ++j) {
                ItemStack stack2;
                if (removeSlots.contains(j) || (stack2 = this.func_70301_a(j)) == null || !stack1.func_77969_a(stack2)) continue;
                if (stack2.field_77994_a >= stack1.field_77994_a) {
                    removeSlots.add(j);
                    continue block0;
                }
                removeSlots.add(i);
                continue block0;
            }
        }
        if (removeSlots.size() > 0) {
            int[] returnSlots = new int[slots.length - removeSlots.size()];
            int k = 0;
            for (int l = 0; l < slots.length; ++l) {
                if (l > 0 && removeSlots.contains(slots[l])) continue;
                returnSlots[k] = slots[l];
                ++k;
            }
            return returnSlots;
        }
        return slots;
    }

    public boolean func_102007_a(int slotID, ItemStack par2ItemStack, int par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    public boolean func_102008_b(int slotID, ItemStack par2ItemStack, int par3) {
        return slotID == 1;
    }

    public boolean shouldUseEnergy() {
        return this.processTicks > 0;
    }

    public ForgeDirection getElectricInputDirection() {
        return ForgeDirection.getOrientation((int)((this.func_145832_p() & 3) + 2));
    }

    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(0);
    }

    public static boolean isItemCompressorInput(ItemStack stack) {
        for (IRecipe recipe : AssemblyRecipes.getRecipeList()) {
            if (!(recipe instanceof ShapedRecipes)) {
                if (!(recipe instanceof ShapelessOreRecipe)) continue;
                ArrayList required = new ArrayList(((ShapelessOreRecipe)recipe).getInput());
                int match = 0;
                block1: for (Object next : required) {
                    if (next instanceof ItemStack) {
                        if (!OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)stack, (boolean)false)) continue;
                        ++match;
                        continue;
                    }
                    if (!(next instanceof ArrayList)) continue;
                    for (ItemStack element : (ArrayList)next) {
                        if (!OreDictionary.itemMatches((ItemStack)element, (ItemStack)stack, (boolean)false)) continue;
                        ++match;
                        continue block1;
                    }
                }
                if (match == 0) continue;
                return match == 1 || randnum.nextInt(match) == 0;
            }
            for (ItemStack itemstack1 : ((ShapedRecipes)recipe).field_77574_d) {
                if (stack.func_77973_b() != itemstack1.func_77973_b() || itemstack1.func_77960_j() != Short.MAX_VALUE && stack.func_77960_j() != itemstack1.func_77960_j()) continue;
                return true;
            }
        }
        return false;
    }
}

