/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.navigator.api.xaero.renderers;

import com.gtnewhorizons.navigator.api.model.layers.InteractableLayer;
import com.gtnewhorizons.navigator.api.model.layers.InteractableLayerManager;
import com.gtnewhorizons.navigator.api.xaero.renderers.XaeroLayerRenderer;
import com.gtnewhorizons.navigator.api.xaero.rendersteps.XaeroInteractableStep;
import com.gtnewhorizons.navigator.api.xaero.rendersteps.XaeroRenderStep;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;

public abstract class XaeroInteractableLayerRenderer
extends XaeroLayerRenderer
implements InteractableLayer {
    protected InteractableLayerManager manager;
    protected XaeroInteractableStep hovered;

    public XaeroInteractableLayerRenderer(@Nonnull InteractableLayerManager manager) {
        super(manager);
        this.manager = manager;
    }

    public void updateHovered(double mouseX, double mouseY, double scale) {
        for (XaeroRenderStep step : this.getReversedRenderSteps()) {
            XaeroInteractableStep interactableRenderStep;
            if (!(step instanceof XaeroInteractableStep) || !(interactableRenderStep = (XaeroInteractableStep)step).isMouseOver(mouseX, mouseY, scale)) continue;
            this.hovered = interactableRenderStep;
            return;
        }
        this.hovered = null;
    }

    public void drawCustomTooltip(GuiScreen gui, double mouseX, double mouseY, double scale, int scaleAdj) {
        if (this.hovered != null) {
            this.hovered.drawCustomTooltip(gui, mouseX, mouseY, scale, scaleAdj);
        }
    }

    @Override
    public final void onMouseMove(int mouseX, int mouseY) {
        this.updateHovered(mouseX, mouseY, 1.0);
    }

    @Override
    public final boolean onMapClick(boolean isDoubleClick, int mouseX, int mouseY, int mouseBlockX, int mouseBlockZ) {
        if (!this.manager.getOpenModGui().equals((Object)this.getLayerMod())) {
            return false;
        }
        if (this.hovered != null) {
            this.onClick(isDoubleClick, mouseX, mouseY, mouseBlockX, mouseBlockZ);
            return true;
        }
        this.onClickOutsideRenderStep(isDoubleClick, mouseX, mouseY, mouseBlockX, mouseBlockZ);
        return false;
    }

    @Override
    public List<String> getTooltip() {
        ArrayList<String> tooltip = new ArrayList<String>();
        if (this.hovered != null) {
            this.hovered.getTooltip(tooltip);
        }
        return tooltip;
    }

    @Override
    public final void drawCustomTooltip(FontRenderer fontRenderer, int mouseX, int mouseY, int displayWidth, int displayHeight) {
    }

    public void onClick(boolean isDoubleClick, int mouseX, int mouseY, int mouseBlockX, int mouseBlockZ) {
        if (isDoubleClick) {
            if (this.hovered.getLocation().isActiveAsWaypoint()) {
                this.manager.clearActiveWaypoint();
            } else {
                this.manager.setActiveWaypoint(this.hovered.getLocation().toWaypoint());
            }
        }
    }

    public void onClickOutsideRenderStep(boolean isDoubleClick, int mouseX, int mouseY, int mouseBlockX, int mouseBlockZ) {
    }

    @Override
    public boolean onKeyPressed(int keyCode) {
        if (this.hovered != null && this.hovered.onKeyPressed(keyCode)) {
            this.manager.forceRefresh();
            return true;
        }
        return false;
    }
}

