/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.widget;

import com.gtnewhorizons.modularui.api.KeyboardUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.util.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.input.Keyboard;

public interface Interactable {
    @ApiStatus.OverrideOnly
    default public ClickResult onClick(int buttonId, boolean doubleClick) {
        return ClickResult.IGNORE;
    }

    @ApiStatus.OverrideOnly
    default public boolean onClickReleased(int buttonId) {
        return true;
    }

    @ApiStatus.OverrideOnly
    default public void onMouseDragged(int buttonId, long deltaTime) {
    }

    @ApiStatus.OverrideOnly
    default public boolean onMouseScroll(int direction) {
        return false;
    }

    @ApiStatus.OverrideOnly
    default public boolean onKeyPressed(char character, int keyCode) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasControlDown() {
        return KeyboardUtil.isCtrlKeyDown();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasShiftDown() {
        return KeyboardUtil.isShiftKeyDown();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean hasAltDown() {
        return KeyboardUtil.isAltKeyDown();
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isKeyPressed(int key) {
        return Keyboard.isKeyDown((int)key);
    }

    @SideOnly(value=Side.CLIENT)
    public static void playButtonClickSound() {
        Interactable.playButtonClickSound(new ResourceLocation("gui.button.press"));
    }

    @SideOnly(value=Side.CLIENT)
    public static void playButtonClickSound(ResourceLocation soundResource) {
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_147674_a((ResourceLocation)soundResource, (float)1.0f));
    }

    public static enum ClickResult {
        IGNORE,
        ACKNOWLEDGED,
        REJECT,
        DELEGATE,
        ACCEPT,
        SUCCESS;

    }
}

