/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.utils.fakeworld;

import com.cleanroommc.modularui.utils.fakeworld.BlockInfo;
import com.cleanroommc.modularui.utils.fakeworld.BlockPosUtil;
import com.cleanroommc.modularui.utils.fakeworld.PosListSchema;
import com.gtnewhorizon.gtnhlib.blockpos.BlockPos;
import java.util.function.BiPredicate;
import net.minecraft.world.World;
import org.joml.Vector3d;

public class BoxSchema
extends PosListSchema {
    private final World world;
    private final BlockPos min;
    private final BlockPos max;
    private final Vector3d center;

    public static BoxSchema of(World world, BlockPos center, int r) {
        return new BoxSchema(world, (BlockPos)center.add(-r, -r, -r), (BlockPos)center.add(r, r, r), (blockPos, blockInfo) -> true);
    }

    public static BoxSchema of(World world, BlockPos center, int r, BiPredicate<BlockPos, BlockInfo> renderFilter) {
        return new BoxSchema(world, (BlockPos)center.add(-r, -r, -r), (BlockPos)center.add(r, r, r), renderFilter);
    }

    public BoxSchema(World world, BlockPos min, BlockPos max, BiPredicate<BlockPos, BlockInfo> renderFilter) {
        super(world, BlockPosUtil.getAllInside(min, max, false), renderFilter);
        this.world = world;
        this.min = BlockPosUtil.getMin(min, max);
        this.max = BlockPosUtil.getMax(min, max);
        this.center = BlockPosUtil.getCenterD(min, max);
    }

    @Override
    public World getWorld() {
        return this.world;
    }

    @Override
    public Vector3d getFocus() {
        return this.center;
    }

    @Override
    public BlockPos getOrigin() {
        return this.min;
    }

    public BlockPos getMin() {
        return this.min;
    }

    public BlockPos getMax() {
        return this.max;
    }
}

