/*
 * Decompiled with CFR 0.152.
 */
package com.creativemd.littletiles.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import com.creativemd.littletiles.LittleTiles;
import com.creativemd.littletiles.common.items.ItemBlockTiles;
import com.creativemd.littletiles.common.utils.PlacementHelper;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S2FPacketSetSlot;
import net.minecraft.util.Vec3;

public class LittlePlacePacket
extends CreativeCorePacket {
    public ItemStack stack;
    public Vec3 hitVec;
    public Vec3 playerPos;
    public int x;
    public int y;
    public int z;
    public int side;
    public boolean customPlacement;

    public LittlePlacePacket() {
    }

    public LittlePlacePacket(ItemStack stack, Vec3 playerPos, Vec3 hitVec, int x, int y, int z, int side, boolean customPlacement) {
        this.stack = stack;
        this.playerPos = playerPos;
        this.hitVec = hitVec;
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
        this.customPlacement = customPlacement;
    }

    public void writeBytes(ByteBuf buf) {
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        LittlePlacePacket.writeVec3((Vec3)this.playerPos, (ByteBuf)buf);
        LittlePlacePacket.writeVec3((Vec3)this.hitVec, (ByteBuf)buf);
        buf.writeInt(this.x);
        buf.writeInt(this.y);
        buf.writeInt(this.z);
        buf.writeInt(this.side);
        buf.writeBoolean(this.customPlacement);
    }

    public void readBytes(ByteBuf buf) {
        this.stack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.playerPos = LittlePlacePacket.readVec3((ByteBuf)buf);
        this.hitVec = LittlePlacePacket.readVec3((ByteBuf)buf);
        this.x = buf.readInt();
        this.y = buf.readInt();
        this.z = buf.readInt();
        this.side = buf.readInt();
        this.customPlacement = buf.readBoolean();
    }

    @SideOnly(value=Side.CLIENT)
    public void executeClient(EntityPlayer player) {
    }

    public void executeServer(EntityPlayer player) {
        if (PlacementHelper.isLittleBlock(this.stack)) {
            PlacementHelper helper = PlacementHelper.getInstance(player);
            ((ItemBlockTiles)Item.func_150898_a((Block)LittleTiles.blockTile)).placeBlockAt(player, this.stack, player.field_70170_p, this.playerPos, this.hitVec, helper, this.x, this.y, this.z, this.side, this.customPlacement);
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            Slot slot = playerMP.field_71070_bA.func_75147_a((IInventory)playerMP.field_71071_by, playerMP.field_71071_by.field_70461_c);
            playerMP.field_71135_a.func_147359_a((Packet)new S2FPacketSetSlot(playerMP.field_71070_bA.field_75152_c, slot.field_75222_d, playerMP.field_71071_by.func_70448_g()));
        }
    }
}

