/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.integration;

import biomesoplenty.api.content.BOPCBiomes;
import biomesoplenty.common.configuration.BOPConfigurationBiomeGen;
import net.minecraft.world.biome.BiomeGenBase;
import ttftcuts.atg.api.ATGBiomes;

public class ATGIntegration {
    private static double nb = 0.1;
    private static double[] tiers = new double[]{1.0, 0.5, 0.3, 0.2, 0.1, 0.04};

    protected static void init() {
        ATGIntegration.addLandBiomes();
        ATGIntegration.addOceanBiomes();
    }

    private static void addLandBiomes() {
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.woodland, tiers[1] * nb);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.coniferousForest, tiers[2] * nb);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.temperateRainforest, tiers[2]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.redwoodForest, tiers[2]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.mountain, tiers[2]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.mapleWoods, tiers[3]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.seasonalForest, tiers[3]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.borealForest, tiers[3] * nb);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.deciduousForest, tiers[3]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.highland, tiers[3] * nb);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.deadForest, tiers[4]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.grove, tiers[4]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.thicket, tiers[4]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.shield, tiers[4]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.fungiForest, tiers[5]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.cherryBlossomGrove, tiers[5]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.mysticGrove, tiers[5]);
        ATGIntegration.registerATGBiome(BiomeGroup.FOREST, BOPCBiomes.originValley, tiers[5] * 0.5);
        ATGIntegration.registerATGBiome(BiomeGroup.JUNGLE, BOPCBiomes.tropicalRainforest, tiers[1]);
        ATGIntegration.registerATGBiome(BiomeGroup.JUNGLE, BOPCBiomes.rainforest, tiers[1]);
        ATGIntegration.registerATGBiome(BiomeGroup.JUNGLE, BOPCBiomes.tropics, tiers[2]);
        ATGIntegration.registerATGBiome(BiomeGroup.JUNGLE, BOPCBiomes.bambooForest, tiers[3]);
        ATGIntegration.registerATGBiome(BiomeGroup.JUNGLE, BOPCBiomes.jadeCliffs, tiers[3]);
        ATGIntegration.registerATGBiome(BiomeGroup.JUNGLE, BOPCBiomes.sacredSprings, tiers[5]);
        ATGIntegration.registerATGBiome(BiomeGroup.PLAINS, BOPCBiomes.shrubland, tiers[1] * nb);
        ATGIntegration.registerATGBiome(BiomeGroup.PLAINS, BOPCBiomes.chaparral, tiers[1]);
        ATGIntegration.registerATGBiome(BiomeGroup.PLAINS, BOPCBiomes.prairie, tiers[1]);
        ATGIntegration.registerATGBiome(BiomeGroup.PLAINS, BOPCBiomes.grassland, tiers[2]);
        ATGIntegration.registerATGBiome(BiomeGroup.PLAINS, BOPCBiomes.meadow, tiers[3]);
        ATGIntegration.registerATGBiome(BiomeGroup.PLAINS, BOPCBiomes.lavenderFields, tiers[4]);
        ATGIntegration.registerATGBiome(BiomeGroup.PLAINS, BOPCBiomes.garden, tiers[5]);
        ATGIntegration.registerATGBiome(BiomeGroup.ICE_PLAINS, BOPCBiomes.alps, tiers[0]);
        ATGIntegration.registerATGBiome(BiomeGroup.ICE_PLAINS, BOPCBiomes.glacier, tiers[2]);
        ATGIntegration.registerATGBiome(BiomeGroup.ICE_PLAINS, BOPCBiomes.arctic, tiers[2]);
    }

    private static void addOceanBiomes() {
        ATGIntegration.registerATGBiome(BiomeGroup.OCEAN, BOPCBiomes.coralReef, 0.05f);
        ATGIntegration.registerATGBiome(BiomeGroup.OCEAN, BOPCBiomes.kelpForest, 0.1f);
    }

    private static void addModifiers() {
    }

    private static void registerATGBiome(BiomeGroup group, BiomeGenBase biome, double weight) {
        if (BOPConfigurationBiomeGen.config.get("Overworld Biomes To Generate", biome.field_76791_y, true).getBoolean(false)) {
            ATGBiomes.addBiome((ATGBiomes.BiomeType)group.biomeType, (String)group.toString(), (BiomeGenBase)biome, (double)weight);
        }
    }

    public static void registerATGSubBiome(BiomeGenBase parent, BiomeGenBase subBiome) {
    }

    private static enum BiomeGroup {
        FOREST(ATGBiomes.BiomeType.LAND),
        JUNGLE(ATGBiomes.BiomeType.LAND),
        PLAINS(ATGBiomes.BiomeType.LAND),
        ICE_PLAINS(ATGBiomes.BiomeType.LAND),
        TAIGA(ATGBiomes.BiomeType.LAND),
        DESERT(ATGBiomes.BiomeType.LAND),
        SHRUBLAND(ATGBiomes.BiomeType.LAND),
        BOREAL_FOREST(ATGBiomes.BiomeType.LAND),
        TUNDRA(ATGBiomes.BiomeType.LAND),
        STEPPE(ATGBiomes.BiomeType.LAND),
        SAVANNA(ATGBiomes.BiomeType.LAND),
        TROPICAL_SHRUBLAND(ATGBiomes.BiomeType.LAND),
        WOODLAND(ATGBiomes.BiomeType.LAND),
        MESA(ATGBiomes.BiomeType.LAND),
        SWAMPLAND(ATGBiomes.BiomeType.LAND),
        OCEAN(ATGBiomes.BiomeType.SEA);

        public final ATGBiomes.BiomeType biomeType;

        private BiomeGroup(ATGBiomes.BiomeType biomeType) {
            this.biomeType = biomeType;
        }
    }
}

