/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.dungeon.rooms;

import greymerk.roguelike.dungeon.Dungeon;
import greymerk.roguelike.dungeon.base.DungeonBase;
import greymerk.roguelike.dungeon.settings.LevelSettings;
import greymerk.roguelike.treasure.Treasure;
import greymerk.roguelike.worldgen.BlockWeightedRandom;
import greymerk.roguelike.worldgen.Cardinal;
import greymerk.roguelike.worldgen.Coord;
import greymerk.roguelike.worldgen.IWorldEditor;
import greymerk.roguelike.worldgen.Spawner;
import greymerk.roguelike.worldgen.blocks.BlockType;
import greymerk.roguelike.worldgen.shapes.RectSolid;
import java.util.Random;

public class DungeonsSpiderNest
extends DungeonBase {
    IWorldEditor editor;
    Random rand;
    int originX;
    int originY;
    int originZ;
    byte dungeonHeight = (byte)2;
    int dungeonLength = 3;
    int dungeonWidth = 3;

    @Override
    public boolean generate(IWorldEditor editor, Random inRandom, LevelSettings settings, Cardinal[] entrances, Coord origin) {
        this.editor = editor;
        this.rand = inRandom;
        this.originX = origin.getX();
        this.originY = origin.getY();
        this.originZ = origin.getZ();
        BlockWeightedRandom webs = new BlockWeightedRandom();
        webs.addBlock(BlockType.get(BlockType.WEB), 3);
        webs.addBlock(BlockType.get(BlockType.AIR), 1);
        for (int blockX = this.originX - this.dungeonLength - 1; blockX <= this.originX + this.dungeonLength + 1; ++blockX) {
            for (int blockZ = this.originZ - this.dungeonWidth - 1; blockZ <= this.originZ + this.dungeonWidth + 1; ++blockZ) {
                for (int blockY = this.originY + this.dungeonHeight; blockY >= this.originY - this.dungeonHeight; --blockY) {
                    int z;
                    int clearHeight;
                    int x = Math.abs(blockX - this.originX);
                    int n = clearHeight = x > (z = Math.abs(blockZ - this.originZ)) ? x : z;
                    if (blockY == this.originY) {
                        webs.set(editor, inRandom, new Coord(blockX, blockY, blockZ));
                    }
                    if (clearHeight < 1) {
                        clearHeight = 1;
                    }
                    if (Math.abs(blockY - this.originY) > clearHeight) continue;
                    if (this.rand.nextInt(clearHeight) == 0) {
                        webs.set(editor, inRandom, new Coord(blockX, blockY, blockZ));
                        continue;
                    }
                    if (this.rand.nextInt(5) != 0) continue;
                    BlockType.get(BlockType.GRAVEL).set(editor, new Coord(blockX, blockY, blockZ));
                }
            }
        }
        Spawner.generate(editor, this.rand, settings, new Coord(this.originX, this.originY, this.originZ), Spawner.CAVESPIDER);
        Treasure.createChests(editor, this.rand, 1 + this.rand.nextInt(3), new RectSolid(new Coord(this.originX - this.dungeonLength, this.originY - 1, this.originZ - this.dungeonWidth), new Coord(this.originX + this.dungeonLength, this.originY + 1, this.originZ + this.dungeonWidth)).get(), Dungeon.getLevel(this.originY));
        return true;
    }

    @Override
    public int getSize() {
        return 4;
    }
}

