/*
 * Decompiled with CFR 0.152.
 */
package serverutils.task;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import serverutils.ServerUtilities;
import serverutils.ServerUtilitiesNotifications;
import serverutils.data.ServerUtilitiesPlayerData;
import serverutils.data.TeleportType;
import serverutils.lib.data.Universe;
import serverutils.lib.math.BlockDimPos;
import serverutils.lib.math.TeleporterDimPos;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.StringUtils;
import serverutils.lib.util.text_components.Notification;
import serverutils.task.Task;

public class TeleportTask
extends Task {
    private final EntityPlayerMP player;
    private final ServerUtilitiesPlayerData.Timer timer;
    private final BlockDimPos startPos;
    private final Function<EntityPlayerMP, TeleporterDimPos> pos;
    private final float startHP;
    private final int startSeconds;
    private int secondsLeft;
    private final Task extraTask;
    private final TeleportType teleportType;

    public TeleportTask(TeleportType teleportType, EntityPlayerMP player, ServerUtilitiesPlayerData.Timer ticks, int secStart, Function<EntityPlayerMP, TeleporterDimPos> to, @Nullable Task task) {
        super(0L);
        this.teleportType = teleportType;
        this.player = player;
        this.timer = ticks;
        this.startPos = new BlockDimPos((EntityPlayer)player);
        this.startHP = player.func_110143_aJ();
        this.pos = to;
        this.startSeconds = secStart;
        this.secondsLeft = secStart;
        this.extraTask = task;
    }

    @Override
    public void execute(Universe universe) {
        if (!this.startPos.equalsPos(new BlockDimPos((EntityPlayer)this.player)) || this.startHP > this.player.func_110143_aJ()) {
            this.player.func_145747_a(StringUtils.color(ServerUtilities.lang((ICommandSender)this.player, "stand_still_failed", new Object[0]), EnumChatFormatting.RED));
        } else if (this.secondsLeft <= 1) {
            TeleporterDimPos teleporter = this.pos.apply(this.player);
            if (teleporter != null) {
                Entity mount = this.player.field_70154_o;
                this.player.func_70078_a(null);
                if (mount != null) {
                    teleporter.teleport(mount);
                }
                ServerUtilitiesPlayerData data = ServerUtilitiesPlayerData.get(universe.getPlayer((ICommandSender)this.player));
                data.setLastTeleport(this.teleportType, new BlockDimPos((EntityPlayer)this.player));
                teleporter.teleport((Entity)this.player);
                data.lastTeleport[this.timer.ordinal()] = System.currentTimeMillis();
                if (this.secondsLeft != 0) {
                    this.player.func_145747_a(ServerUtilities.lang((ICommandSender)this.player, "teleporting", new Object[0]));
                }
                if (this.extraTask != null) {
                    this.extraTask.execute(universe);
                }
            }
        } else {
            --this.secondsLeft;
            this.setNextTime(System.currentTimeMillis() + Ticks.SECOND.millis());
            universe.scheduleTask(this);
            IChatComponent component = StringUtils.color(ServerUtilities.lang((ICommandSender)this.player, "stand_still", this.startSeconds).func_150258_a(" [" + this.secondsLeft + "]"), EnumChatFormatting.GOLD);
            Notification.of(ServerUtilitiesNotifications.TELEPORT_WARMUP, component).setVanilla(true).send(this.player.field_71133_b, (EntityPlayer)this.player);
        }
    }
}

