/*
 * Decompiled with CFR 0.152.
 */
package appeng.me.pathfinding;

import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridMultiblock;
import appeng.api.networking.IGridNode;
import appeng.me.cache.PathGridCache;
import appeng.me.pathfinding.BackbonePathSegment;
import appeng.me.pathfinding.IPathItem;
import appeng.me.pathfinding.TopologyStage;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PathSegment {
    private final PathGridCache pgc;
    private final Set<IPathItem> semiOpen;
    protected final Set<IPathItem> closed;
    private boolean isDead;
    protected List<IPathItem> open;

    public PathSegment(PathGridCache myPGC, List<IPathItem> open, Set<IPathItem> semiOpen, Set<IPathItem> closed) {
        this.open = open;
        this.semiOpen = semiOpen;
        this.closed = closed;
        this.pgc = myPGC;
        this.setDead(false);
    }

    public boolean step(Map<IPathItem, BackbonePathSegment> backbone, TopologyStage stage) {
        List<IPathItem> oldOpen = this.open;
        this.open = new LinkedList<IPathItem>();
        for (IPathItem i : oldOpen) {
            for (IPathItem pi : i.getPossibleOptions()) {
                BackbonePathSegment bb;
                EnumSet<GridFlags> flags = pi.getFlags();
                if (!this.closed.contains(pi)) {
                    boolean stopHere = false;
                    if (flags.contains((Object)GridFlags.ULTRA_DENSE_CAPACITY) && stage == TopologyStage.CONTROLLER_TO_BACKBONE) {
                        backbone.computeIfAbsent(pi, k -> new BackbonePathSegment(pi, this.pgc, this.semiOpen, this.closed)).addControllerRoute(i);
                        stopHere = true;
                    }
                    pi.setControllerRoute(i, true);
                    if (flags.contains((Object)GridFlags.REQUIRE_CHANNEL) && stage != TopologyStage.BACKBONE) {
                        if (!this.semiOpen.contains(pi)) {
                            boolean worked = this.useChannel(pi, flags.contains((Object)GridFlags.COMPRESSED_CHANNEL));
                            if (worked && flags.contains((Object)GridFlags.MULTIBLOCK)) {
                                Iterator<IGridNode> oni = ((IGridMultiblock)((IGridNode)((Object)pi)).getGridBlock()).getMultiblockNodes();
                                while (oni.hasNext()) {
                                    IGridNode otherNodes = oni.next();
                                    if (otherNodes == pi) continue;
                                    this.semiOpen.add((IPathItem)((Object)otherNodes));
                                }
                            }
                        } else {
                            pi.incrementChannelCount(1);
                            this.semiOpen.remove(pi);
                        }
                    }
                    if (stopHere) continue;
                    this.closed.add(pi);
                    this.open.add(pi);
                    continue;
                }
                if (stage != TopologyStage.BACKBONE || (bb = backbone.get(pi)) == null || bb == this) continue;
                bb.addPathToNeighbour((BackbonePathSegment)this, i);
            }
        }
        return this.open.isEmpty();
    }

    private boolean useChannel(IPathItem start, boolean p2p) {
        for (IPathItem pi = start; pi != null; pi = pi.getControllerRoute()) {
            if (pi.canSupportMoreChannels() && (!p2p || !pi.getFlags().contains((Object)GridFlags.CANNOT_CARRY_COMPRESSED))) continue;
            return false;
        }
        boolean haveBlockingNode = false;
        IPathItem lastBackboneConnection = null;
        for (IPathItem pi = start; pi != null; pi = pi.getControllerRoute()) {
            this.pgc.setChannelsByBlocks(this.pgc.getChannelsByBlocks() + 1);
            pi.incrementChannelCount(1);
            if (!pi.canSupportMoreChannels()) {
                haveBlockingNode = true;
            }
            if (!this.pgc.isValidBackboneConnection(pi)) continue;
            lastBackboneConnection = pi;
        }
        if (haveBlockingNode && lastBackboneConnection != null) {
            this.pgc.repathBackboneConnection(lastBackboneConnection);
        }
        this.pgc.setChannelsInUse(this.pgc.getChannelsInUse() + 1);
        return true;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean isDead) {
        this.isDead = isDead;
    }
}

