/*
 * Decompiled with CFR 0.152.
 */
package appeng.spatial;

import appeng.api.AEApi;
import appeng.api.definitions.IBlockDefinition;
import appeng.api.movable.IMovableHandler;
import appeng.api.movable.IMovableRegistry;
import appeng.api.util.WorldCoord;
import appeng.core.AELog;
import appeng.core.worlddata.WorldData;
import appeng.util.Platform;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.NextTickListEntry;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.util.ForgeDirection;

public class CachedPlane {
    private final int x_size;
    private final int z_size;
    private final int cx_size;
    private final int cz_size;
    private final int x_offset;
    private final int y_offset;
    private final int z_offset;
    private final int y_size;
    private final Chunk[][] myChunks;
    private final Column[][] myColumns;
    private final LinkedList<TileEntity> tiles = new LinkedList();
    private final LinkedList<NextTickListEntry> ticks = new LinkedList();
    private final World world;
    private final IMovableRegistry reg = AEApi.instance().registries().movable();
    private final LinkedList<WorldCoord> updates = new LinkedList();
    private final IBlockDefinition matrixFrame = AEApi.instance().definitions().blocks().matrixFrame();
    private int verticalBits;

    public CachedPlane(World w, int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.world = w;
        this.x_size = maxX - minX + 1;
        this.y_size = maxY - minY + 1;
        this.z_size = maxZ - minZ + 1;
        this.x_offset = minX;
        this.y_offset = minY;
        this.z_offset = minZ;
        int minCX = minX >> 4;
        int minCY = minY >> 4;
        int minCZ = minZ >> 4;
        int maxCX = maxX >> 4;
        int maxCY = maxY >> 4;
        int maxCZ = maxZ >> 4;
        this.cx_size = maxCX - minCX + 1;
        int cy_size = maxCY - minCY + 1;
        this.cz_size = maxCZ - minCZ + 1;
        this.myChunks = new Chunk[this.cx_size][this.cz_size];
        this.myColumns = new Column[this.x_size][this.z_size];
        this.verticalBits = 0;
        for (int cy = 0; cy < cy_size; ++cy) {
            this.verticalBits |= 1 << minCY + cy;
        }
        for (int x = 0; x < this.x_size; ++x) {
            for (int z = 0; z < this.z_size; ++z) {
                this.myColumns[x][z] = new Column(w.func_72964_e(minX + x >> 4, minZ + z >> 4), minX + x & 0xF, minZ + z & 0xF, minCY, cy_size);
            }
        }
        IMovableRegistry mr = AEApi.instance().registries().movable();
        for (int cx = 0; cx < this.cx_size; ++cx) {
            for (int cz = 0; cz < this.cz_size; ++cz) {
                Chunk c;
                LinkedList<ChunkPosition> deadTiles = new LinkedList<ChunkPosition>();
                this.myChunks[cx][cz] = c = w.func_72964_e(minCX + cx, minCZ + cz);
                LinkedList rawTiles = new LinkedList(c.field_150816_i.entrySet());
                for (Map.Entry entry : rawTiles) {
                    ChunkPosition cp = (ChunkPosition)entry.getKey();
                    TileEntity te = (TileEntity)entry.getValue();
                    if (te.field_145851_c < minX || te.field_145851_c > maxX || te.field_145848_d < minY || te.field_145848_d > maxY || te.field_145849_e < minZ || te.field_145849_e > maxZ) continue;
                    if (mr.askToMove(te)) {
                        this.tiles.add(te);
                        deadTiles.add(cp);
                        continue;
                    }
                    Object[] details = this.myColumns[te.field_145851_c - minX][te.field_145849_e - minZ].getDetails(te.field_145848_d);
                    Block blk = (Block)details[0];
                    if (blk != null && blk.isAir((IBlockAccess)c.field_76637_e, te.field_145851_c, te.field_145848_d, te.field_145849_e) && blk.isReplaceable((IBlockAccess)c.field_76637_e, te.field_145851_c, te.field_145848_d, te.field_145849_e)) {
                        c.field_76637_e.func_147449_b(te.field_145851_c, te.field_145848_d, te.field_145849_e, Platform.AIR_BLOCK);
                        c.field_76637_e.func_147459_d(te.field_145851_c, te.field_145848_d, te.field_145849_e, Platform.AIR_BLOCK);
                        continue;
                    }
                    this.myColumns[te.field_145851_c - minX][te.field_145849_e - minZ].setSkip(te.field_145848_d);
                }
                for (ChunkPosition chunkPosition : deadTiles) {
                    c.field_150816_i.remove(chunkPosition);
                }
                long k = this.getWorld().func_82737_E();
                List list = this.getWorld().func_72920_a(c, false);
                if (list == null) continue;
                for (Object o : list) {
                    NextTickListEntry entry = (NextTickListEntry)o;
                    if (entry.field_77183_a < minX || entry.field_77183_a > maxX || entry.field_77181_b < minY || entry.field_77181_b > maxY || entry.field_77182_c < minZ || entry.field_77182_c > maxZ) continue;
                    NextTickListEntry newEntry = new NextTickListEntry(entry.field_77183_a, entry.field_77181_b, entry.field_77182_c, entry.func_151351_a());
                    newEntry.field_77180_e = entry.field_77180_e - k;
                    this.ticks.add(newEntry);
                }
            }
        }
        for (TileEntity te : this.tiles) {
            try {
                this.getWorld().field_147482_g.remove(te);
            }
            catch (Exception e) {
                AELog.debug(e);
            }
        }
    }

    private IMovableHandler getHandler(TileEntity te) {
        IMovableRegistry mr = AEApi.instance().registries().movable();
        return mr.getHandler(te);
    }

    void swap(CachedPlane dst) {
        IMovableRegistry mr = AEApi.instance().registries().movable();
        if (dst.x_size == this.x_size && dst.y_size == this.y_size && dst.z_size == this.z_size) {
            AELog.info("Block Copy Scale: " + this.x_size + ", " + this.y_size + ", " + this.z_size, new Object[0]);
            long startTime = System.nanoTime();
            for (int x = 0; x < this.x_size; ++x) {
                for (int z = 0; z < this.z_size; ++z) {
                    Column a = this.myColumns[x][z];
                    Column b = dst.myColumns[x][z];
                    for (int y = 0; y < this.y_size; ++y) {
                        int src_y = y + this.y_offset;
                        int dst_y = y + dst.y_offset;
                        if (a.doNotSkip(src_y) && b.doNotSkip(dst_y)) {
                            Object[] aD = a.getDetails(src_y);
                            Object[] bD = b.getDetails(dst_y);
                            a.setBlockIDWithMetadata(src_y, bD);
                            b.setBlockIDWithMetadata(dst_y, aD);
                            continue;
                        }
                        this.markForUpdate(x + this.x_offset, src_y, z + this.z_offset);
                        dst.markForUpdate(x + dst.x_offset, dst_y, z + dst.z_offset);
                    }
                }
            }
            long endTime = System.nanoTime();
            long duration = endTime - startTime;
            AELog.info("Block Copy Time: " + duration, new Object[0]);
            for (TileEntity te : this.tiles) {
                dst.addTile(te.field_145851_c - this.x_offset, te.field_145848_d - this.y_offset, te.field_145849_e - this.z_offset, te, this, mr);
            }
            for (TileEntity te : dst.tiles) {
                this.addTile(te.field_145851_c - dst.x_offset, te.field_145848_d - dst.y_offset, te.field_145849_e - dst.z_offset, te, dst, mr);
            }
            for (NextTickListEntry entry : this.ticks) {
                dst.addTick(entry.field_77183_a - this.x_offset, entry.field_77181_b - this.y_offset, entry.field_77182_c - this.z_offset, entry);
            }
            for (NextTickListEntry entry : dst.ticks) {
                this.addTick(entry.field_77183_a - dst.x_offset, entry.field_77181_b - dst.y_offset, entry.field_77182_c - dst.z_offset, entry);
            }
            startTime = System.nanoTime();
            this.updateChunks();
            dst.updateChunks();
            endTime = System.nanoTime();
            duration = endTime - startTime;
            AELog.info("Update Time: " + duration, new Object[0]);
        }
    }

    private void markForUpdate(int x, int y, int z) {
        this.getUpdates().add(new WorldCoord(x, y, z));
        for (ForgeDirection d : ForgeDirection.VALID_DIRECTIONS) {
            this.getUpdates().add(new WorldCoord(x + d.offsetX, y + d.offsetY, z + d.offsetZ));
        }
    }

    private void addTick(int x, int y, int z, NextTickListEntry entry) {
        this.getWorld().func_147464_a(x + this.x_offset, y + this.y_offset, z + this.z_offset, entry.func_151351_a(), (int)entry.field_77180_e);
    }

    private void addTile(int x, int y, int z, TileEntity te, CachedPlane alternateDestination, IMovableRegistry mr) {
        block6: {
            try {
                Column c = this.myColumns[x][z];
                if (c.doNotSkip(y + this.y_offset) || alternateDestination == null) {
                    block5: {
                        IMovableHandler handler = this.getHandler(te);
                        try {
                            handler.moveTile(te, this.getWorld(), x + this.x_offset, y + this.y_offset, z + this.z_offset);
                        }
                        catch (Throwable e) {
                            AELog.debug(e);
                            te.func_145834_a(this.getWorld());
                            te.field_145851_c = x;
                            te.field_145848_d = y;
                            te.field_145849_e = z;
                            c.c.func_150812_a(c.x, y + y, c.z, te);
                            if (!((Column)c).c.field_76636_d) break block5;
                            this.getWorld().addTileEntity(te);
                            this.getWorld().func_147471_g(x, y, z);
                        }
                    }
                    mr.doneMoving(te);
                    break block6;
                }
                alternateDestination.addTile(x, y, z, te, null, mr);
            }
            catch (Throwable e) {
                AELog.debug(e);
            }
        }
    }

    private void updateChunks() {
        Chunk c;
        int z;
        int x;
        for (x = 0; x < this.cx_size; ++x) {
            for (z = 0; z < this.cz_size; ++z) {
                c = this.myChunks[x][z];
                c.func_76613_n();
                c.func_76603_b();
                c.field_76643_l = true;
            }
        }
        for (x = 0; x < this.cx_size; ++x) {
            for (z = 0; z < this.cz_size; ++z) {
                c = this.myChunks[x][z];
                for (int y = 1; y < 255; y += 32) {
                    WorldData.instance().compassData().service().updateArea(this.getWorld(), c.field_76635_g << 4, y, c.field_76647_h << 4);
                }
                Platform.sendChunk(c, this.verticalBits);
            }
        }
    }

    LinkedList<WorldCoord> getUpdates() {
        return this.updates;
    }

    World getWorld() {
        return this.world;
    }

    private class Column {
        private final int x;
        private final int z;
        private final Chunk c;
        private final Object[] ch = new Object[]{0, 0, 0};
        private final ExtendedBlockStorage[] storage;
        private List<Integer> skipThese = null;

        public Column(Chunk chunk, int x, int z, int chunkY, int chunkHeight) {
            this.x = x;
            this.z = z;
            this.c = chunk;
            this.storage = this.c.func_76587_i();
            for (int ay = 0; ay < chunkHeight; ++ay) {
                int by = ay + chunkY;
                ExtendedBlockStorage extendedblockstorage = this.storage[by];
                if (extendedblockstorage != null) continue;
                extendedblockstorage = this.storage[by] = new ExtendedBlockStorage(by << 4, !this.c.field_76637_e.field_73011_w.field_76576_e);
            }
        }

        private void setBlockIDWithMetadata(int y, Object[] blk) {
            for (Block matrixFrameBlock : CachedPlane.this.matrixFrame.maybeBlock().asSet()) {
                if (blk[0] != matrixFrameBlock) continue;
                blk[0] = Platform.AIR_BLOCK;
                break;
            }
            ExtendedBlockStorage extendedBlockStorage = this.storage[y >> 4];
            extendedBlockStorage.func_150818_a(this.x, y & 0xF, this.z, (Block)blk[0]);
            extendedBlockStorage.func_76654_b(this.x, y & 0xF, this.z, ((Integer)blk[1]).intValue());
            extendedBlockStorage.func_76677_d(this.x, y & 0xF, this.z, ((Integer)blk[2]).intValue());
        }

        private Object[] getDetails(int y) {
            ExtendedBlockStorage extendedblockstorage = this.storage[y >> 4];
            this.ch[0] = extendedblockstorage.func_150819_a(this.x, y & 0xF, this.z);
            this.ch[1] = extendedblockstorage.func_76665_b(this.x, y & 0xF, this.z);
            this.ch[2] = extendedblockstorage.func_76674_d(this.x, y & 0xF, this.z);
            return this.ch;
        }

        private boolean doNotSkip(int y) {
            ExtendedBlockStorage extendedblockstorage = this.storage[y >> 4];
            if (CachedPlane.this.reg.isBlacklisted(extendedblockstorage.func_150819_a(this.x, y & 0xF, this.z))) {
                return false;
            }
            return this.skipThese == null || !this.skipThese.contains(y);
        }

        private void setSkip(int yCoord) {
            if (this.skipThese == null) {
                this.skipThese = new LinkedList<Integer>();
            }
            this.skipThese.add(yCoord);
        }
    }
}

