/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.core.lib.utils;

import buildcraft.api.core.BlockIndex;
import buildcraft.api.core.BuildCraftAPI;
import buildcraft.api.core.IZone;
import buildcraft.core.lib.utils.IBlockFilter;
import buildcraft.core.lib.utils.IIterableAlgorithm;
import buildcraft.core.lib.utils.PathFinding;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.world.World;

public class PathFindingSearch
implements IIterableAlgorithm {
    public static final int PATH_ITERATIONS = 1000;
    private static final HashMap<Integer, HashSet<BlockIndex>> reservations = new HashMap();
    private World world;
    private BlockIndex start;
    private List<PathFinding> pathFinders;
    private IBlockFilter pathFound;
    private IZone zone;
    private float maxDistance;
    private Iterator<BlockIndex> blockIter;
    private double maxDistanceToEnd;

    public PathFindingSearch(World iWorld, BlockIndex iStart, Iterator<BlockIndex> iBlockIter, IBlockFilter iPathFound, double iMaxDistanceToEnd, float iMaxDistance, IZone iZone) {
        this.world = iWorld;
        this.start = iStart;
        this.pathFound = iPathFound;
        this.maxDistance = iMaxDistance;
        this.maxDistanceToEnd = iMaxDistanceToEnd;
        this.zone = iZone;
        this.blockIter = iBlockIter;
        this.pathFinders = new LinkedList<PathFinding>();
    }

    @Override
    public void iterate() {
        if (this.pathFinders.size() < 5 && this.blockIter.hasNext()) {
            this.iterateSearch(10000);
        }
        this.iteratePathFind(1000);
    }

    private void iterateSearch(int itNumber) {
        for (int i = 0; i < itNumber; ++i) {
            if (!this.blockIter.hasNext()) {
                return;
            }
            BlockIndex delta = this.blockIter.next();
            BlockIndex block = new BlockIndex(this.start.x + delta.x, this.start.y + delta.y > 0 ? this.start.y + delta.y : 0, this.start.z + delta.z);
            if (this.isLoadedChunk(block.x, block.z) && this.isTarget(block)) {
                this.pathFinders.add(new PathFinding(this.world, this.start, block, this.maxDistanceToEnd, this.maxDistance));
            }
            if (this.pathFinders.size() < 5) continue;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isTarget(BlockIndex block) {
        if (this.zone != null && !this.zone.contains(block.x, block.y, block.z)) {
            return false;
        }
        if (!this.pathFound.matches(this.world, block.x, block.y, block.z)) {
            return false;
        }
        HashMap<Integer, HashSet<BlockIndex>> hashMap = reservations;
        synchronized (hashMap) {
            HashSet<BlockIndex> dimReservations;
            if (reservations.containsKey(this.world.field_73011_w.field_76574_g) && (dimReservations = reservations.get(this.world.field_73011_w.field_76574_g)).contains(block)) {
                return false;
            }
        }
        return BuildCraftAPI.isSoftBlock(this.world, block.x - 1, block.y, block.z) || BuildCraftAPI.isSoftBlock(this.world, block.x + 1, block.y, block.z) || BuildCraftAPI.isSoftBlock(this.world, block.x, block.y, block.z - 1) || BuildCraftAPI.isSoftBlock(this.world, block.x, block.y, block.z + 1) || BuildCraftAPI.isSoftBlock(this.world, block.x, block.y - 1, block.z) || BuildCraftAPI.isSoftBlock(this.world, block.x, block.y + 1, block.z);
    }

    private boolean isLoadedChunk(int x, int z) {
        return this.world.func_72863_F().func_73149_a(x >> 4, z >> 4);
    }

    public void iteratePathFind(int itNumber) {
        for (PathFinding pathFinding : new ArrayList<PathFinding>(this.pathFinders)) {
            pathFinding.iterate(itNumber / this.pathFinders.size());
            if (!pathFinding.isDone()) continue;
            LinkedList<BlockIndex> path = pathFinding.getResult();
            if (path != null && path.size() > 0 && this.reserve(pathFinding.end())) {
                return;
            }
            this.pathFinders.remove(pathFinding);
        }
    }

    @Override
    public boolean isDone() {
        for (PathFinding pathFinding : this.pathFinders) {
            if (!pathFinding.isDone()) continue;
            return true;
        }
        return !this.blockIter.hasNext();
    }

    public LinkedList<BlockIndex> getResult() {
        for (PathFinding pathFinding : this.pathFinders) {
            if (!pathFinding.isDone()) continue;
            return pathFinding.getResult();
        }
        return new LinkedList<BlockIndex>();
    }

    public BlockIndex getResultTarget() {
        for (PathFinding pathFinding : this.pathFinders) {
            if (!pathFinding.isDone()) continue;
            return pathFinding.end();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean reserve(BlockIndex block) {
        HashMap<Integer, HashSet<BlockIndex>> hashMap = reservations;
        synchronized (hashMap) {
            HashSet<BlockIndex> dimReservations;
            if (!reservations.containsKey(this.world.field_73011_w.field_76574_g)) {
                reservations.put(this.world.field_73011_w.field_76574_g, new HashSet());
            }
            if ((dimReservations = reservations.get(this.world.field_73011_w.field_76574_g)).contains(block)) {
                return false;
            }
            dimReservations.add(block);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unreserve(BlockIndex block) {
        HashMap<Integer, HashSet<BlockIndex>> hashMap = reservations;
        synchronized (hashMap) {
            if (reservations.containsKey(this.world.field_73011_w.field_76574_g)) {
                reservations.get(this.world.field_73011_w.field_76574_g).remove(block);
            }
        }
    }
}

