/*
 * Decompiled with CFR 0.152.
 */
package gcewing.architecture;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import gcewing.architecture.ArchitectureCraft;
import gcewing.architecture.client.render.BlockRenderDispatcher;
import gcewing.architecture.client.render.ICustomRenderer;
import gcewing.architecture.client.render.ITexture;
import gcewing.architecture.client.render.ItemRenderDispatcher;
import gcewing.architecture.client.render.PreviewRenderer;
import gcewing.architecture.client.render.RenderWindow;
import gcewing.architecture.client.render.RendererBaseModel;
import gcewing.architecture.client.render.RendererCladding;
import gcewing.architecture.client.render.ShapeRenderDispatch;
import gcewing.architecture.client.render.model.IArchitectureModel;
import gcewing.architecture.client.render.target.IRenderTarget;
import gcewing.architecture.client.render.target.RenderTargetGL;
import gcewing.architecture.client.texture.ArchitectureTexture;
import gcewing.architecture.client.texture.ITextureConsumer;
import gcewing.architecture.client.texture.TextureSprite;
import gcewing.architecture.common.block.BlockArchitecture;
import gcewing.architecture.common.block.IBlockArchitecture;
import gcewing.architecture.common.item.IHasModel;
import gcewing.architecture.common.render.ModelSpec;
import gcewing.architecture.compat.BlockCompatUtils;
import gcewing.architecture.compat.BlockPos;
import gcewing.architecture.compat.EnumWorldBlockLayer;
import gcewing.architecture.compat.IBlockState;
import gcewing.architecture.compat.Trans3;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;

public class ArchitectureCraftClient {
    public static final ShapeRenderDispatch shapeRenderDispatch = new ShapeRenderDispatch();
    public static final PreviewRenderer previewRenderer = new PreviewRenderer();
    protected final Map<IBlockArchitecture, ICustomRenderer> blockRenderers = new HashMap<IBlockArchitecture, ICustomRenderer>();
    public final Map<Item, ICustomRenderer> itemRenderers = new HashMap<Item, ICustomRenderer>();
    protected final Map<IBlockState, ICustomRenderer> stateRendererCache = new HashMap<IBlockState, ICustomRenderer>();
    protected final TextureCache[] textureCaches = new TextureCache[2];
    public static final EnumWorldBlockLayer[][] passLayers = new EnumWorldBlockLayer[][]{{EnumWorldBlockLayer.SOLID, EnumWorldBlockLayer.CUTOUT_MIPPED, EnumWorldBlockLayer.CUTOUT, EnumWorldBlockLayer.TRANSLUCENT}, {EnumWorldBlockLayer.SOLID, EnumWorldBlockLayer.CUTOUT_MIPPED, EnumWorldBlockLayer.CUTOUT}, {EnumWorldBlockLayer.TRANSLUCENT}};
    protected BlockRenderDispatcher blockRenderDispatcher;
    protected ItemRenderDispatcher itemRenderDispatcher;
    public static final RenderTargetGL glTarget = new RenderTargetGL();
    public static final Trans3 entityTrans = Trans3.blockCenter;
    public static final Trans3 equippedTrans = Trans3.blockCenter;
    public static final Trans3 firstPersonTrans = Trans3.blockCenterSideTurn(0, 3);
    public static final Trans3 inventoryTrans = Trans3.blockCenter;

    public void preInit(FMLPreInitializationEvent e) {
        this.registerBlockRenderers();
        this.registerItemRenderers();
        this.registerDefaultRenderers();
        this.removeUnusedDefaultTextureNames();
    }

    public void init(FMLInitializationEvent e) {
    }

    public void postInit(FMLPostInitializationEvent e) {
        MinecraftForge.EVENT_BUS.register((Object)previewRenderer);
        FMLCommonHandler.instance().bus().register((Object)previewRenderer);
    }

    public ArchitectureCraftClient(ArchitectureCraft mod) {
        for (int i = 0; i < 2; ++i) {
            this.textureCaches[i] = new TextureCache();
        }
        RenderWindow.init(this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        FMLCommonHandler.instance().bus().register((Object)this);
    }

    public ResourceLocation textureLocation(String path) {
        return ArchitectureCraft.resourceLocation("textures/" + path);
    }

    public static void bindTexture(ResourceLocation rsrc) {
        TextureManager tm = Minecraft.func_71410_x().func_110434_K();
        tm.func_110577_a(rsrc);
    }

    protected void registerBlockRenderers() {
        this.addBlockRenderer(ArchitectureCraft.content.blockShape, shapeRenderDispatch);
        this.addBlockRenderer(ArchitectureCraft.content.blockShapeSE, shapeRenderDispatch);
    }

    protected void registerItemRenderers() {
        this.addItemRenderer(ArchitectureCraft.content.itemCladding, new RendererCladding());
    }

    protected void registerDefaultRenderers() {
        for (Block block : ArchitectureCraft.content.registeredBlocks) {
            Item item = Item.func_150898_a((Block)block);
            if (block instanceof IBlockArchitecture) {
                String name;
                if (!this.blockRenderers.containsKey(block) && (name = ((IBlockArchitecture)block).getQualifiedRendererClassName()) != null) {
                    try {
                        Class<?> cls = Class.forName(name);
                        this.addBlockRenderer((IBlockArchitecture)block, (ICustomRenderer)cls.newInstance());
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                if (this.blockNeedsCustomRendering(block)) {
                    this.installCustomBlockRenderDispatcher((IBlockArchitecture)block);
                    this.installCustomItemRenderDispatcher(item);
                }
            }
            if (!this.itemNeedsCustomRendering(item)) continue;
            this.installCustomItemRenderDispatcher(item);
        }
        for (Item item : ArchitectureCraft.content.registeredItems) {
            if (!this.itemNeedsCustomRendering(item)) continue;
            this.installCustomItemRenderDispatcher(item);
        }
    }

    protected void installCustomBlockRenderDispatcher(IBlockArchitecture block) {
        block.setRenderType(this.getCustomBlockRenderType());
    }

    protected void installCustomItemRenderDispatcher(Item item) {
        if (item != null) {
            MinecraftForgeClient.registerItemRenderer((Item)item, (IItemRenderer)this.getItemRenderDispatcher());
        }
    }

    protected void removeUnusedDefaultTextureNames() {
        for (Block block : ArchitectureCraft.content.registeredBlocks) {
            if (!this.blockNeedsCustomRendering(block)) continue;
            block.func_149658_d("minecraft:stone");
        }
        for (Item item : ArchitectureCraft.content.registeredItems) {
            if (!this.itemNeedsCustomRendering(item)) continue;
            item.func_111206_d("minecraft:apple");
        }
    }

    public void addBlockRenderer(IBlockArchitecture block, ICustomRenderer renderer) {
        this.blockRenderers.put(block, renderer);
        Item item = Item.func_150898_a((Block)((Block)block));
        if (item != null && !this.itemRenderers.containsKey(item)) {
            this.addItemRenderer(item, renderer);
        }
    }

    public void addItemRenderer(Item item, ICustomRenderer renderer) {
        this.itemRenderers.put(item, renderer);
    }

    protected boolean blockNeedsCustomRendering(Block block) {
        return this.blockRenderers.containsKey(block) || this.specifiesTextures(block);
    }

    protected boolean itemNeedsCustomRendering(Item item) {
        return this.itemRenderers.containsKey(item) || this.specifiesTextures(item);
    }

    protected boolean specifiesTextures(Object obj) {
        return obj instanceof ITextureConsumer && ((ITextureConsumer)obj).getTextureNames() != null;
    }

    protected int getCustomBlockRenderType() {
        return this.getBlockRenderDispatcher().renderID;
    }

    protected BlockRenderDispatcher getBlockRenderDispatcher() {
        if (this.blockRenderDispatcher == null) {
            this.blockRenderDispatcher = new BlockRenderDispatcher(this);
        }
        return this.blockRenderDispatcher;
    }

    protected ItemRenderDispatcher getItemRenderDispatcher() {
        if (this.itemRenderDispatcher == null) {
            this.itemRenderDispatcher = new ItemRenderDispatcher(this);
        }
        return this.itemRenderDispatcher;
    }

    public ICustomRenderer getCustomBlockRenderer(IBlockAccess world, BlockPos pos, IBlockState state) {
        BlockArchitecture block = (BlockArchitecture)state.getBlock();
        ICustomRenderer rend = this.blockRenderers.get(block);
        if (rend == null && block instanceof IBlockArchitecture) {
            IBlockState astate = block.getActualState(state, world, pos);
            rend = this.getModelRendererForState(astate);
        }
        return rend;
    }

    protected ICustomRenderer getModelRendererForSpec(ModelSpec spec, int textureType) {
        IArchitectureModel model = this.getModel(spec.modelName);
        ITexture[] textures = new ITexture[spec.textureNames.length];
        for (int i = 0; i < textures.length; ++i) {
            textures[i] = this.getTexture(textureType, spec.textureNames[i]);
        }
        return new RendererBaseModel(model, spec.origin, textures);
    }

    protected ICustomRenderer getModelRendererForState(IBlockState astate) {
        ModelSpec spec;
        Block block;
        ICustomRenderer rend = this.stateRendererCache.get(astate);
        if (rend == null && (block = astate.getBlock()) instanceof IBlockArchitecture && (spec = ((IBlockArchitecture)block).getModelSpec(astate)) != null) {
            rend = this.getModelRendererForSpec(spec, 0);
            this.stateRendererCache.put(astate, rend);
        }
        return rend;
    }

    public ICustomRenderer getModelRendererForItemStack(ItemStack stack) {
        Block block;
        ModelSpec spec;
        Item item = stack.func_77973_b();
        if (item instanceof IHasModel && (spec = ((IHasModel)item).getModelSpec(stack)) != null) {
            return this.getModelRendererForSpec(spec, 1);
        }
        if (item instanceof ItemBlock && (block = ((ItemBlock)item).field_150939_a) instanceof BlockArchitecture) {
            IBlockState state = BlockCompatUtils.getBlockStateFromItemStack(stack);
            ModelSpec spec2 = ((IBlockArchitecture)block).getModelSpec(state);
            return this.getModelRendererForSpec(spec2, 0);
        }
        return null;
    }

    public void renderBlockUsingModelSpec(IBlockAccess world, BlockPos pos, IBlockState state, IRenderTarget target, EnumWorldBlockLayer layer, Trans3 t) {
        ICustomRenderer rend = this.getModelRendererForState(state);
        if (rend != null) {
            rend.renderBlock(world, pos, state, target, layer, t);
        }
    }

    public void renderItemStackUsingModelSpec(ItemStack stack, IRenderTarget target, Trans3 t) {
        ICustomRenderer rend = this.getModelRendererForItemStack(stack);
        if (rend != null) {
            rend.renderItemStack(stack, target, t);
        }
    }

    public IArchitectureModel getModel(String name) {
        return ArchitectureCraft.mod.getModel(name);
    }

    public ITexture getTexture(int type, String name) {
        ResourceLocation loc = ArchitectureCraft.resourceLocation(name);
        return (ITexture)this.textureCaches[type].get(loc);
    }

    @SubscribeEvent
    public void onTextureStitchEventPre(TextureStitchEvent.Pre e) {
        int type = e.map.func_130086_a();
        if (type >= 0 && type <= 1) {
            TextureCache cache = this.textureCaches[type];
            cache.clear();
            switch (type) {
                case 0: {
                    for (Block block : ArchitectureCraft.content.registeredBlocks) {
                        this.registerSprites(e.map, cache, block);
                    }
                    break;
                }
                case 1: {
                    for (Item item : ArchitectureCraft.content.registeredItems) {
                        this.registerSprites(e.map, cache, item);
                    }
                    break;
                }
            }
        }
    }

    protected void registerSprites(TextureMap reg, TextureCache cache, Object obj) {
        String[] names;
        if (obj instanceof ITextureConsumer && (names = ((ITextureConsumer)obj).getTextureNames()) != null) {
            for (String name : names) {
                ResourceLocation loc = ArchitectureCraft.resourceLocation(name);
                if (cache.get(loc) != null) continue;
                IIcon icon = reg.func_94245_a(loc.toString());
                TextureSprite texture = ArchitectureTexture.fromSprite(icon);
                cache.put(loc, texture);
            }
        }
    }

    public static class TextureCache
    extends HashMap<ResourceLocation, ITexture> {
    }
}

