/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

class BlockAiryVisitor
extends ClassVisitor {
    public BlockAiryVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if ("func_149670_a".equals(name) || "onEntityCollidedWithBlock".equals(name)) {
            TC4Transformer.log.debug("Transforming {}{}", new Object[]{name, desc});
            return new OnEntityCollidedWithBlockVisitor(this.api, mv);
        }
        return mv;
    }

    private static class OnEntityCollidedWithBlockVisitor
    extends MethodVisitor {
        private int state;

        public OnEntityCollidedWithBlockVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitIntInsn(int opcode, int operand) {
            super.visitIntInsn(opcode, operand);
            if ((opcode == 16 || opcode == 17) && operand == 10) {
                String mnemonic = opcode == 16 ? "BIPUSH" : "SIPUSH";
                TC4Transformer.log.trace("Found needle {} {}", new Object[]{mnemonic, operand});
                this.state = 1;
            }
        }

        public void visitJumpInsn(int opcode, Label label) {
            super.visitJumpInsn(opcode, label);
            if (this.state == 1 && opcode == 160) {
                this.state = 2;
                TC4Transformer.log.trace("Insert instanceof EntityLivingBase after IF_ICMPNE");
                this.mv.visitVarInsn(25, 5);
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "canEarthShockHurt", "(Lnet/minecraft/entity/Entity;)Z", false);
                this.mv.visitJumpInsn(153, label);
            }
        }

        public void visitEnd() {
            if (this.state != 2) {
                TC4Transformer.log.warn("Unexpected end of bytecode. Current state: {}", new Object[]{this.state});
            }
            super.visitEnd();
        }
    }
}

