/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity.tank;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.DoubledCoords;
import openblocks.client.renderer.tileentity.tank.RenderConnection;
import openblocks.client.renderer.tileentity.tank.TankRenderUtils;
import openblocks.common.tileentity.TileEntityTank;
import openmods.utils.Diagonal;

public class DiagonalConnection
extends RenderConnection {
    private final float phase;
    private final Map<Diagonal, FluidStack> fluids = Maps.newEnumMap(Diagonal.class);
    private final float[] height = new float[4];

    public DiagonalConnection(float phase, DoubledCoords coords) {
        super(coords);
        this.phase = phase;
    }

    public float getRenderHeight(Diagonal corner, float time) {
        float h = this.height[corner.ordinal()];
        if (h <= 0.0f) {
            return 0.0f;
        }
        return TankRenderUtils.clampLevel(TankRenderUtils.calculateWaveAmplitude(time, this.phase) + h);
    }

    public void updateFluid(Diagonal corner, FluidStack stack) {
        this.fluids.put(corner, TankRenderUtils.safeCopy(stack));
        this.recalculate();
    }

    public void clearFluid(Diagonal corner) {
        this.fluids.remove(corner);
        this.recalculate();
    }

    private static Group findGroup(List<Group> entries, FluidStack stack) {
        for (Group group : entries) {
            if (!group.match(stack)) continue;
            return group;
        }
        Group newGroup = new Group(stack);
        entries.add(newGroup);
        return newGroup;
    }

    private void recalculate() {
        this.forceZero();
        ArrayList groups = Lists.newArrayList();
        for (Diagonal diagonal : Diagonal.VALUES) {
            if (!this.fluids.containsKey(diagonal)) continue;
            FluidStack stack = this.fluids.get(diagonal);
            if (stack == null || stack.amount <= 0) {
                return;
            }
            Group e = DiagonalConnection.findGroup(groups, stack);
            e.addDiagonal(diagonal, stack);
        }
        for (Group group : groups) {
            group.update(this.height);
        }
    }

    private void forceZero() {
        this.height[3] = 0.0f;
        this.height[2] = 0.0f;
        this.height[1] = 0.0f;
        this.height[0] = 0.0f;
    }

    private static class Group {
        private final FluidStack fluid;
        private final Set<Diagonal> diagonals = EnumSet.noneOf(Diagonal.class);
        private float sum;

        public Group(FluidStack fluid) {
            this.fluid = fluid;
        }

        public boolean match(FluidStack stack) {
            return this.fluid.isFluidEqual(stack);
        }

        public void addDiagonal(Diagonal diagonal, FluidStack stack) {
            this.diagonals.add(diagonal);
            this.sum += (float)stack.amount;
        }

        public void update(float[] height) {
            float average = TankRenderUtils.clampLevel(this.sum / (float)this.diagonals.size() / (float)TileEntityTank.getTankCapacity());
            for (Diagonal d : this.diagonals) {
                height[d.ordinal()] = average;
            }
        }
    }
}

