/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transportation;

import mrtjp.projectred.transportation.IWorldBroadcaster;
import mrtjp.projectred.transportation.IWorldRouter;
import mrtjp.projectred.transportation.PathOrdering$;
import mrtjp.projectred.transportation.StartEndPath;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y<Q!\u0001\u0002\t\u0002%\tA\u0002U1uQ>\u0013H-\u001a:j]\u001eT!a\u0001\u0003\u0002\u001dQ\u0014\u0018M\\:q_J$\u0018\r^5p]*\u0011QAB\u0001\u000baJ|'.Z2ue\u0016$'\"A\u0004\u0002\u000b5\u0014HO\u001b9\u0004\u0001A\u0011!bC\u0007\u0002\u0005\u0019)AB\u0001E\u0001\u001b\ta\u0001+\u0019;i\u001fJ$WM]5oON\u00191B\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\tyQ#\u0003\u0002\u0017!\ta1+\u001a:jC2L'0\u00192mK\")\u0001d\u0003C\u00013\u00051A(\u001b8jiz\"\u0012!\u0003\u0005\b7-\u0011\r\u0011\"\u0001\u001d\u0003=aw.\u00193B]\u0012$\u0015n\u001d;b]\u000e,W#A\u000f\u0011\u0005)qb\u0001\u0002\u0007\u0003\u0001}\u00192A\b\u0011)!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0003mC:<'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012aa\u00142kK\u000e$\bcA\u00152i9\u0011!f\f\b\u0003W9j\u0011\u0001\f\u0006\u0003[!\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005A\u0002\u0012a\u00029bG.\fw-Z\u0005\u0003eM\u0012\u0001b\u0014:eKJLgn\u001a\u0006\u0003aA\u0001\"AC\u001b\n\u0005Y\u0012!\u0001D*uCJ$XI\u001c3QCRD\u0007\u0002\u0003\u001d\u001f\u0005\u0003\u0005\u000b\u0011B\u001d\u0002\u001d\u0011L7\u000f^1oG\u0016<V-[4iiB\u0011qBO\u0005\u0003wA\u0011a\u0001R8vE2,\u0007\"\u0002\r\u001f\t\u0003iDCA\u000f?\u0011\u0015AD\b1\u0001:\u0011\u0015\u0001e\u0004\"\u0011B\u0003\u001d\u0019w.\u001c9be\u0016$2AQ#H!\ty1)\u0003\u0002E!\t\u0019\u0011J\u001c;\t\u000b\u0019{\u0004\u0019\u0001\u001b\u0002\u000b\u0019L'o\u001d;\t\u000b!{\u0004\u0019\u0001\u001b\u0002\rM,7m\u001c8e\u0011\u0015Qe\u0004\"\u0003L\u0003M\u0019w.\u001c9be\u0016\u0014\u0015\u0010\u0015:j_JLG/[3t)\r\u0011E*\u0015\u0005\u0006\u001b&\u0003\rAT\u0001\fM&\u00148\u000f\u001e*pkR,'\u000f\u0005\u0002\u000b\u001f&\u0011\u0001K\u0001\u0002\r\u0013^{'\u000f\u001c3S_V$XM\u001d\u0005\u0006%&\u0003\rAT\u0001\rg\u0016\u001cwN\u001c3S_V$XM\u001d\u0005\u0006)z!I!V\u0001\u000baJLwN]5us>3GC\u0001\"W\u0011\u001596\u000b1\u0001O\u0003\u0019\u0011x.\u001e;fe\")\u0011L\bC\u00055\u0006y1m\\7qCJ,')_*d_J,7\u000fF\u0003C7rkf\fC\u0003G1\u0002\u0007A\u0007C\u0003I1\u0002\u0007A\u0007C\u0003N1\u0002\u0007a\nC\u0003S1\u0002\u0007a\nC\u0003a=\u0011%\u0011-\u0001\u0006x_J\\Gn\\1e\u001f\u001a$\"!\u000f2\t\u000b]{\u0006\u0019\u0001(\t\u000b\u0011tB\u0011B3\u0002\u001b\r|W\u000e]1sK\u0016sG-\u00139t)\r\u0011em\u001a\u0005\u0006\r\u000e\u0004\r\u0001\u000e\u0005\u0006\u0011\u000e\u0004\r\u0001\u000e\u0005\u0007S.\u0001\u000b\u0011B\u000f\u0002!1|\u0017\rZ!oI\u0012K7\u000f^1oG\u0016\u0004\u0003bB6\f\u0005\u0004%\t\u0001H\u0001\tY>\fGm\u00148ms\"1Qn\u0003Q\u0001\nu\t\u0011\u0002\\8bI>sG.\u001f\u0011\t\u000f=\\!\u0019!C\u0005a\u0006)Q)U+B\u0019V\t!\t\u0003\u0004s\u0017\u0001\u0006IAQ\u0001\u0007\u000bF+\u0016\t\u0014\u0011\t\u000fQ\\\u0011\u0011!C\u0005k\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\u0005\u0001\u0003")
public class PathOrdering
implements Ordering<StartEndPath> {
    private final double distanceWeight;

    public static PathOrdering loadOnly() {
        return PathOrdering$.MODULE$.loadOnly();
    }

    public static PathOrdering loadAndDistance() {
        return PathOrdering$.MODULE$.loadAndDistance();
    }

    public Some tryCompare(Object x, Object y) {
        return Ordering.class.tryCompare((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lteq(Object x, Object y) {
        return Ordering.class.lteq((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gteq(Object x, Object y) {
        return Ordering.class.gteq((Ordering)this, (Object)x, (Object)y);
    }

    public boolean lt(Object x, Object y) {
        return Ordering.class.lt((Ordering)this, (Object)x, (Object)y);
    }

    public boolean gt(Object x, Object y) {
        return Ordering.class.gt((Ordering)this, (Object)x, (Object)y);
    }

    public boolean equiv(Object x, Object y) {
        return Ordering.class.equiv((Ordering)this, (Object)x, (Object)y);
    }

    public Object max(Object x, Object y) {
        return Ordering.class.max((Ordering)this, (Object)x, (Object)y);
    }

    public Object min(Object x, Object y) {
        return Ordering.class.min((Ordering)this, (Object)x, (Object)y);
    }

    public Ordering<StartEndPath> reverse() {
        return Ordering.class.reverse((Ordering)this);
    }

    public <U> Ordering<U> on(Function1<U, StartEndPath> f) {
        return Ordering.class.on((Ordering)this, f);
    }

    public Ordering.Ops mkOrderingOps(Object lhs) {
        return Ordering.class.mkOrderingOps((Ordering)this, (Object)lhs);
    }

    public int compare(StartEndPath first, StartEndPath second) {
        IWorldRouter secondRouter;
        IWorldRouter firstRouter = first.end().getParent();
        int priorityComparison = this.compareByPriorities(firstRouter, secondRouter = second.end().getParent());
        if (priorityComparison != PathOrdering$.MODULE$.mrtjp$projectred$transportation$PathOrdering$$EQUAL()) {
            return priorityComparison;
        }
        int scoreComparison = this.compareByScores(first, second, firstRouter, secondRouter);
        return scoreComparison == PathOrdering$.MODULE$.mrtjp$projectred$transportation$PathOrdering$$EQUAL() ? this.compareEndIps(first, second) : scoreComparison;
    }

    private int compareByPriorities(IWorldRouter firstRouter, IWorldRouter secondRouter) {
        int firstPriority = this.priorityOf(firstRouter);
        int secondPriority = this.priorityOf(secondRouter);
        return Predef$.MODULE$.int2Integer(firstPriority).compareTo(Predef$.MODULE$.int2Integer(secondPriority));
    }

    private int priorityOf(IWorldRouter router) {
        int n;
        IWorldRouter iWorldRouter = router;
        if (iWorldRouter instanceof IWorldBroadcaster) {
            IWorldBroadcaster iWorldBroadcaster = (IWorldBroadcaster)iWorldRouter;
            n = iWorldBroadcaster.getBroadcastPriority();
        } else {
            n = Integer.MIN_VALUE;
        }
        return n;
    }

    private int compareByScores(StartEndPath first, StartEndPath second, IWorldRouter firstRouter, IWorldRouter secondRouter) {
        double firstWorkload = this.workloadOf(firstRouter);
        double secondWorkload = this.workloadOf(secondRouter);
        double firstScore = firstWorkload + (double)first.distance() * this.distanceWeight;
        double secondScore = secondWorkload + (double)second.distance() * this.distanceWeight;
        return Predef$.MODULE$.double2Double(secondScore).compareTo(Predef$.MODULE$.double2Double(firstScore));
    }

    private double workloadOf(IWorldRouter router) {
        double d;
        IWorldRouter iWorldRouter = router;
        if (iWorldRouter instanceof IWorldBroadcaster) {
            IWorldBroadcaster iWorldBroadcaster = (IWorldBroadcaster)iWorldRouter;
            d = iWorldBroadcaster.getWorkLoad();
        } else {
            d = 0.0;
        }
        return d;
    }

    private int compareEndIps(StartEndPath first, StartEndPath second) {
        return Predef$.MODULE$.int2Integer(first.end().getIPAddress()).compareTo(Predef$.MODULE$.int2Integer(second.end().getIPAddress()));
    }

    public PathOrdering(double distanceWeight) {
        this.distanceWeight = distanceWeight;
        PartialOrdering.class.$init$((PartialOrdering)this);
        Ordering.class.$init$((Ordering)this);
    }
}

