/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc.types.multi;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import openmods.calc.Environment;
import openmods.calc.FixedCallable;
import openmods.calc.Frame;
import openmods.calc.IExecutable;
import openmods.calc.SymbolCall;
import openmods.calc.Value;
import openmods.calc.parsing.ICompilerState;
import openmods.calc.parsing.IExprNode;
import openmods.calc.parsing.ISymbolCallStateTransition;
import openmods.calc.parsing.SameStateSymbolTransition;
import openmods.calc.parsing.SymbolCallNode;
import openmods.calc.types.multi.Code;
import openmods.calc.types.multi.MetaObjectUtils;
import openmods.calc.types.multi.TypeDomain;
import openmods.calc.types.multi.TypedValue;

public class IfExpressionFactory {
    private final TypeDomain domain;

    public IfExpressionFactory(TypeDomain domain) {
        this.domain = domain;
    }

    public ISymbolCallStateTransition<TypedValue> createStateTransition(ICompilerState<TypedValue> parentState) {
        return new IfStateTransition(parentState);
    }

    public void registerSymbol(Environment<TypedValue> env) {
        env.setGlobalSymbol("if", (TypedValue)((Object)new IfSymbol()));
    }

    private class IfSymbol
    extends FixedCallable<TypedValue> {
        public IfSymbol() {
            super(3, 1);
        }

        @Override
        public void call(Frame<TypedValue> frame) {
            TypedValue ifFalse = frame.stack().pop();
            ifFalse.checkType(Code.class, "third (false branch) 'if' parameter");
            TypedValue ifTrue = frame.stack().pop();
            ifTrue.checkType(Code.class, "second (true branch) 'if' parameter");
            TypedValue condition = frame.stack().pop();
            (MetaObjectUtils.boolValue(frame, condition) ? ifTrue : ifFalse).as(Code.class).execute(frame);
        }
    }

    private class IfStateTransition
    extends SameStateSymbolTransition<TypedValue> {
        public IfStateTransition(ICompilerState<TypedValue> parentState) {
            super(parentState);
        }

        @Override
        public IExprNode<TypedValue> createRootNode(List<IExprNode<TypedValue>> children) {
            return new IfNode(children);
        }
    }

    private class IfNode
    extends SymbolCallNode<TypedValue> {
        public IfNode(List<IExprNode<TypedValue>> args) {
            super("if", args);
        }

        @Override
        public void flatten(List<IExecutable<TypedValue>> output) {
            ImmutableList args = ImmutableList.copyOf(this.getChildren());
            Preconditions.checkState((args.size() == 3 ? 1 : 0) != 0, (String)"Expected 3 parameter for 'if', got %s", (Object[])new Object[]{args.size()});
            IExprNode condition = (IExprNode)args.get(0);
            IExprNode ifTrue = (IExprNode)args.get(1);
            IExprNode ifFalse = (IExprNode)args.get(2);
            condition.flatten(output);
            output.add(Value.create(Code.flattenAndWrap(IfExpressionFactory.this.domain, ifTrue)));
            output.add(Value.create(Code.flattenAndWrap(IfExpressionFactory.this.domain, ifFalse)));
            output.add(new SymbolCall("if", 3, 1));
        }
    }
}

