/*
 * Decompiled with CFR 0.152.
 */
package emt.init;

import emt.init.EMTItems;
import emt.init.EMTResearches;
import emt.util.EMTResearchItem;
import gregtech.api.enums.ItemList;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OrePrefixes;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTUtility;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.ThaumcraftApiHelper;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;

public class EMT_GTNH_Recipes_And_Researches
implements Runnable {
    private static LinkedHashMap<String, IArcaneRecipe> arcaneRecipeLinkedHashMap = new LinkedHashMap();

    private static AspectList getPrimals(int amount) {
        return new AspectList().add(Aspect.ORDER, amount).add(Aspect.ENTROPY, amount).add(Aspect.AIR, amount).add(Aspect.EARTH, amount).add(Aspect.WATER, amount).add(Aspect.FIRE, amount);
    }

    @Override
    public void run() {
        EMTResearches.addResearchTab();
        this.runArcaneRecipes();
        this.runResreaches();
    }

    private void runArcaneRecipes() {
        arcaneRecipeLinkedHashMap.put("DiamondChainsaw", (IArcaneRecipe)new ShapedArcaneRecipe("DiamondChainsaw", new ItemStack(EMTItems.diamondChainsaw), EMT_GTNH_Recipes_And_Researches.getPrimals(35), new Object[]{"sts", "pmp", "pbp", Character.valueOf('s'), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.Diamond, (long)1L), Character.valueOf('p'), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Diamond, (long)1L), Character.valueOf('t'), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.toolHeadChainsaw, (Object)Materials.Thaumium, (long)1L), Character.valueOf('b'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0]), Character.valueOf('m'), ItemList.Electric_Motor_MV.get(1L, new Object[0])}));
        arcaneRecipeLinkedHashMap.put("ThaumiumChainsaw", (IArcaneRecipe)new ShapedArcaneRecipe("ThaumiumChainsaw", new ItemStack(EMTItems.thaumiumChainsaw), EMT_GTNH_Recipes_And_Researches.getPrimals(35), new Object[]{"sps", "pmp", "ppp", Character.valueOf('s'), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.screw, (Object)Materials.Thaumium, (long)1L), Character.valueOf('p'), GTOreDictUnificator.get((OrePrefixes)OrePrefixes.plate, (Object)Materials.Thaumium, (long)1L), Character.valueOf('b'), ItemList.Battery_RE_LV_Sodium.get(1L, new Object[0]), Character.valueOf('m'), new ItemStack(EMTItems.diamondChainsaw)}));
        for (IArcaneRecipe recipe : arcaneRecipeLinkedHashMap.values()) {
            ThaumcraftApi.getCraftingRecipes().add(recipe);
        }
    }

    private void runResreaches() {
        HashSet<ResearchItem> researches = new HashSet<ResearchItem>();
        researches.add(new EMTResearchItem("ElectricMagicTools", 0, 0, 0, new ResourceLocation("emt", "textures/misc/emt.png")).setSpecial().setAutoUnlock().setPages(new ResearchPage[]{new ResearchPage("")}));
        researches.add(new EMTResearchItem("DiamondChainsaw", new AspectList().add(Aspect.GREED, 12).add(Aspect.FIRE, 9).add(Aspect.METAL, 6).add(Aspect.EARTH, 3), 0, -2, 2, new ItemStack(EMTItems.diamondChainsaw)).setPages(new ResearchPage(arcaneRecipeLinkedHashMap.get("DiamondChainsaw"))).setRound().setParentsHidden(new String[]{"ElectricMagicTools"}));
        researches.forEach(ResearchItem::registerResearchItem);
    }

    class ShapedArcaneRecipeIgnoresNBT
    extends ShapedArcaneRecipe {
        protected String research;
        protected ItemStack result;
        protected AspectList aspects;
        protected Object[] recipe;
        protected LinkedHashMap<Character, Object> translation;
        int[] rowcolm;

        public ShapedArcaneRecipeIgnoresNBT(String research, ItemStack result, AspectList aspects, Object ... recipe) {
            super(research, result, aspects, recipe);
            this.translation = new LinkedHashMap();
            this.research = research;
            this.result = result;
            this.aspects = aspects;
            this.recipe = recipe;
            int rows = 0;
            int colums = 0;
            if (!(recipe[0] instanceof String)) {
                throw new UnsupportedOperationException("The Recipe must start with at least one String for the first row!");
            }
            int i = 0;
            this.rowcolm = new int[3];
            do {
                this.rowcolm[i] = colums = Math.max(colums, ((String)recipe[i]).length());
            } while (recipe[i = ++rows] instanceof String);
            if (rows > 3 || colums > 3) {
                throw new UnsupportedOperationException("The Recipe must fit in a 3x3 crafting field!");
            }
            this.rowcolm = Arrays.copyOf(this.rowcolm, rows);
            for (int j = i; j < recipe.length; j += 2) {
                if (!(recipe[j] instanceof Character)) continue;
                this.translation.put((Character)recipe[j], recipe[j + 1]);
            }
        }

        public boolean matches(IInventory inv, World world, EntityPlayer player) {
            if (this.research.length() > 0 && !ThaumcraftApiHelper.isResearchComplete((String)player.func_70005_c_(), (String)this.research)) {
                return false;
            }
            for (int y = 0; y < this.rowcolm.length; ++y) {
                String rowAsString = (String)this.recipe[y];
                for (int x = 0; x < this.rowcolm[y]; ++x) {
                    Object itemReplacement = this.translation.get(Character.valueOf(rowAsString.toCharArray()[x]));
                    ItemStack slot = ThaumcraftApiHelper.getStackInRowAndColumn((Object)inv, (int)x, (int)y);
                    if (itemReplacement != null && slot == null) {
                        return false;
                    }
                    if (itemReplacement instanceof String) {
                        if (GTUtility.areStacksEqual((ItemStack)GTOreDictUnificator.getFirstOre((Object)itemReplacement, (long)1L), (ItemStack)GTOreDictUnificator.get((ItemStack)slot), (boolean)true) || OreDictionary.getOres((String)((String)itemReplacement)).contains(slot)) continue;
                        return false;
                    }
                    if (itemReplacement instanceof ItemStack) {
                        if (!GTUtility.isStackValid((ItemStack)((ItemStack)itemReplacement))) {
                            return false;
                        }
                        if (GTUtility.areStacksEqual((ItemStack)((ItemStack)itemReplacement), (ItemStack)slot, (boolean)true) || GTUtility.areUnificationsEqual((ItemStack)((ItemStack)itemReplacement), (ItemStack)slot, (boolean)true) || ((ItemStack)itemReplacement).func_77973_b().equals(slot.func_77973_b()) && ((ItemStack)itemReplacement).func_77960_j() == Short.MAX_VALUE) continue;
                        return false;
                    }
                    if (!(itemReplacement instanceof Collection)) continue;
                    boolean hit = false;
                    for (Object o : (Collection)itemReplacement) {
                        if (!GTUtility.areStacksEqual((ItemStack)((ItemStack)o), (ItemStack)slot, (boolean)true) && !GTUtility.areUnificationsEqual((ItemStack)((ItemStack)o), (ItemStack)slot, (boolean)true) && (!((ItemStack)o).func_77973_b().equals(slot.func_77973_b()) || ((ItemStack)itemReplacement).func_77960_j() != Short.MAX_VALUE)) continue;
                        hit = true;
                    }
                    if (hit) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack getCraftingResult(IInventory iInventory) {
            return this.result;
        }

        public int getRecipeSize() {
            return this.recipe.length;
        }

        public ItemStack getRecipeOutput() {
            return this.result;
        }

        public AspectList getAspects() {
            return this.aspects;
        }

        public AspectList getAspects(IInventory iInventory) {
            return this.aspects;
        }

        public String getResearch() {
            return this.research;
        }
    }
}

