/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.gui;

import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import crazypants.enderio.conduit.liquid.AbstractEnderLiquidConduit;
import crazypants.enderio.conduit.liquid.FluidFilter;
import crazypants.enderio.conduit.liquid.ILiquidConduit;
import crazypants.enderio.conduit.packet.AbstractConduitPacket;
import crazypants.enderio.conduit.packet.ConTypeEnum;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class PacketFluidFilter
extends AbstractConduitPacket<ILiquidConduit>
implements IMessageHandler<PacketFluidFilter, IMessage> {
    private ForgeDirection dir;
    private boolean isInput;
    private FluidFilter filter;

    public PacketFluidFilter() {
    }

    public PacketFluidFilter(AbstractEnderLiquidConduit eConduit, ForgeDirection dir, FluidFilter filter, boolean isInput) {
        super(eConduit.getBundle().getEntity(), ConTypeEnum.FLUID);
        this.dir = dir;
        this.filter = filter;
        this.isInput = isInput;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        buf.writeShort(this.dir.ordinal());
        buf.writeBoolean(this.isInput);
        NBTTagCompound tag = new NBTTagCompound();
        this.filter.writeToNBT(tag);
        ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)tag);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.dir = ForgeDirection.values()[buf.readShort()];
        this.isInput = buf.readBoolean();
        NBTTagCompound tag = ByteBufUtils.readTag((ByteBuf)buf);
        this.filter = new FluidFilter();
        this.filter.readFromNBT(tag);
    }

    public IMessage onMessage(PacketFluidFilter message, MessageContext ctx) {
        if (PacketFluidFilter.isInvalidPacketForGui(message, ctx)) {
            return null;
        }
        ILiquidConduit conduit = (ILiquidConduit)message.getTileCasted(ctx);
        if (!(conduit instanceof AbstractEnderLiquidConduit)) {
            return null;
        }
        AbstractEnderLiquidConduit eCon = (AbstractEnderLiquidConduit)conduit;
        eCon.setFilter(message.dir, message.filter, message.isInput);
        message.getWorld(ctx).func_147471_g(message.x, message.y, message.z);
        return null;
    }
}

