/*
 * Decompiled with CFR 0.152.
 */
package com.prupe.mcpatcher.cit;

import com.prupe.mcpatcher.MCLogger;
import com.prupe.mcpatcher.cit.ArmorOverride;
import com.prupe.mcpatcher.cit.Enchantment;
import com.prupe.mcpatcher.cit.EnchantmentList;
import com.prupe.mcpatcher.cit.ItemOverride;
import com.prupe.mcpatcher.cit.OverrideBase;
import com.prupe.mcpatcher.cit.PotionReplacer;
import com.prupe.mcpatcher.mal.item.ItemAPI;
import com.prupe.mcpatcher.mal.resource.PropertiesFile;
import com.prupe.mcpatcher.mal.resource.ResourceList;
import com.prupe.mcpatcher.mal.resource.TexturePackAPI;
import com.prupe.mcpatcher.mal.resource.TexturePackChangeHandler;
import com.prupe.mcpatcher.mal.tile.TileLoader;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import jss.notfine.config.MCPatcherForgeConfig;
import jss.notfine.util.NBTTagListExpansion;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;

public class CITUtils {
    private static final MCLogger logger = MCLogger.getLogger(MCLogger.Category.CUSTOM_ITEM_TEXTURES, "CIT");
    static final String CIT_PROPERTIES = "cit.properties";
    private static final ResourceLocation CIT_PROPERTIES1 = TexturePackAPI.newMCPatcherResourceLocation("cit.properties");
    private static final ResourceLocation CIT_PROPERTIES2 = TexturePackAPI.newMCPatcherResourceLocation("cit/cit.properties");
    static final ResourceLocation FIXED_ARMOR_RESOURCE = new ResourceLocation("textures/models/armor/iron_layer_1.png");
    static final int MAX_ENCHANTMENTS = 256;
    private static Item itemEnchantedBook;
    static Item itemCompass;
    static Item itemClock;
    static final boolean enableItems;
    static final boolean enableEnchantments;
    static final boolean enableArmor;
    private static TileLoader tileLoader;
    private static final Map<Item, List<ItemOverride>> items;
    private static final Map<Item, List<Enchantment>> enchantments;
    private static final List<Enchantment> allItemEnchantments;
    private static final Map<Item, List<ArmorOverride>> armors;
    static boolean useGlint;
    private static EnchantmentList armorMatches;
    private static int armorMatchIndex;
    private static ItemStack lastItemStack;
    private static int lastRenderPass;
    static IIcon lastOrigIcon;
    private static IIcon lastIcon;

    public static void init() {
        TexturePackChangeHandler.register(new TexturePackChangeHandler("Custom Item Textures", 3){

            @Override
            public void beforeChange() {
                itemEnchantedBook = ItemAPI.getFixedItem("minecraft:enchanted_book");
                itemCompass = ItemAPI.getFixedItem("minecraft:compass");
                itemClock = ItemAPI.getFixedItem("minecraft:clock");
                tileLoader = new TileLoader("textures/items", logger);
                items.clear();
                enchantments.clear();
                allItemEnchantments.clear();
                armors.clear();
                lastOrigIcon = null;
                lastIcon = null;
                BufferedImage image = TexturePackAPI.getImage(FIXED_ARMOR_RESOURCE);
                if (image == null) {
                    Enchantment.baseArmorWidth = 64.0f;
                    Enchantment.baseArmorHeight = 32.0f;
                } else {
                    Enchantment.baseArmorWidth = image.getWidth();
                    Enchantment.baseArmorHeight = image.getHeight();
                }
                PropertiesFile properties = PropertiesFile.get(logger, CIT_PROPERTIES1);
                if (properties == null) {
                    properties = PropertiesFile.getNonNull(logger, CIT_PROPERTIES2);
                }
                useGlint = properties.getBoolean("useGlint", true);
                EnchantmentList.setProperties(properties);
                if (enableItems || enableEnchantments || enableArmor) {
                    for (ResourceLocation resource : ResourceList.getInstance().listResources("mcpatcher/cit", ".properties", true)) {
                        this.registerOverride(OverrideBase.create(resource));
                    }
                    if (enableItems) {
                        PotionReplacer replacer = new PotionReplacer();
                        for (ItemOverride override : replacer.overrides) {
                            this.registerOverride(override);
                        }
                    }
                }
            }

            @Override
            public void afterChange() {
                for (List list : items.values()) {
                    for (ItemOverride override : list) {
                        override.registerIcon(tileLoader);
                    }
                    Collections.sort(list);
                }
                for (List list : enchantments.values()) {
                    list.addAll(allItemEnchantments);
                    Collections.sort(list);
                }
                Collections.sort(allItemEnchantments);
                for (List list : armors.values()) {
                    Collections.sort(list);
                }
            }

            private void registerOverride(OverrideBase override) {
                if (override != null && override.properties.valid()) {
                    Map map;
                    if (override instanceof ItemOverride) {
                        ((ItemOverride)override).preload(tileLoader);
                        map = items;
                    } else if (override instanceof Enchantment) {
                        map = enchantments;
                    } else if (override instanceof ArmorOverride) {
                        map = armors;
                    } else {
                        logger.severe("unknown ItemOverride type %d", override.getClass().getName());
                        return;
                    }
                    if (override.items == null) {
                        if (override instanceof Enchantment) {
                            logger.fine("registered %s to all items", override);
                            allItemEnchantments.add((Enchantment)override);
                        }
                    } else {
                        int i = 0;
                        for (Item item : override.items) {
                            this.registerOverride(map, item, override);
                            if (i < 10) {
                                logger.fine("registered %s to item %s", override, ItemAPI.getItemName(item));
                            } else if (i == 10) {
                                logger.fine("... %d total", override.items.size());
                            }
                            ++i;
                        }
                    }
                }
            }

            private void registerOverride(Map<Item, List<OverrideBase>> map, Item item, OverrideBase override) {
                List list = map.computeIfAbsent(item, k -> new ArrayList());
                list.add(override);
            }
        });
    }

    public static IIcon getIcon(IIcon icon, ItemStack itemStack, int renderPass) {
        IIcon newIcon;
        ItemOverride override;
        if (icon == lastIcon && itemStack == lastItemStack && renderPass == lastRenderPass) {
            return icon;
        }
        lastOrigIcon = lastIcon = icon;
        lastItemStack = itemStack;
        lastRenderPass = renderPass;
        if (enableItems && (override = CITUtils.findItemOverride(itemStack)) != null && (newIcon = override.getReplacementIcon(icon)) != null) {
            lastIcon = newIcon;
        }
        return lastIcon;
    }

    public static IIcon getEntityIcon(IIcon icon, Entity entity) {
        if (entity instanceof EntityPotion) {
            EntityPotion potion = (EntityPotion)entity;
            return CITUtils.getIcon(icon, potion.field_70197_d, 1);
        }
        return icon;
    }

    public static ResourceLocation getArmorTexture(ResourceLocation texture, EntityLivingBase entity, ItemStack itemStack) {
        ResourceLocation newTexture;
        ArmorOverride override;
        if (enableArmor && (override = CITUtils.findArmorOverride(itemStack)) != null && (newTexture = override.getReplacementTexture(texture)) != null) {
            return newTexture;
        }
        return texture;
    }

    private static <T extends OverrideBase> T findMatch(Map<Item, List<T>> overrides, ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        List<T> list = overrides.get(item);
        if (list != null) {
            int[] enchantmentLevels = CITUtils.getEnchantmentLevels(item, itemStack.func_77978_p());
            boolean hasEffect = itemStack.func_77962_s();
            for (OverrideBase override : list) {
                if (!override.match(itemStack, enchantmentLevels, hasEffect)) continue;
                return (T)override;
            }
        }
        return null;
    }

    static ItemOverride findItemOverride(ItemStack itemStack) {
        return (ItemOverride)CITUtils.findMatch(items, itemStack);
    }

    static ArmorOverride findArmorOverride(ItemStack itemStack) {
        return (ArmorOverride)CITUtils.findMatch(armors, itemStack);
    }

    static EnchantmentList findEnchantments(ItemStack itemStack) {
        return new EnchantmentList(enchantments, allItemEnchantments, itemStack);
    }

    public static boolean renderEnchantmentHeld(ItemStack itemStack, int renderPass) {
        int width;
        int height;
        if (itemStack == null || renderPass != 0) {
            return true;
        }
        if (!enableEnchantments) {
            return false;
        }
        EnchantmentList matches = CITUtils.findEnchantments(itemStack);
        if (matches.isEmpty()) {
            return !useGlint;
        }
        if (lastIcon == null) {
            height = 256;
            width = 256;
        } else {
            width = lastIcon.func_94211_a();
            height = lastIcon.func_94216_b();
        }
        Enchantment.beginOuter3D();
        for (int i = 0; i < matches.size(); ++i) {
            matches.getEnchantment(i).render3D(matches.getIntensity(i), width, height);
        }
        Enchantment.endOuter3D();
        return !useGlint;
    }

    public static boolean renderEnchantmentDropped(ItemStack itemStack) {
        return CITUtils.renderEnchantmentHeld(itemStack, lastRenderPass);
    }

    public static boolean renderEnchantmentGUI(ItemStack itemStack, int x, int y, float z) {
        if (!enableEnchantments || itemStack == null) {
            return false;
        }
        EnchantmentList matches = CITUtils.findEnchantments(itemStack);
        if (matches.isEmpty()) {
            return !useGlint;
        }
        Enchantment.beginOuter2D();
        for (int i = 0; i < matches.size(); ++i) {
            matches.getEnchantment(i).render2D(matches.getIntensity(i), x, y, x + 16, y + 16, z);
        }
        Enchantment.endOuter2D();
        return !useGlint;
    }

    public static boolean setupArmorEnchantments(EntityLivingBase entity, int pass) {
        return CITUtils.setupArmorEnchantments(entity.func_71124_b(4 - pass));
    }

    public static boolean setupArmorEnchantments(ItemStack itemStack) {
        EnchantmentList tmpList;
        armorMatches = null;
        armorMatchIndex = 0;
        if (enableEnchantments && itemStack != null && !(tmpList = CITUtils.findEnchantments(itemStack)).isEmpty()) {
            armorMatches = tmpList;
        }
        return CITUtils.isArmorEnchantmentActive() || !useGlint;
    }

    public static boolean preRenderArmorEnchantment() {
        if (CITUtils.isArmorEnchantmentActive()) {
            Enchantment enchantment = armorMatches.getEnchantment(armorMatchIndex);
            if (enchantment.bindTexture(lastOrigIcon)) {
                enchantment.beginArmor(armorMatches.getIntensity(armorMatchIndex));
                return true;
            }
            return false;
        }
        armorMatches = null;
        armorMatchIndex = 0;
        return false;
    }

    public static boolean isArmorEnchantmentActive() {
        return armorMatches != null && armorMatchIndex < armorMatches.size();
    }

    public static void postRenderArmorEnchantment() {
        armorMatches.getEnchantment(armorMatchIndex).endArmor();
        ++armorMatchIndex;
    }

    static int[] getEnchantmentLevels(Item item, NBTTagCompound nbt) {
        NBTBase base;
        int[] levels = null;
        if (nbt != null && (base = item == itemEnchantedBook ? nbt.func_74781_a("StoredEnchantments") : nbt.func_74781_a("ench")) instanceof NBTTagList) {
            NBTTagList list = (NBTTagList)base;
            for (int i = 0; i < list.func_74745_c(); ++i) {
                base = ((NBTTagListExpansion)list).tagAt(i);
                if (!(base instanceof NBTTagCompound)) continue;
                short id = ((NBTTagCompound)base).func_74765_d("id");
                short level = ((NBTTagCompound)base).func_74765_d("lvl");
                if (id < 0 || id >= 256 || level <= 0) continue;
                if (levels == null) {
                    levels = new int[256];
                }
                short s = id;
                levels[s] = levels[s] + level;
            }
        }
        return levels;
    }

    static {
        enableItems = MCPatcherForgeConfig.CustomItemTextures.items;
        enableEnchantments = MCPatcherForgeConfig.CustomItemTextures.enchantments;
        enableArmor = MCPatcherForgeConfig.CustomItemTextures.armor;
        items = new IdentityHashMap<Item, List<ItemOverride>>();
        enchantments = new IdentityHashMap<Item, List<Enchantment>>();
        allItemEnchantments = new ArrayList<Enchantment>();
        armors = new IdentityHashMap<Item, List<ArmorOverride>>();
    }
}

