/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization.transformercache.lite;

import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import cpw.mods.fml.repackage.com.nothome.delta.Delta;
import cpw.mods.fml.repackage.com.nothome.delta.DiffWriter;
import cpw.mods.fml.repackage.com.nothome.delta.GDiffWriter;
import cpw.mods.fml.repackage.com.nothome.delta.SeekableSource;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.IModEventListener;
import makamys.coretweaks.optimization.transformercache.lite.CachedTransformerWrapper;
import makamys.coretweaks.optimization.transformerproxy.ITransformerWrapper;
import makamys.coretweaks.optimization.transformerproxy.TransformerProxyManager;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.Kryo;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.unsafe.UnsafeInput;
import makamys.coretweaks.repackage.com.esotericsoftware.kryo.kryo5.unsafe.UnsafeOutput;
import makamys.coretweaks.util.FastByteBufferSeekableSource;
import makamys.coretweaks.util.InMemoryGDiffPatcher;
import makamys.coretweaks.util.Util;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;

public class TransformerCache
implements IModEventListener,
TransformerProxyManager.ITransformerWrapperProvider {
    public static TransformerCache instance = new TransformerCache();
    private List<CachedTransformerWrapper> myTransformers = new ArrayList<CachedTransformerWrapper>();
    private Map<String, TransformerData> transformerMap = new HashMap<String, TransformerData>();
    private CacheMeta meta = new CacheMeta();
    private static byte[] lastClassData;
    private static int lastClassDataLength;
    private static final byte MAGIC_0 = 0;
    private static final byte VERSION = 2;
    private static final File DAT_OLD;
    private static final File DAT;
    private static final File DAT_ERRORED;
    private static final File TRANSFORMERCACHE_PROFILER_CSV;
    private Kryo kryo;
    private static final Delta delta;
    private static final byte[] NULL_BYTE_ARRAY;
    private Set<String> transformersToCache = new HashSet<String>();
    private boolean inited = false;
    private static byte[] memoizedHashData;
    private static int memoizedHashValue;

    public void init(boolean late) {
        if (this.inited) {
            return;
        }
        this.transformersToCache = Sets.newHashSet((Object[])Config.transformersToCache.get());
        Launch.classLoader.addTransformerExclusion("makamys.coretweaks.optimization.transformercache.lite.TransformerCache");
        Launch.classLoader.addTransformerExclusion("makamys.coretweaks.util.InMemoryGDiffPatcher");
        Launch.classLoader.addTransformerExclusion("makamys.coretweaks.util.FastByteBufferSeekableSource");
        this.loadData();
        TransformerProxyManager.instance.addAdditionListener(this, !late);
    }

    @Override
    public ITransformerWrapper wrap(IClassTransformer transformer) {
        if (this.transformersToCache.contains(transformer.getClass().getCanonicalName())) {
            CachedTransformerWrapper proxy = new CachedTransformerWrapper(transformer);
            this.myTransformers.add(proxy);
            return new CachedTransformerWrapper(transformer);
        }
        return null;
    }

    private void loadData() {
        long t0 = System.nanoTime();
        this.kryo = new Kryo();
        this.kryo.register(CacheMeta.class);
        this.kryo.register(HashMap.class);
        this.kryo.register(TransformerData.class);
        this.kryo.register(TransformerData.CachedTransformation.class);
        this.kryo.register(byte[].class);
        if (DAT_OLD.exists() && !DAT.exists()) {
            CoreTweaks.LOGGER.info("Migrating class cache: " + DAT_OLD + " -> " + DAT);
            DAT_OLD.renameTo(DAT);
        }
        if (DAT.exists()) {
            try (UnsafeInput is = new UnsafeInput(new BufferedInputStream(new FileInputStream(DAT)));){
                byte magic0 = this.kryo.readObject(is, Byte.TYPE);
                byte version = this.kryo.readObject(is, Byte.TYPE);
                CacheMeta storedMeta = this.kryo.readObject(is, CacheMeta.class);
                if (magic0 != 0 || version != 2) {
                    CoreTweaks.LOGGER.warn("Transformer cache is either a different version or corrupted, discarding.");
                } else if (!storedMeta.equals(this.meta)) {
                    CoreTweaks.LOGGER.warn("Transformer cache settings have changed, discarding.");
                } else {
                    this.transformerMap = TransformerCache.returnVerifiedTransformerMap(this.kryo.readObject(is, HashMap.class));
                }
                Iterator<Map.Entry<String, TransformerData>> it = this.transformerMap.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, TransformerData> e = it.next();
                    if (Arrays.asList(Config.transformersToCache.get()).contains(e.getKey())) continue;
                    CoreTweaks.LOGGER.info("Dropping " + e.getKey() + " from cache because we don't care about it anymore.");
                    it.remove();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                CoreTweaks.LOGGER.error("There was an error reading the transformer cache. A new one will be created. The previous one has been saved as " + DAT_ERRORED.getName() + " for inspection.");
                DAT.renameTo(DAT_ERRORED);
                e.printStackTrace();
            }
            long t1 = System.nanoTime();
            CoreTweaks.LOGGER.debug("Loaded lite transformer cache with " + this.getSize() + " entries in " + (double)(t1 - t0) / 1.0E9 + "s");
        } else {
            long t1 = System.nanoTime();
            CoreTweaks.LOGGER.debug("Created new lite transformer cache in " + (double)(t1 - t0) / 1.0E9 + "s");
        }
    }

    private int getSize() {
        return this.transformerMap.values().stream().mapToInt(d -> d.transformationMap.size()).sum();
    }

    private static Map<String, TransformerData> returnVerifiedTransformerMap(Map<String, TransformerData> map) {
        if (map.containsKey(null)) {
            throw new RuntimeException("Map contains null key");
        }
        if (map.containsValue(null)) {
            throw new RuntimeException("Map contains null value");
        }
        return map;
    }

    @Override
    public void onShutdown() {
        try {
            if (TransformerData.CachedTransformation.diffErrors > 0) {
                CoreTweaks.logger().warn(TransformerData.CachedTransformation.diffErrors + " entries have errored. Please report this if it keeps happening!");
            }
            this.saveTransformerCache();
            this.saveProfilingResults();
        }
        catch (IOException e) {
            CoreTweaks.logger().error("Error in lite transformer cache shutdown hook", (Throwable)e);
        }
    }

    private void saveTransformerCache() throws IOException {
        if (!DAT.exists()) {
            DAT.getParentFile().mkdirs();
            DAT.createNewFile();
        }
        CoreTweaks.logger().info("Saving transformer cache");
        this.trimCache((long)Config.liteTransformerCacheMaxSizeMB * 1024L * 1024L);
        try (UnsafeOutput output = new UnsafeOutput(new BufferedOutputStream(new FileOutputStream(DAT)));){
            this.kryo.writeObject(output, (byte)0);
            this.kryo.writeObject(output, (byte)2);
            this.kryo.writeObject(output, this.meta);
            this.kryo.writeObject(output, this.transformerMap);
        }
    }

    private void trimCache(long maxSize) {
        if (maxSize == -1L) {
            return;
        }
        ArrayList<TransformerData.CachedTransformation> data = new ArrayList<TransformerData.CachedTransformation>();
        for (TransformerData transData : this.transformerMap.values()) {
            data.addAll(transData.transformationMap.values());
        }
        data.sort(this::sortByAge);
        long usedSpace = 0L;
        int cutoff = -1;
        for (int i = data.size() - 1; i >= 0; --i) {
            if ((usedSpace += (long)((TransformerData.CachedTransformation)data.get(i)).getEstimatedSize()) <= maxSize) continue;
            cutoff = ((TransformerData.CachedTransformation)data.get((int)i)).lastAccessed;
            break;
        }
        if (cutoff != -1) {
            int cutoffCopy = cutoff;
            for (TransformerData transData : this.transformerMap.values()) {
                transData.transformationMap.entrySet().removeIf(e -> ((TransformerData.CachedTransformation)e.getValue()).lastAccessed <= cutoffCopy);
            }
            this.transformerMap.entrySet().removeIf(e -> ((TransformerData)e.getValue()).transformationMap.isEmpty());
        }
    }

    private int sortByAge(TransformerData.CachedTransformation a, TransformerData.CachedTransformation b) {
        return a.lastAccessed < b.lastAccessed ? -1 : (a.lastAccessed > b.lastAccessed ? 1 : 0);
    }

    private void saveProfilingResults() throws IOException {
        try (FileWriter fw = new FileWriter(TRANSFORMERCACHE_PROFILER_CSV);){
            fw.write("class,name,runs,misses\n");
            for (CachedTransformerWrapper transformer : this.myTransformers) {
                String className = transformer.getClass().getCanonicalName();
                String name = transformer.toString();
                int runs = 0;
                int misses = 0;
                if (transformer instanceof CachedTransformerWrapper) {
                    CachedTransformerWrapper proxy = transformer;
                    runs = proxy.runs;
                    misses = proxy.misses;
                }
                fw.write(className + "," + name + "," + runs + "," + misses + "\n");
            }
        }
    }

    public byte[] getCached(String transName, String name, String transformedName, byte[] basicClass) {
        TransformerData.CachedTransformation trans;
        TransformerData transData = this.transformerMap.get(transName);
        if (transData != null && (trans = transData.transformationMap.get(transformedName)) != null && TransformerCache.nullSafeLength(basicClass) == trans.preLength && TransformerCache.calculateHash(basicClass) == trans.preHash) {
            trans.lastAccessed = TransformerCache.now();
            return trans.postHash == trans.preHash ? TransformerCache.toNullableByteArray(basicClass) : trans.getNewClass(basicClass);
        }
        return null;
    }

    public static byte[] toNullableByteArray(byte[] array) {
        return array == null ? NULL_BYTE_ARRAY : array;
    }

    public static byte[] fromNullableByteArray(byte[] array) {
        return array == NULL_BYTE_ARRAY ? null : array;
    }

    private static int nullSafeLength(byte[] array) {
        return array == null ? -1 : array.length;
    }

    public void prePutCached(String transName, String name, String transformedName, byte[] basicClass) {
        this.putLastClassData(basicClass);
    }

    private void putLastClassData(byte[] data) {
        if (data != null) {
            if (lastClassData == null || lastClassData.length < data.length) {
                int newSize;
                for (newSize = 1; newSize < data.length; newSize *= 2) {
                }
                lastClassData = new byte[newSize];
            }
            System.arraycopy(data, 0, lastClassData, 0, data.length);
            lastClassDataLength = data.length;
        } else {
            lastClassData = null;
            lastClassDataLength = 0;
        }
    }

    public void putCached(String transName, String name, String transformedName, byte[] result) {
        TransformerData.CachedTransformation cached;
        TransformerData data = this.transformerMap.get(transName);
        if (data == null) {
            data = new TransformerData(transName);
            this.transformerMap.put(transName, data);
        }
        if ((cached = new TransformerData.CachedTransformation(transformedName, lastClassData, lastClassDataLength, result)).isValid()) {
            data.transformationMap.put(transformedName, cached);
        }
    }

    public static int calculateHash(byte[] data) {
        return TransformerCache.calculateHash(data, TransformerCache.nullSafeLength(data));
    }

    public static int calculateHash(byte[] data, int len) {
        if (data == memoizedHashData) {
            return memoizedHashValue;
        }
        memoizedHashData = data;
        memoizedHashValue = data == null ? -1 : Hashing.adler32().hashBytes(data, 0, len).asInt();
        return memoizedHashValue;
    }

    private static int now() {
        return (int)(System.currentTimeMillis() / 1000L / 60L);
    }

    static {
        DAT_OLD = Util.childFile(CoreTweaks.CACHE_DIR, "transformerCache.dat");
        DAT = Util.childFile(CoreTweaks.CACHE_DIR, "classTransformerLite.cache");
        DAT_ERRORED = Util.childFile(CoreTweaks.CACHE_DIR, "classTransformerLite.cache.errored");
        TRANSFORMERCACHE_PROFILER_CSV = Util.childFile(CoreTweaks.OUT_DIR, "transformercache_profiler.csv");
        delta = new Delta();
        NULL_BYTE_ARRAY = new byte[0];
    }

    public static class TransformerData {
        String transformerClassName;
        Map<String, CachedTransformation> transformationMap = new HashMap<String, CachedTransformation>();

        public TransformerData(String transformerClassName) {
            this.transformerClassName = transformerClassName;
        }

        public TransformerData() {
        }

        public static class CachedTransformation {
            private static final byte[] INVALID_RESULT = new byte[0];
            static int diffErrors = 0;
            String targetClassName;
            int preLength;
            int preHash;
            int postLength;
            int postHash;
            byte[] diff;
            int lastAccessed;

            public CachedTransformation() {
            }

            public boolean isValid() {
                return this.diff != INVALID_RESULT;
            }

            public CachedTransformation(String targetClassName, byte[] source, int sourceLen, byte[] target) {
                this.targetClassName = targetClassName;
                this.preHash = TransformerCache.calculateHash(source, sourceLen);
                this.preLength = sourceLen;
                this.postLength = TransformerCache.nullSafeLength(target);
                this.postHash = TransformerCache.calculateHash(target);
                if (this.preHash != this.postHash) {
                    this.diff = CachedTransformation.generateDiff(source, sourceLen, target, targetClassName);
                }
                this.lastAccessed = TransformerCache.now();
            }

            private static byte[] generateDiff(byte[] source, int sourceLen, byte[] target, String name) {
                if (source == null || !((TransformerCache)TransformerCache.instance).meta.enableDiffs) {
                    return target;
                }
                try {
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    delta.compute((SeekableSource)new FastByteBufferSeekableSource(ByteBuffer.wrap(source, 0, sourceLen)), (InputStream)new ByteArrayInputStream(target), (DiffWriter)new GDiffWriter((OutputStream)os));
                    return os.toByteArray();
                }
                catch (ClosedByInterruptException e) {
                    CoreTweaks.LOGGER.debug("Failed to generate diff for class " + name + ", thread was interrupted.");
                }
                catch (Exception e) {
                    CoreTweaks.LOGGER.error("Failed to generate diff for class " + name + ". Please report this if it keeps happening!");
                    e.printStackTrace();
                }
                ++diffErrors;
                return INVALID_RESULT;
            }

            public byte[] getNewClass(byte[] source) {
                if (source == null || !((TransformerCache)TransformerCache.instance).meta.enableDiffs) {
                    return this.diff;
                }
                byte[] newClass = new byte[this.postLength];
                InMemoryGDiffPatcher.patch(source, this.diff, newClass);
                return newClass;
            }

            public int getEstimatedSize() {
                return this.targetClassName.length() + 4 + 4 + 4 + (this.diff != null ? this.diff.length : 0) + 4;
            }
        }
    }

    public static class CacheMeta {
        boolean enableDiffs = Config.useDiffsInTransformerCache;

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheMeta)) {
                return false;
            }
            CacheMeta other = (CacheMeta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.enableDiffs == other.enableDiffs;
        }

        protected boolean canEqual(Object other) {
            return other instanceof CacheMeta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.enableDiffs ? 79 : 97);
            return result;
        }
    }
}

