/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api.screen;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.gtnewhorizons.modularui.ModularUI;
import com.gtnewhorizons.modularui.api.math.Pos2d;
import com.gtnewhorizons.modularui.api.math.Size;
import com.gtnewhorizons.modularui.api.screen.Cursor;
import com.gtnewhorizons.modularui.api.screen.IWindowCreator;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.api.widget.ISyncedWidget;
import com.gtnewhorizons.modularui.common.internal.network.CWidgetUpdate;
import com.gtnewhorizons.modularui.common.internal.network.NetworkHandler;
import com.gtnewhorizons.modularui.common.internal.network.NetworkUtils;
import com.gtnewhorizons.modularui.common.internal.network.SWidgetUpdate;
import com.gtnewhorizons.modularui.common.internal.wrapper.BaseSlot;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularGui;
import com.gtnewhorizons.modularui.common.internal.wrapper.ModularUIContainer;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.PacketBuffer;

public class ModularUIContext {
    private final ImmutableMap<Integer, IWindowCreator> syncedWindowsCreators;
    private final Deque<ModularWindow> windows = new LinkedList<ModularWindow>();
    private final BiMap<Integer, ModularWindow> syncedWindows = HashBiMap.create((int)4);
    private final Map<ModularWindow, Pos2d> lastWindowPos = new HashMap<ModularWindow, Pos2d>();
    private final Map<Integer, Pos2d> lastSyncedWindowPos = new HashMap<Integer, Pos2d>();
    private ModularWindow mainWindow;
    @SideOnly(value=Side.CLIENT)
    private ModularGui screen;
    private final EntityPlayer player;
    private final Cursor cursor;
    private final List<Integer> queuedOpenWindow = new ArrayList<Integer>();
    public final boolean clientOnly;
    private boolean isClosing = false;
    private final List<Runnable> closeListeners;
    private final Runnable onWidgetUpdate;
    private final Supplier<Boolean> validator;
    private final boolean showNEI;
    private Size screenSize;
    private ModularUIContainer container;

    public ModularUIContext(UIBuildContext context, Runnable onWidgetUpdate) {
        this(context, onWidgetUpdate, false);
    }

    public ModularUIContext(UIBuildContext context, Runnable onWidgetUpdate, boolean clientOnly) {
        this.screenSize = NetworkUtils.isDedicatedClient() ? new Size(Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d) : Size.ZERO;
        this.player = context.player;
        if (!this.isClient() && clientOnly) {
            throw new IllegalArgumentException("Client only ModularUI can not be opened on server!");
        }
        this.clientOnly = clientOnly;
        this.syncedWindowsCreators = context.syncedWindows.build();
        this.cursor = new Cursor(this);
        this.closeListeners = context.closeListeners;
        this.onWidgetUpdate = onWidgetUpdate;
        this.validator = context.validator;
        this.showNEI = context.showNEI;
    }

    public void forEachWindowBottomToTop(Consumer<ModularWindow> forEach) {
        for (ModularWindow window : Lists.newArrayList(this.getOpenWindowsReversed())) {
            forEach.accept(window);
        }
    }

    public void forEachWindowTopToBottom(Consumer<ModularWindow> forEach) {
        for (ModularWindow window : Lists.newArrayList(this.getOpenWindows())) {
            forEach.accept(window);
        }
    }

    public boolean isClient() {
        return NetworkUtils.isClient();
    }

    public void initialize(ModularUIContainer container, ModularWindow mainWindow) {
        this.container = container;
        this.mainWindow = mainWindow;
        this.pushWindow(mainWindow);
        this.syncedWindows.put((Object)0, (Object)mainWindow);
        mainWindow.draggable = false;
        if (this.isClient()) {
            mainWindow.initialized = true;
            mainWindow.clientOnly = false;
            this.sendClientPacket(2, null, mainWindow, NetworkUtils.EMPTY_PACKET);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void initializeClient(ModularGui screen) {
        this.screen = screen;
    }

    @SideOnly(value=Side.CLIENT)
    public void buildWindowOnStart() {
        for (ModularWindow window : this.windows) {
            window.rebuild();
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void resize(Size scaledSize) {
        this.screenSize = scaledSize;
        for (ModularWindow window : this.windows) {
            window.onResize(scaledSize);
            if (window != this.mainWindow) continue;
            this.getScreen().setMainWindowArea(window.getPos(), window.getSize());
        }
    }

    public void onClientTick() {
        if (!this.queuedOpenWindow.isEmpty()) {
            this.queuedOpenWindow.removeIf(windowId -> {
                ModularWindow oldWindow = (ModularWindow)this.syncedWindows.get(windowId);
                if (oldWindow != null && oldWindow.isClosing()) {
                    return false;
                }
                ModularWindow newWindow = this.openWindow((IWindowCreator)this.syncedWindowsCreators.get(windowId));
                this.syncedWindows.put(windowId, (Object)newWindow);
                newWindow.onResize(this.screenSize);
                newWindow.rebuild();
                newWindow.onOpen();
                newWindow.initialized = true;
                newWindow.clientOnly = false;
                this.sendClientPacket(4, null, newWindow, NetworkUtils.EMPTY_PACKET);
                return true;
            });
        }
    }

    public boolean isWindowOpen(int id) {
        return this.syncedWindows.containsKey((Object)id);
    }

    public void openSyncedWindow(int id) {
        if (this.isClient()) {
            ModularUI.logger.error("Synced windows must be opened on server!");
            return;
        }
        if (this.isWindowOpen(id)) {
            return;
        }
        if (this.syncedWindowsCreators.containsKey((Object)id)) {
            this.sendServerPacket(3, null, this.mainWindow, buf -> buf.func_150787_b(id));
            ModularWindow window = this.openWindow((IWindowCreator)this.syncedWindowsCreators.get((Object)id));
            this.syncedWindows.put((Object)id, (Object)window);
        } else {
            ModularUI.logger.error("Could not find window with id {}", new Object[]{id});
        }
    }

    public void openClientWindow(IWindowCreator windowCreator) {
        ModularWindow newWindow = this.openWindow(windowCreator);
        newWindow.onResize(this.screenSize);
        newWindow.rebuild();
        newWindow.onOpen();
        newWindow.initialized = true;
    }

    public ModularWindow openWindow(IWindowCreator windowCreator) {
        ModularWindow window = windowCreator.create(this.player);
        this.pushWindow(window);
        return window;
    }

    public void closeWindow(int id) {
        if (this.syncedWindows.containsKey((Object)id)) {
            this.closeWindow((ModularWindow)this.syncedWindows.get((Object)id));
        } else {
            ModularUI.logger.error("Could not close window with id {}", new Object[]{id});
        }
    }

    public void closeWindow(ModularWindow window) {
        if (window == null) {
            return;
        }
        if (this.windows.removeLastOccurrence(window)) {
            window.destroyWindow();
        }
        if (this.isClient()) {
            if (!this.hasWindows() || window == this.mainWindow) {
                this.close();
            }
        } else {
            this.sendServerPacket(5, null, window, NetworkUtils.EMPTY_PACKET);
        }
        if (this.syncedWindows.containsValue((Object)window)) {
            this.syncedWindows.inverse().remove((Object)window);
        }
    }

    private void pushWindow(ModularWindow window) {
        if (this.windows.offerLast(window)) {
            window.initialize(this);
        } else {
            ModularUI.logger.error("Failed opening window");
        }
    }

    public ModularWindow getCurrentWindow() {
        return this.windows.isEmpty() ? this.mainWindow : this.windows.peekLast();
    }

    public ModularWindow getMainWindow() {
        return this.mainWindow;
    }

    public void tryClose() {
        if (this.isClosing) {
            this.forEachWindowTopToBottom(this::closeWindow);
            return;
        }
        this.forEachWindowTopToBottom(window -> {
            if (window.tryClose() && window == this.mainWindow) {
                this.isClosing = true;
            }
        });
    }

    public void close() {
        this.player.func_71053_j();
    }

    public void closeAllButMain() {
        this.forEachWindowTopToBottom(window -> {
            if (window != this.mainWindow) {
                window.tryClose();
            }
        });
    }

    public void storeWindowPos(ModularWindow window, Pos2d pos) {
        if (this.windows.contains(window)) {
            Integer id = (Integer)this.syncedWindows.inverse().get((Object)window);
            if (id != null) {
                this.lastSyncedWindowPos.put(id, pos);
            } else {
                this.lastWindowPos.put(window, pos);
            }
        }
    }

    public boolean tryApplyStoredPos(ModularWindow window) {
        if (window == this.mainWindow || !this.windows.contains(window)) {
            return false;
        }
        if (this.lastWindowPos.containsKey(window)) {
            window.setPos(this.lastWindowPos.get(window));
            return true;
        }
        Integer id = (Integer)this.syncedWindows.inverse().get((Object)window);
        if (id != null && this.lastSyncedWindowPos.containsKey(id)) {
            window.setPos(this.lastSyncedWindowPos.get(id));
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public Pos2d getMousePos() {
        return this.screen.getMousePos();
    }

    public boolean hasWindows() {
        return !this.windows.isEmpty();
    }

    public EntityPlayer getPlayer() {
        return this.player;
    }

    public ModularUIContainer getContainer() {
        return this.container;
    }

    public ModularGui getScreen() {
        return this.screen;
    }

    public boolean isClientOnly() {
        return this.clientOnly;
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public Iterable<ModularWindow> getOpenWindows() {
        return this.windows::descendingIterator;
    }

    public Iterable<ModularWindow> getOpenWindowsReversed() {
        return this.windows;
    }

    @SideOnly(value=Side.CLIENT)
    public Size getScaledScreenSize() {
        return this.screenSize;
    }

    public void onWidgetUpdate() {
        if (this.onWidgetUpdate != null) {
            this.onWidgetUpdate.run();
        }
    }

    public Supplier<Boolean> getValidator() {
        return this.validator;
    }

    public boolean doShowNEI() {
        return this.showNEI;
    }

    public List<Runnable> getCloseListeners() {
        return this.closeListeners;
    }

    public void addCloseListener(Runnable runnable) {
        this.closeListeners.add(runnable);
    }

    public void syncSlotContent(BaseSlot slot) {
        if (slot != this.getContainer().field_75151_b.get(slot.field_75222_d)) {
            throw new IllegalStateException("Slot does not have the same index in the container!");
        }
        this.getContainer().sendSlotChange(slot.func_75211_c(), slot.field_75222_d);
    }

    public void readClientPacket(PacketBuffer buf, int widgetId) throws IOException {
        int id = buf.func_150792_a();
        ModularWindow window = (ModularWindow)this.syncedWindows.get((Object)buf.func_150792_a());
        if (widgetId == -1) {
            if (id == 2) {
                this.mainWindow.initialized = true;
                this.mainWindow.clientOnly = false;
            } else if (id == 4) {
                window.initialized = true;
            } else if (id == 5) {
                if (this.windows.removeLastOccurrence(window)) {
                    window.destroyWindow();
                }
                this.syncedWindows.inverse().remove((Object)window);
            }
        } else if (window != null) {
            ISyncedWidget syncedWidget = window.getSyncedWidget(widgetId);
            syncedWidget.readOnServer(id, buf);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void readServerPacket(PacketBuffer buf, int widgetId) throws IOException {
        int id = buf.func_150792_a();
        ModularWindow window = (ModularWindow)this.syncedWindows.get((Object)buf.func_150792_a());
        if (widgetId == -1) {
            if (id == 1) {
                this.player.field_71071_by.func_70437_b(NetworkUtils.readItemStack(buf));
            } else if (id == 3) {
                this.queuedOpenWindow.add(buf.func_150792_a());
            } else if (id == 5) {
                window.tryClose();
            }
        } else if (window != null) {
            ISyncedWidget syncedWidget = window.getSyncedWidget(widgetId);
            syncedWidget.readOnClient(id, buf);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendClientPacket(int discriminator, ISyncedWidget syncedWidget, ModularWindow window, Consumer<PacketBuffer> bufferConsumer) {
        if (this.isClient() && !this.isClientOnly()) {
            if (!this.syncedWindows.containsValue((Object)window)) {
                ModularUI.logger.error("Window is not synced!");
                ModularUI.logger.warn("stacktrace: " + Arrays.toString(Thread.currentThread().getStackTrace()));
                return;
            }
            int syncId = syncedWidget == null ? -1 : window.getSyncedWidgetId(syncedWidget);
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            buffer.func_150787_b(discriminator);
            buffer.func_150787_b(((Integer)this.syncedWindows.inverse().get((Object)window)).intValue());
            bufferConsumer.accept(buffer);
            CWidgetUpdate packet = new CWidgetUpdate(buffer, syncId);
            NetworkHandler.sendToServer(packet);
        }
    }

    public void sendServerPacket(int discriminator, ISyncedWidget syncedWidget, ModularWindow window, Consumer<PacketBuffer> bufferConsumer) {
        if (!this.isClient()) {
            if (!this.syncedWindows.containsValue((Object)window)) {
                ModularUI.logger.error("Window is not synced!");
                ModularUI.logger.warn("stacktrace: " + Arrays.toString(Thread.currentThread().getStackTrace()));
                return;
            }
            int syncId = syncedWidget == null ? -1 : window.getSyncedWidgetId(syncedWidget);
            PacketBuffer buffer = new PacketBuffer(Unpooled.buffer());
            buffer.func_150787_b(discriminator);
            buffer.func_150787_b(((Integer)this.syncedWindows.inverse().get((Object)window)).intValue());
            bufferConsumer.accept(buffer);
            SWidgetUpdate packet = new SWidgetUpdate(buffer, syncId);
            NetworkHandler.sendToPlayer(packet, (EntityPlayerMP)this.player);
        }
    }

    public static class DataCodes {
        public static final int INTERNAL_SYNC = -1;
        public static final int SYNC_CURSOR_STACK = 1;
        public static final int SYNC_INIT = 2;
        public static final int OPEN_WINDOW = 3;
        public static final int INIT_WINDOW = 4;
        public static final int CLOSE_WINDOW = 5;
    }
}

