/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.helper;

import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraftforge.common.util.ForgeDirection;

public class CoordHelper {
    public static int blockToChunk(int blockCoord) {
        return blockCoord >> 4;
    }

    public static int chunkToMinBlock(int chunkCoord) {
        return chunkCoord << 4;
    }

    public static int chunkToMaxBlock(int chunkCoord) {
        return (chunkCoord + 1 << 4) - 1;
    }

    public static StructureBoundingBox getChunkBB(int chunkX, int chunkZ) {
        return new StructureBoundingBox(CoordHelper.chunkToMinBlock(chunkX), CoordHelper.chunkToMinBlock(chunkZ), CoordHelper.chunkToMaxBlock(chunkX), CoordHelper.chunkToMaxBlock(chunkZ));
    }

    public static int abs2rel(int absCoord, int chunkCoord) {
        return absCoord - CoordHelper.chunkToMinBlock(chunkCoord);
    }

    public static int abs2rel(int absCoord) {
        int chunkCoord = CoordHelper.blockToChunk(absCoord);
        return absCoord - CoordHelper.chunkToMinBlock(chunkCoord);
    }

    public static int rel2abs(int relCoord, int chunkCoord) {
        return relCoord + CoordHelper.chunkToMinBlock(chunkCoord);
    }

    public static int getIndex(int x, int y, int z) {
        return (x * 16 + z) * 256 + y;
    }

    public static AxisAlignedBB cloneAABB(AxisAlignedBB box) {
        return AxisAlignedBB.func_72330_a((double)box.field_72340_a, (double)box.field_72338_b, (double)box.field_72339_c, (double)box.field_72336_d, (double)box.field_72337_e, (double)box.field_72334_f);
    }

    public static ForgeDirection rotateForgeDirection(ForgeDirection dir, int rotationMetadata) {
        int dirOrdinal = dir.ordinal();
        if (dirOrdinal < 2 || dirOrdinal > 5) {
            return dir;
        }
        dirOrdinal = CoordHelper.rotateForgeDirectionOrdinal(dirOrdinal, rotationMetadata);
        return ForgeDirection.getOrientation((int)dirOrdinal);
    }

    private static int rotateForgeDirectionOrdinal(int dirOrdinal, int rotationMeta) {
        switch (rotationMeta) {
            case 0: {
                return dirOrdinal;
            }
            case 1: {
                switch (dirOrdinal) {
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 4;
                    }
                }
                return -1;
            }
            case 2: {
                switch (dirOrdinal) {
                    case 2: {
                        return 4;
                    }
                    case 3: {
                        return 5;
                    }
                    case 4: {
                        return 3;
                    }
                    case 5: {
                        return 2;
                    }
                }
                return -1;
            }
            case 3: {
                switch (dirOrdinal) {
                    case 2: {
                        return 5;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 2;
                    }
                    case 5: {
                        return 3;
                    }
                }
                return -1;
            }
        }
        return dirOrdinal;
    }
}

