/*
 * Decompiled with CFR 0.152.
 */
package de.katzenpapst.amunra.item;

import buildcraft.api.tools.IToolWrench;
import cofh.api.block.IDismantleable;
import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.api.tool.ITool;
import de.katzenpapst.amunra.AmunRa;
import de.katzenpapst.amunra.helper.InteroperabilityHelper;
import de.katzenpapst.amunra.item.ItemAbstractBatteryUser;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.player.UseHoeEvent;

@Optional.InterfaceList(value={@Optional.Interface(iface="crazypants.enderio.api.tool.ITool", modid="EnderIO", striprefs=true), @Optional.Interface(iface="buildcraft.api.tools.IToolWrench", modid="BuildCraft|Core", striprefs=true)})
public class ItemNanotool
extends ItemAbstractBatteryUser
implements ITool,
IToolWrench {
    protected IIcon[] icons = null;
    protected float efficiencyOnProperMaterial = 6.0f;
    protected String[] textures = new String[]{"nanotool", "nanotool-axe", "nanotool-hoe", "nanotool-pickaxe", "nanotool-shears", "nanotool-shovel", "nanotool-wrench"};
    public final float energyCostUseSmall = 20.0f;
    public final float energyCostUseBig = 40.0f;
    public final float energyCostSwitch = 60.0f;
    protected Map<Mode, Set<String>> toolClassesSet;

    public ItemNanotool(String name) {
        this.func_77655_b(name);
        this.icons = new IIcon[this.textures.length];
        this.func_111206_d("amunra:nanotool-empty");
        this.toolClassesSet = new HashMap<Mode, Set<String>>();
        HashSet<String> axe = new HashSet<String>();
        axe.add("axe");
        this.toolClassesSet.put(Mode.AXE, axe);
        HashSet<String> hoe = new HashSet<String>();
        hoe.add("hoe");
        this.toolClassesSet.put(Mode.HOE, hoe);
        HashSet<String> pick = new HashSet<String>();
        pick.add("pickaxe");
        this.toolClassesSet.put(Mode.PICKAXE, pick);
        HashSet<String> shovel = new HashSet<String>();
        shovel.add("shovel");
        this.toolClassesSet.put(Mode.SHOVEL, shovel);
        HashSet empty = new HashSet();
        this.toolClassesSet.put(Mode.SHEARS, empty);
        this.toolClassesSet.put(Mode.WRENCH, empty);
        this.toolClassesSet.put(Mode.WORKBENCH, empty);
    }

    protected void setMode(ItemStack stack, Mode m) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74768_a("toolMode", m.ordinal());
    }

    public Mode getMode(ItemStack stack) {
        int ord = this.getModeInt(stack);
        return Mode.values()[ord];
    }

    protected int getModeInt(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            return 0;
        }
        return nbt.func_74762_e("toolMode");
    }

    public CreativeTabs func_77640_w() {
        return AmunRa.arTab;
    }

    public boolean hasEnoughEnergyAndMode(ItemStack stack, float energy, Mode mode) {
        return this.getMode(stack) == mode && this.hasEnoughEnergy(stack, energy);
    }

    public boolean hasEnoughEnergy(ItemStack stack, float energy) {
        float storedEnergy = this.getElectricityStored(stack);
        return storedEnergy >= energy;
    }

    public ItemStack func_77659_a(ItemStack itemStackIn, World worldIn, EntityPlayer player) {
        if (player.func_70093_af()) {
            if (this.hasEnoughEnergyAndMode(itemStackIn, this.energyCostUseBig, Mode.WRENCH) && Minecraft.func_71410_x().field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
                return super.func_77659_a(itemStackIn, worldIn, player);
            }
            if (this.hasEnoughEnergy(itemStackIn, this.energyCostSwitch)) {
                Mode m = this.getMode(itemStackIn);
                m = this.getNextMode(m);
                this.consumePower(itemStackIn, (EntityLivingBase)player, this.energyCostSwitch);
                this.setMode(itemStackIn, m);
            }
            return itemStackIn;
        }
        if (this.hasEnoughEnergyAndMode(itemStackIn, this.energyCostUseBig, Mode.WORKBENCH)) {
            this.consumePower(itemStackIn, (EntityLivingBase)player, this.energyCostUseBig);
            player.openGui((Object)AmunRa.instance, 6, worldIn, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
            return itemStackIn;
        }
        return super.func_77659_a(itemStackIn, worldIn, player);
    }

    public Mode getNextMode(Mode fromMode) {
        Mode mode;
        switch (fromMode) {
            case WORKBENCH: {
                mode = Mode.PICKAXE;
                break;
            }
            case PICKAXE: {
                mode = Mode.SHOVEL;
                break;
            }
            case SHOVEL: {
                mode = Mode.AXE;
                break;
            }
            case AXE: {
                mode = Mode.HOE;
                break;
            }
            case HOE: {
                mode = Mode.SHEARS;
                break;
            }
            case SHEARS: {
                mode = Mode.WRENCH;
                break;
            }
            case WRENCH: {
                mode = Mode.WORKBENCH;
                break;
            }
            default: {
                mode = Mode.PICKAXE;
            }
        }
        return mode;
    }

    public int func_77619_b() {
        return 0;
    }

    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        return this.func_77650_f(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        super.func_94581_a(register);
        for (int i = 0; i < this.textures.length; ++i) {
            this.icons[i] = register.func_94245_a("amunra:" + this.textures[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77650_f(ItemStack p_77650_1_) {
        float energy = this.getElectricityStored(p_77650_1_);
        if (energy <= 0.0f) {
            return this.field_77791_bV;
        }
        return this.icons[this.getModeInt(p_77650_1_)];
    }

    public Set<String> getToolClasses(ItemStack stack) {
        float energy = this.getElectricityStored(stack);
        if (energy > 0.0f) {
            Mode m = this.getMode(stack);
            return this.toolClassesSet.get((Object)m);
        }
        return super.getToolClasses(stack);
    }

    public int getHarvestLevel(ItemStack stack, String toolClass) {
        float energy = this.getElectricityStored(stack);
        if (energy < this.energyCostUseSmall) {
            return -1;
        }
        Mode m = this.getMode(stack);
        if (!this.toolClassesSet.get((Object)m).contains(toolClass)) {
            return -1;
        }
        return 5;
    }

    public float getDigSpeed(ItemStack itemstack, Block block, int metadata) {
        if (!this.hasEnoughEnergy(itemstack, this.energyCostUseSmall)) {
            return 1.0f;
        }
        if (ForgeHooks.isToolEffective((ItemStack)itemstack, (Block)block, (int)metadata) || this.isEffectiveAgainst(this.getMode(itemstack), block)) {
            return this.efficiencyOnProperMaterial;
        }
        return super.getDigSpeed(itemstack, block, metadata);
    }

    protected boolean isEffectiveAgainst(Mode m, Block b) {
        boolean bl;
        switch (m) {
            case AXE: {
                if (b.func_149688_o() == Material.field_151575_d || b.func_149688_o() == Material.field_151585_k || b.func_149688_o() == Material.field_151582_l) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case PICKAXE: {
                if (b.func_149688_o() == Material.field_151573_f || b.func_149688_o() == Material.field_151574_g || b.func_149688_o() == Material.field_151576_e) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SHEARS: {
                if (b.func_149688_o() == Material.field_151584_j || b.func_149688_o() == Material.field_151580_n || b.func_149688_o() == Material.field_151593_r || b == Blocks.field_150321_G || b == Blocks.field_150488_af || b == Blocks.field_150473_bD) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SHOVEL: {
                if (b.func_149688_o() == Material.field_151571_B || b.func_149688_o() == Material.field_151578_c || b.func_149688_o() == Material.field_151571_B) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WORKBENCH: 
            case HOE: 
            case WRENCH: {
                bl = false;
                break;
            }
            default: {
                bl = false;
            }
        }
        return bl;
    }

    protected String getTypeString(Mode m) {
        String string;
        switch (m) {
            case AXE: {
                string = "item.nanotool.mode.axe";
                break;
            }
            case HOE: {
                string = "item.nanotool.mode.hoe";
                break;
            }
            case PICKAXE: {
                string = "item.nanotool.mode.pickaxe";
                break;
            }
            case SHEARS: {
                string = "item.nanotool.mode.shears";
                break;
            }
            case SHOVEL: {
                string = "item.nanotool.mode.shovel";
                break;
            }
            case WORKBENCH: {
                string = "item.nanotool.mode.workbench";
                break;
            }
            case WRENCH: {
                string = "item.nanotool.mode.wrench";
                break;
            }
            default: {
                string = "";
            }
        }
        return string;
    }

    @Override
    public void func_77624_a(ItemStack p_77624_1_, EntityPlayer p_77624_2_, List p_77624_3_, boolean p_77624_4_) {
        super.func_77624_a(p_77624_1_, p_77624_2_, p_77624_3_, p_77624_4_);
        Mode m = this.getMode(p_77624_1_);
        p_77624_3_.add(StatCollector.func_74838_a((String)"item.nanotool.mode-prefix") + ": " + StatCollector.func_74838_a((String)this.getTypeString(m)));
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase p_77644_2_, EntityLivingBase p_77644_3_) {
        if (this.hasEnoughEnergy(stack, this.energyCostUseBig)) {
            this.consumePower(stack, p_77644_3_, this.energyCostUseBig);
            return true;
        }
        return false;
    }

    public boolean func_150894_a(ItemStack stack, World worldIn, Block blockIn, int p_150894_4_, int p_150894_5_, int p_150894_6_, EntityLivingBase p_150894_7_) {
        if (!this.hasEnoughEnergy(stack, this.energyCostUseSmall)) {
            return false;
        }
        this.consumePower(stack, p_150894_7_, this.energyCostUseSmall);
        if (this.getMode(stack) == Mode.SHEARS) {
            if (blockIn.func_149688_o() != Material.field_151584_j && blockIn != Blocks.field_150321_G && blockIn != Blocks.field_150329_H && blockIn != Blocks.field_150395_bd && blockIn != Blocks.field_150473_bD && !(blockIn instanceof IShearable)) {
                return super.func_150894_a(stack, worldIn, blockIn, p_150894_4_, p_150894_5_, p_150894_6_, p_150894_7_);
            }
            return true;
        }
        return super.func_150894_a(stack, worldIn, blockIn, p_150894_4_, p_150894_5_, p_150894_6_, p_150894_7_);
    }

    public boolean canHarvestBlock(Block par1Block, ItemStack itemStack) {
        return this.isEffectiveAgainst(this.getMode(itemStack), par1Block);
    }

    protected void consumePower(ItemStack itemStack, EntityLivingBase user, float power) {
        EntityPlayer player = null;
        if (user instanceof EntityPlayer) {
            player = (EntityPlayer)user;
        }
        if (player == null || !player.field_71075_bZ.field_75098_d) {
            this.setElectricity(itemStack, this.getElectricityStored(itemStack) - power);
        }
    }

    public float func_150893_a(ItemStack p_150893_1_, Block p_150893_2_) {
        if (this.hasEnoughEnergyAndMode(p_150893_1_, this.energyCostUseSmall, Mode.SHEARS)) {
            return Items.field_151097_aZ.func_150893_a(p_150893_1_, p_150893_2_);
        }
        return super.func_150893_a(p_150893_1_, p_150893_2_);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target) {
        if (this.hasEnoughEnergyAndMode(stack, this.energyCostUseBig, Mode.SHEARS)) {
            this.consumePower(stack, (EntityLivingBase)player, this.energyCostUseBig);
            return Items.field_151097_aZ.func_111207_a(stack, player, target);
        }
        return super.func_111207_a(stack, player, target);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, int X, int Y, int Z, EntityPlayer player) {
        if (this.hasEnoughEnergyAndMode(itemstack, this.energyCostUseSmall, Mode.SHEARS)) {
            return Items.field_151097_aZ.onBlockStartBreak(itemstack, X, Y, Z, player);
        }
        return super.onBlockStartBreak(itemstack, X, Y, Z, player);
    }

    public boolean func_77648_a(ItemStack p_77648_1_, EntityPlayer p_77648_2_, World p_77648_3_, int p_77648_4_, int p_77648_5_, int p_77648_6_, int p_77648_7_, float p_77648_8_, float p_77648_9_, float p_77648_10_) {
        if (this.hasEnoughEnergyAndMode(p_77648_1_, this.energyCostUseSmall, Mode.HOE)) {
            if (!p_77648_2_.func_82247_a(p_77648_4_, p_77648_5_, p_77648_6_, p_77648_7_, p_77648_1_)) {
                return false;
            }
            UseHoeEvent event = new UseHoeEvent(p_77648_2_, p_77648_1_, p_77648_3_, p_77648_4_, p_77648_5_, p_77648_6_);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            if (event.getResult() == Event.Result.ALLOW) {
                this.consumePower(p_77648_1_, (EntityLivingBase)p_77648_2_, this.energyCostUseSmall);
                return true;
            }
            Block block = p_77648_3_.func_147439_a(p_77648_4_, p_77648_5_, p_77648_6_);
            if (p_77648_7_ == 0 || !p_77648_3_.func_147439_a(p_77648_4_, p_77648_5_ + 1, p_77648_6_).isAir((IBlockAccess)p_77648_3_, p_77648_4_, p_77648_5_ + 1, p_77648_6_) || block != Blocks.field_150349_c && block != Blocks.field_150346_d) {
                return false;
            }
            Block block1 = Blocks.field_150458_ak;
            p_77648_3_.func_72908_a((double)((float)p_77648_4_ + 0.5f), (double)((float)p_77648_5_ + 0.5f), (double)((float)p_77648_6_ + 0.5f), block1.field_149762_H.func_150498_e(), (block1.field_149762_H.func_150497_c() + 1.0f) / 2.0f, block1.field_149762_H.func_150494_d() * 0.8f);
            if (!p_77648_3_.field_72995_K) {
                p_77648_3_.func_147449_b(p_77648_4_, p_77648_5_, p_77648_6_, block1);
                this.consumePower(p_77648_1_, (EntityLivingBase)p_77648_2_, this.energyCostUseSmall);
            }
            return true;
        }
        return super.func_77648_a(p_77648_1_, p_77648_2_, p_77648_3_, p_77648_4_, p_77648_5_, p_77648_6_, p_77648_7_, p_77648_8_, p_77648_9_, p_77648_10_);
    }

    public boolean canWrench(EntityPlayer entityPlayer, int x, int y, int z) {
        ItemStack stack = entityPlayer.field_71071_by.func_70448_g();
        return this.hasEnoughEnergyAndMode(stack, this.energyCostUseSmall, Mode.WRENCH);
    }

    public void wrenchUsed(EntityPlayer entityPlayer, int x, int y, int z) {
        ItemStack stack = entityPlayer.field_71071_by.func_70448_g();
        if (this.hasEnoughEnergyAndMode(stack, this.energyCostUseSmall, Mode.WRENCH)) {
            this.consumePower(stack, (EntityLivingBase)entityPlayer, this.energyCostUseSmall);
        }
    }

    public boolean canUse(ItemStack stack, EntityPlayer player, int x, int y, int z) {
        return this.hasEnoughEnergyAndMode(stack, this.energyCostUseSmall, Mode.WRENCH);
    }

    public void used(ItemStack stack, EntityPlayer player, int x, int y, int z) {
        this.consumePower(stack, (EntityLivingBase)player, this.energyCostUseSmall);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    private boolean attemptDismantle(EntityPlayer entityPlayer, Block block, World world, int x, int y, int z) {
        if (InteroperabilityHelper.hasIDismantleable && block instanceof IDismantleable && ((IDismantleable)block).canDismantle(entityPlayer, world, x, y, z)) {
            ((IDismantleable)block).dismantleBlock(entityPlayer, world, x, y, z, false);
            return true;
        }
        return false;
    }

    public boolean onItemUseFirst(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        if (this.hasEnoughEnergyAndMode(stack, this.energyCostUseSmall, Mode.WRENCH)) {
            if (world.field_72995_K) {
                return false;
            }
            Block blockID = world.func_147439_a(x, y, z);
            if (player.func_70093_af() && this.attemptDismantle(player, blockID, world, x, y, z)) {
                return true;
            }
            if (blockID == Blocks.field_150460_al || blockID == Blocks.field_150470_am || blockID == Blocks.field_150409_cd || blockID == Blocks.field_150438_bZ || blockID == Blocks.field_150367_z || blockID == Blocks.field_150331_J || blockID == Blocks.field_150320_F) {
                int metadata = world.func_72805_g(x, y, z);
                int[] rotationMatrix = new int[]{1, 2, 3, 4, 5, 0};
                if (blockID == Blocks.field_150460_al || blockID == Blocks.field_150470_am) {
                    rotationMatrix = ForgeDirection.ROTATION_MATRIX[0];
                }
                world.func_72921_c(x, y, z, ForgeDirection.getOrientation((int)rotationMatrix[metadata]).ordinal(), 3);
                this.wrenchUsed(player, x, y, z);
                return true;
            }
            return false;
        }
        return super.onItemUseFirst(stack, player, world, x, y, z, side, hitX, hitY, hitZ);
    }

    public boolean shouldHideFacades(ItemStack stack, EntityPlayer player) {
        return this.getMode(stack) == Mode.WRENCH;
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        ItemStack stack = player.field_71071_by.func_70448_g();
        return this.hasEnoughEnergyAndMode(stack, this.energyCostUseSmall, Mode.WRENCH) && Minecraft.func_71410_x().field_71476_x.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK;
    }

    public static enum Mode {
        WORKBENCH,
        AXE,
        HOE,
        PICKAXE,
        SHEARS,
        SHOVEL,
        WRENCH;

    }
}

