/*
 * Decompiled with CFR 0.152.
 */
package atomicstryker.infernalmobs.common;

import atomicstryker.infernalmobs.common.ISidedProxy;
import atomicstryker.infernalmobs.common.commands.InfernalCommandFindEntityClass;
import atomicstryker.infernalmobs.common.commands.InfernalCommandSpawnInfernal;
import atomicstryker.infernalmobs.common.events.EntityEventHandler;
import atomicstryker.infernalmobs.common.events.SaveEventHandler;
import atomicstryker.infernalmobs.common.modifiers.MM_1UP;
import atomicstryker.infernalmobs.common.modifiers.MM_Alchemist;
import atomicstryker.infernalmobs.common.modifiers.MM_Berserk;
import atomicstryker.infernalmobs.common.modifiers.MM_Blastoff;
import atomicstryker.infernalmobs.common.modifiers.MM_Bulwark;
import atomicstryker.infernalmobs.common.modifiers.MM_Choke;
import atomicstryker.infernalmobs.common.modifiers.MM_Cloaking;
import atomicstryker.infernalmobs.common.modifiers.MM_Darkness;
import atomicstryker.infernalmobs.common.modifiers.MM_Ender;
import atomicstryker.infernalmobs.common.modifiers.MM_Exhaust;
import atomicstryker.infernalmobs.common.modifiers.MM_Fiery;
import atomicstryker.infernalmobs.common.modifiers.MM_Ghastly;
import atomicstryker.infernalmobs.common.modifiers.MM_Gravity;
import atomicstryker.infernalmobs.common.modifiers.MM_Lifesteal;
import atomicstryker.infernalmobs.common.modifiers.MM_Ninja;
import atomicstryker.infernalmobs.common.modifiers.MM_Poisonous;
import atomicstryker.infernalmobs.common.modifiers.MM_Quicksand;
import atomicstryker.infernalmobs.common.modifiers.MM_Regen;
import atomicstryker.infernalmobs.common.modifiers.MM_Rust;
import atomicstryker.infernalmobs.common.modifiers.MM_Sapper;
import atomicstryker.infernalmobs.common.modifiers.MM_Sprint;
import atomicstryker.infernalmobs.common.modifiers.MM_Sticky;
import atomicstryker.infernalmobs.common.modifiers.MM_Storm;
import atomicstryker.infernalmobs.common.modifiers.MM_Vengeance;
import atomicstryker.infernalmobs.common.modifiers.MM_Weakness;
import atomicstryker.infernalmobs.common.modifiers.MM_Webber;
import atomicstryker.infernalmobs.common.modifiers.MM_Wither;
import atomicstryker.infernalmobs.common.modifiers.MobModifier;
import atomicstryker.infernalmobs.common.modifiers.ModifierLoader;
import atomicstryker.infernalmobs.common.network.NetworkHelper;
import atomicstryker.infernalmobs.common.network.packets.AirPacket;
import atomicstryker.infernalmobs.common.network.packets.HealthPacket;
import atomicstryker.infernalmobs.common.network.packets.KnockBackPacket;
import atomicstryker.infernalmobs.common.network.packets.MobModsPacket;
import atomicstryker.infernalmobs.common.network.packets.VelocityPacket;
import com.google.common.collect.Lists;
import cpw.mods.fml.client.FMLClientHandler;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IEntityOwnable;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.logging.log4j.Level;

@Mod(modid="InfernalMobs", name="Infernal Mobs", version="1.9.2-GTNH")
public class InfernalMobsCore {
    private final long existCheckDelay = 5000L;
    private long nextExistCheckTime;
    private ArrayList<Integer> dimensionBlackList;
    private ArrayList<ItemStack> dropIdListElite;
    private ArrayList<ItemStack> dropIdListUltra;
    private ArrayList<ItemStack> dropIdListInfernal;
    private HashMap<String, Boolean> classesAllowedMap;
    private HashMap<String, Boolean> classesForcedMap;
    private HashMap<String, Float> classesHealthMap;
    private boolean useSimpleEntityClassNames;
    private boolean disableHealthBar;
    private double modHealthFactor;
    private Entity infCheckA;
    private Entity infCheckB;
    @Mod.Instance(value="InfernalMobs")
    private static InfernalMobsCore instance;
    private ArrayList<ModifierLoader<?>> modifierLoaders;
    private int eliteRarity;
    private int ultraRarity;
    private int infernoRarity;
    private int minEliteModifiers;
    private int maxEliteModifiers;
    private int minUltraModifiers;
    private int maxUltraModifiers;
    private int minInfernoModifiers;
    private int maxInfernoModifiers;
    public Configuration config;
    @SidedProxy(clientSide="atomicstryker.infernalmobs.client.InfernalMobsClient", serverSide="atomicstryker.infernalmobs.common.InfernalMobsServer")
    public static ISidedProxy proxy;
    public NetworkHelper networkHelper;
    private HashMap<UUID, Long> modifiedPlayerTimes;

    public static InfernalMobsCore instance() {
        return instance;
    }

    public static String getNBTTag() {
        return "InfernalMobsMod";
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        this.dimensionBlackList = new ArrayList();
        this.dropIdListElite = new ArrayList();
        this.dropIdListUltra = new ArrayList();
        this.dropIdListInfernal = new ArrayList();
        this.nextExistCheckTime = System.currentTimeMillis();
        this.classesAllowedMap = new HashMap();
        this.classesForcedMap = new HashMap();
        this.classesHealthMap = new HashMap();
        this.modifiedPlayerTimes = new HashMap();
        this.config = new Configuration(evt.getSuggestedConfigurationFile());
        this.config.load();
        if (this.config.hasChanged()) {
            this.config.save();
        }
        this.loadMods();
        proxy.preInit();
        FMLCommonHandler.instance().bus().register((Object)this);
        this.networkHelper = new NetworkHelper("AS_IF", MobModsPacket.class, HealthPacket.class, VelocityPacket.class, KnockBackPacket.class, AirPacket.class);
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new EntityEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new SaveEventHandler());
        proxy.load();
        FMLLog.log((String)"InfernalMobs", (Level)Level.INFO, (String)String.format("InfernalMobsCore load() completed! Modifiers ready: %s", this.modifierLoaders.size()), (Object[])new Object[0]);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        this.loadConfig();
    }

    @Mod.EventHandler
    public void serverStarted(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new InfernalCommandFindEntityClass());
        evt.registerServerCommand((ICommand)new InfernalCommandSpawnInfernal());
    }

    private void loadMods() {
        this.modifierLoaders = Lists.newArrayList((Object[])new ModifierLoader[]{new MM_1UP.Loader(), new MM_Alchemist.Loader(), new MM_Berserk.Loader(), new MM_Blastoff.Loader(), new MM_Bulwark.Loader(), new MM_Choke.Loader(), new MM_Cloaking.Loader(), new MM_Darkness.Loader(), new MM_Ender.Loader(), new MM_Exhaust.Loader(), new MM_Fiery.Loader(), new MM_Ghastly.Loader(), new MM_Gravity.Loader(), new MM_Lifesteal.Loader(), new MM_Ninja.Loader(), new MM_Poisonous.Loader(), new MM_Quicksand.Loader(), new MM_Regen.Loader(), new MM_Rust.Loader(), new MM_Sapper.Loader(), new MM_Sprint.Loader(), new MM_Sticky.Loader(), new MM_Storm.Loader(), new MM_Vengeance.Loader(), new MM_Weakness.Loader(), new MM_Webber.Loader(), new MM_Wither.Loader()});
        this.modifierLoaders.removeIf(loader -> !this.config.get("general", loader.getModifierClassName() + " enabled", true).getBoolean(true));
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void loadConfig() {
        this.eliteRarity = Integer.parseInt(this.config.get("general", "eliteRarity", 15, "One in THIS many Mobs will become atleast rare").getString());
        this.ultraRarity = Integer.parseInt(this.config.get("general", "ultraRarity", 7, "One in THIS many already rare Mobs will become atleast ultra").getString());
        this.infernoRarity = Integer.parseInt(this.config.get("general", "infernoRarity", 7, "One in THIS many already ultra Mobs will become infernal").getString());
        this.minEliteModifiers = Integer.parseInt(this.config.get("general", "minEliteModifiers", 2, "Minimum number of Modifiers an Elite mob will receive").getString());
        this.maxEliteModifiers = Integer.parseInt(this.config.get("general", "maxEliteModifiers", 5, "Maximum number of Modifiers an Elite mob will receive").getString());
        this.minUltraModifiers = Integer.parseInt(this.config.get("general", "minUltraModifiers", 5, "Minimum number of Modifiers an Ultra mob will receive").getString());
        this.maxUltraModifiers = Integer.parseInt(this.config.get("general", "maxUltraModifiers", 10, "Maximum number of Modifiers an Ultra mob will receive").getString());
        this.minInfernoModifiers = Integer.parseInt(this.config.get("general", "minInfernoModifiers", 8, "Minimum number of Modifiers an Inferno mob will receive").getString());
        this.maxInfernoModifiers = Integer.parseInt(this.config.get("general", "maxInfernoModifiers", 15, "Maximum number of Modifiers an Inferno mob will receive").getString());
        this.useSimpleEntityClassNames = this.config.get("general", "useSimpleEntityClassnames", true, "Use Entity class names instead of ingame Entity names for the config").getBoolean(true);
        this.disableHealthBar = this.config.get("general", "disableGUIoverlay", false, "Disables the ingame Health and Name overlay").getBoolean(false);
        this.modHealthFactor = this.config.get("general", "mobHealthFactor", "1.0", "Multiplier applied ontop of all of the modified Mobs health").getDouble(1.0);
        this.parseItemsForList(this.config.get("general", "droppedItemIDsElite", "iron_shovel,iron_pickaxe,iron_axe,iron_sword,iron_hoe,chainmail_helmet,chainmail_chestplate,chainmail_leggings,chainmail_boots,iron_helmet,iron_chestplate,iron_leggings,iron_boots,cookie-0-6", "List of equally likely to drop Items for Elites, seperated by commas, syntax: ID-meta-stackSize-stackSizeRandomizer, everything but ID is optional, see changelog").getString(), this.dropIdListElite);
        this.parseItemsForList(this.config.get("general", "droppedItemIDsUltra", "bow,iron_hoe,chainmail_helmet,chainmail_chestplate,chainmail_leggings,chainmail_boots,iron_helmet,iron_chestplate,iron_leggings,iron_boots,golden_helmet,golden_chestplate,golden_leggings,golden_boots,golden_apple,blaze_powder-0-3,enchanted_book", "List of equally likely to drop Items for Ultras, seperated by commas, syntax: ID-meta-stackSize-stackSizeRandomizer, everything but ID is optional, see changelog").getString(), this.dropIdListUltra);
        this.parseItemsForList(this.config.get("general", "droppedItemIDsInfernal", "diamond-0-3,diamond_sword,diamond_shovel,diamond_pickaxe,diamond_axe,diamond_hoe,chainmail_helmet,chainmail_chestplate,chainmail_leggings,chainmail_boots,diamond_helmet,diamond_chestplate,diamond_leggings,diamond_boots,ender_pearl,enchanted_book", "List of equally likely to drop Items for Infernals, seperated by commas, syntax: ID-meta-stackSize-stackSizeRandomizer, everything but ID is optional, see changelog").getString(), this.dropIdListInfernal);
        this.parseIDsForList(this.config.get("general", "dimensionIDBlackList", "", "List of DimensionIDs where InfernalMobs will NEVER spawn").getString(), this.dimensionBlackList);
        for (ModifierLoader<?> loader : this.modifierLoaders) {
            loader.loadConfig(this.config);
        }
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void parseIDsForList(String dimensionIDs, ArrayList<Integer> list) {
        dimensionIDs = dimensionIDs.trim();
        for (String s : dimensionIDs.split(",")) {
            String trimmedDimIDString = s.trim();
            if (s.isEmpty()) continue;
            try {
                Integer tDimID = Integer.parseInt(trimmedDimIDString);
                list.add(tDimID);
                FMLLog.log((String)"InfernalMobs", (Level)Level.INFO, (String)String.format("DimensionID %d is now Blacklisted for InfernalMobs spawn", tDimID), (Object[])new Object[0]);
            }
            catch (Exception e) {
                FMLLog.log((String)"InfernalMobs", (Level)Level.ERROR, (String)String.format("Configured DimensionID %s is not an integer! All values must be numeric. Ignoring entry", trimmedDimIDString), (Object[])new Object[0]);
            }
        }
    }

    private void parseItemsForList(String itemIDs, ArrayList<ItemStack> list) {
        Random rand = new Random();
        itemIDs = itemIDs.trim();
        for (String s : itemIDs.split(",")) {
            int randomizer;
            String[] meta = s.split("-");
            Object itemOrBlock = this.parseOrFind(meta[0]);
            if (itemOrBlock == null) continue;
            int imeta = meta.length > 1 ? Integer.parseInt(meta[1]) : 0;
            int stackSize = meta.length > 2 ? Integer.parseInt(meta[2]) : 1;
            int n = randomizer = meta.length > 3 ? Integer.parseInt(meta[3]) + 1 : 1;
            if (randomizer < 1) {
                randomizer = 1;
            }
            if (itemOrBlock instanceof Block) {
                list.add(new ItemStack((Block)itemOrBlock, stackSize + rand.nextInt(randomizer), imeta));
                continue;
            }
            list.add(new ItemStack((Item)itemOrBlock, stackSize + rand.nextInt(randomizer), imeta));
        }
    }

    private Object parseOrFind(String s) {
        Item item = (Item)GameData.getItemRegistry().func_82594_a(s);
        if (item != null) {
            return item;
        }
        Block block = (Block)GameData.getBlockRegistry().func_82594_a(s);
        if (block != Blocks.field_150350_a) {
            return block;
        }
        return null;
    }

    public void processEntitySpawn(EntityLivingBase entity) {
        if (!entity.field_70170_p.field_72995_K && !InfernalMobsCore.getIsRareEntity(entity) && this.isClassAllowed(entity) && (this.checkEntityClassForced(entity) || entity.field_70170_p.field_73012_v.nextInt(this.eliteRarity) == 0)) {
            try {
                MobModifier mod;
                Integer tEntityDim = entity.field_71093_bK;
                if (!this.dimensionBlackList.contains(tEntityDim) && (mod = this.createMobModifiers(entity)) != null) {
                    this.addEntityModifiers(entity, mod, false);
                }
            }
            catch (Exception e) {
                FMLLog.log((String)"InfernalMobs", (Level)Level.ERROR, (String)"processEntitySpawn() threw an exception", (Object[])new Object[0]);
                FMLLog.severe((String)e.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    public boolean isClassAllowed(EntityLivingBase entity) {
        if (entity instanceof IMob) {
            if (entity instanceof IEntityOwnable) {
                return false;
            }
            return this.checkEntityClassAllowed(entity);
        }
        return false;
    }

    private String getEntityNameSafe(Entity entity) {
        String result;
        try {
            result = EntityList.func_75621_b((Entity)entity);
        }
        catch (Exception e) {
            result = entity.getClass().getSimpleName();
            FMLLog.log((String)"InfernalMobs", (Level)Level.INFO, (String)String.format("Entity of class %s crashed when EntityList.getEntityString was queried, for shame! Using classname instead. If this message is spamming too much for your taste set useSimpleEntityClassnames true in your Infernal Mobs config", result), (Object[])new Object[0]);
        }
        return result;
    }

    private boolean checkEntityClassAllowed(EntityLivingBase entity) {
        String entName;
        String string = entName = this.useSimpleEntityClassNames ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesAllowedMap.containsKey(entName)) {
            return this.classesAllowedMap.get(entName);
        }
        boolean result = this.config.get("permittedentities", entName, true).getBoolean(true);
        if (this.config.hasChanged()) {
            this.config.save();
        }
        this.classesAllowedMap.put(entName, result);
        return result;
    }

    public boolean checkEntityClassForced(EntityLivingBase entity) {
        String entName;
        String string = entName = this.useSimpleEntityClassNames ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesForcedMap.containsKey(entName)) {
            return this.classesForcedMap.get(entName);
        }
        boolean result = this.config.get("entitiesalwaysinfernal", entName, false).getBoolean(false);
        if (this.config.hasChanged()) {
            this.config.save();
        }
        this.classesForcedMap.put(entName, result);
        return result;
    }

    public float getMobClassMaxHealth(EntityLivingBase entity) {
        String entName;
        String string = entName = this.useSimpleEntityClassNames ? entity.getClass().getSimpleName() : this.getEntityNameSafe((Entity)entity);
        if (this.classesHealthMap.containsKey(entName)) {
            return this.classesHealthMap.get(entName).floatValue();
        }
        float result = (float)this.config.get("entitybasehealth", entName, (double)entity.func_110138_aP()).getDouble((double)entity.func_110138_aP());
        if (this.config.hasChanged()) {
            this.config.save();
        }
        this.classesHealthMap.put(entName, Float.valueOf(result));
        return result;
    }

    public void setEntityHealthPastMax(EntityLivingBase entity, float amount) {
        entity.func_70606_j(amount);
        this.sendHealthPacket(entity, amount);
    }

    public MobModifier createMobModifiers(EntityLivingBase entity) {
        ArrayList possibleMods = (ArrayList)this.modifierLoaders.clone();
        int minModifiers = this.minEliteModifiers;
        int maxModifiers = this.maxEliteModifiers;
        if (entity.field_70170_p.field_73012_v.nextInt(this.ultraRarity) == 0) {
            minModifiers = this.minUltraModifiers;
            maxModifiers = this.maxUltraModifiers;
            if (entity.field_70170_p.field_73012_v.nextInt(this.infernoRarity) == 0) {
                minModifiers = this.minInfernoModifiers;
                maxModifiers = this.maxInfernoModifiers;
            }
        }
        int number = Math.min(minModifiers, maxModifiers) + entity.field_70170_p.field_73012_v.nextInt(Math.max(minModifiers, maxModifiers) - Math.min(minModifiers, maxModifiers) + 1);
        MobModifier lastMod = null;
        while (number > 0 && !possibleMods.isEmpty()) {
            int index = entity.field_70170_p.field_73012_v.nextInt(possibleMods.size());
            Object nextMod = ((ModifierLoader)possibleMods.get(index)).make(lastMod);
            boolean allowed = true;
            if (((MobModifier)nextMod).getBlackListMobClasses() != null) {
                for (Class<?> cl : ((MobModifier)nextMod).getBlackListMobClasses()) {
                    if (!entity.getClass().isAssignableFrom(cl)) continue;
                    allowed = false;
                    break;
                }
            }
            if (lastMod != null && lastMod.getModsNotToMixWith() != null) {
                for (Class<?> cl : lastMod.getModsNotToMixWith()) {
                    if (!lastMod.containsModifierClass(cl)) continue;
                    allowed = false;
                    break;
                }
            }
            possibleMods.remove(index);
            if (!allowed) continue;
            lastMod = nextMod;
            --number;
        }
        return lastMod;
    }

    public void addEntityModifiers(EntityLivingBase entity, MobModifier mod, boolean isHealthHacked) {
        if (mod != null) {
            proxy.getRareMobs().put(entity, mod);
            mod.onSpawningComplete(entity);
            if (isHealthHacked) {
                mod.setHealthAlreadyHacked(entity);
            }
        }
    }

    public void addEntityModifiersByString(EntityLivingBase entity, String savedMods) {
        if (!InfernalMobsCore.getIsRareEntity(entity)) {
            MobModifier mod = this.stringToMobModifiers(savedMods);
            if (mod != null) {
                this.addEntityModifiers(entity, mod, true);
            } else {
                FMLLog.log((String)"InfernalMobs", (Level)Level.DEBUG, (String)String.format("Infernal Mobs error, could not instantiate modifier(s) %s", savedMods), (Object[])new Object[0]);
            }
        }
    }

    private MobModifier stringToMobModifiers(String buffer) {
        MobModifier lastMod = null;
        String[] tokens = buffer.split("\\s");
        block0: for (int j = tokens.length - 1; j >= 0; --j) {
            String modName = tokens[j];
            for (ModifierLoader<?> loader : this.modifierLoaders) {
                Object nextMod = loader.make(lastMod);
                if (!((MobModifier)nextMod).getModName().equalsIgnoreCase(modName)) continue;
                lastMod = (MobModifier)nextMod;
                continue block0;
            }
        }
        return lastMod;
    }

    public static MobModifier getMobModifiers(EntityLivingBase ent) {
        return proxy.getRareMobs().get(ent);
    }

    public static boolean getIsRareEntity(EntityLivingBase ent) {
        return proxy.getRareMobs().containsKey(ent);
    }

    public static void removeEntFromElites(EntityLivingBase entity) {
        proxy.getRareMobs().remove(entity);
    }

    public void addRemoteEntityModifiers(World world, int entID, String mods) {
        Entity ent = world.func_73045_a(entID);
        if (ent != null) {
            this.addEntityModifiersByString((EntityLivingBase)ent, mods);
        }
    }

    public void dropLootForEnt(EntityLivingBase mob, MobModifier mods) {
        int xpDrop;
        for (int xpValue = 25; xpValue > 0; xpValue -= xpDrop) {
            xpDrop = EntityXPOrb.func_70527_a((int)xpValue);
            mob.field_70170_p.func_72838_d((Entity)new EntityXPOrb(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, xpDrop));
        }
        this.dropRandomEnchantedItems(mob, mods);
    }

    private void dropRandomEnchantedItems(EntityLivingBase mob, MobModifier mods) {
        int prefix;
        int modStr = mods.getModSize();
        int n = modStr <= 5 ? 0 : (prefix = modStr <= 10 ? 1 : 2);
        while (modStr > 0) {
            ItemStack itemStack = this.getRandomItem(mob, prefix);
            if (itemStack != null) {
                Item item = itemStack.func_77973_b();
                if (item != null) {
                    if (item instanceof ItemEnchantedBook) {
                        itemStack = ((ItemEnchantedBook)item).func_92114_b((Random)mob.func_70681_au()).field_76297_b;
                    } else {
                        int usedStr = modStr - 5 > 0 ? 5 : modStr;
                        this.enchantRandomly(mob.field_70170_p.field_73012_v, itemStack, item.func_77619_b(), usedStr);
                    }
                }
                EntityItem itemEnt = new EntityItem(mob.field_70170_p, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, itemStack);
                mob.field_70170_p.func_72838_d((Entity)itemEnt);
                modStr -= 5;
                continue;
            }
            --modStr;
        }
    }

    private void enchantRandomly(Random rand, ItemStack itemStack, int itemEnchantability, int modStr) {
        List enchantments = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)itemStack, (int)itemEnchantability);
        if (enchantments != null) {
            Iterator iter = enchantments.iterator();
            for (int remainStr = (modStr + 1) / 2; iter.hasNext() && remainStr > 0; --remainStr) {
                EnchantmentData eData = (EnchantmentData)iter.next();
                itemStack.func_77966_a(eData.field_76302_b, eData.field_76303_c);
            }
        }
    }

    private ItemStack getRandomItem(EntityLivingBase mob, int prefix) {
        ArrayList<ItemStack> list = prefix == 0 ? this.dropIdListElite : (prefix == 1 ? this.dropIdListUltra : this.dropIdListInfernal);
        return !list.isEmpty() ? list.get(mob.field_70170_p.field_73012_v.nextInt(list.size())).func_77946_l() : null;
    }

    public void sendVelocityPacket(EntityPlayerMP target, float xVel, float yVel, float zVel) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new VelocityPacket(xVel, yVel, zVel), target);
        }
    }

    public void sendKnockBackPacket(EntityPlayerMP target, float xVel, float zVel) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new KnockBackPacket(xVel, zVel), target);
        }
    }

    public void sendHealthPacket(EntityLivingBase mob, float health) {
        this.networkHelper.sendPacketToAllAroundPoint(new HealthPacket("", mob.func_145782_y(), mob.func_110143_aJ(), mob.func_110138_aP()), new NetworkRegistry.TargetPoint(mob.field_71093_bK, mob.field_70165_t, mob.field_70163_u, mob.field_70161_v, 32.0));
    }

    public void sendHealthRequestPacket(EntityLivingBase mob) {
        this.networkHelper.sendPacketToServer(new HealthPacket(FMLClientHandler.instance().getClient().field_71439_g.func_146103_bH().getName(), mob.func_145782_y(), 0.0f, 0.0f));
    }

    public void sendAirPacket(EntityPlayerMP target, int lastAir) {
        if (this.getIsEntityAllowedTarget((Entity)target)) {
            this.networkHelper.sendPacketToPlayer(new AirPacket(lastAir), target);
        }
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent tick) {
        if (System.currentTimeMillis() > this.nextExistCheckTime) {
            this.nextExistCheckTime = System.currentTimeMillis() + 5000L;
            ConcurrentHashMap<EntityLivingBase, MobModifier> mobsmap = proxy.getRareMobs();
            for (EntityLivingBase mob : mobsmap.keySet()) {
                if (!mob.field_70128_L && mob.field_70170_p.field_72996_f.contains(mob)) continue;
                InfernalMobsCore.removeEntFromElites(mob);
            }
            this.resetModifiedPlayerEntitiesAsNeeded(tick.world);
        }
        if (!tick.world.field_72995_K) {
            this.infCheckA = null;
            this.infCheckB = null;
        }
    }

    private void resetModifiedPlayerEntitiesAsNeeded(World world) {
        Iterator<Map.Entry<UUID, Long>> iterator = this.modifiedPlayerTimes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, Long> entry = iterator.next();
            if (System.currentTimeMillis() <= entry.getValue() + 10000L) continue;
            UUID id = entry.getKey();
            for (Object p : world.field_73010_i) {
                EntityPlayer player;
                if (!(p instanceof EntityPlayer) || !(player = (EntityPlayer)p).func_110124_au().equals(id)) continue;
                for (ModifierLoader<?> loader : this.modifierLoaders) {
                    Object modifier = loader.make(null);
                    ((MobModifier)modifier).resetModifiedVictim(player);
                }
            }
            iterator.remove();
        }
    }

    public boolean getIsHealthBarDisabled() {
        return this.disableHealthBar;
    }

    public double getMobModHealthFactor() {
        return this.modHealthFactor;
    }

    public boolean getIsEntityAllowedTarget(Entity entity) {
        return !(entity instanceof FakePlayer);
    }

    public boolean isInfiniteLoop(EntityLivingBase mob, Entity entity) {
        if (mob == this.infCheckA && entity == this.infCheckB || mob == this.infCheckB && entity == this.infCheckA) {
            return true;
        }
        this.infCheckA = mob;
        this.infCheckB = entity;
        return false;
    }

    public HashMap<UUID, Long> getModifiedPlayerTimes() {
        return this.modifiedPlayerTimes;
    }

    public ArrayList<Integer> getDimensionBlackList() {
        return this.dimensionBlackList;
    }

    public ArrayList<ItemStack> getDropIdListElite() {
        return this.dropIdListElite;
    }

    public ArrayList<ItemStack> getDropIdListUltra() {
        return this.dropIdListUltra;
    }

    public ArrayList<ItemStack> getDropIdListInfernal() {
        return this.dropIdListInfernal;
    }

    public HashMap<String, Boolean> getClassesAllowedMap() {
        return this.classesAllowedMap;
    }

    public HashMap<String, Boolean> getClassesForcedMap() {
        return this.classesForcedMap;
    }

    public HashMap<String, Float> getClassesHealthMap() {
        return this.classesHealthMap;
    }

    public boolean isUseSimpleEntityClassNames() {
        return this.useSimpleEntityClassNames;
    }

    public boolean isDisableHealthBar() {
        return this.disableHealthBar;
    }

    public double getModHealthFactor() {
        return this.modHealthFactor;
    }

    public ArrayList<ModifierLoader<?>> getModifierLoaders() {
        return this.modifierLoaders;
    }

    public int getEliteRarity() {
        return this.eliteRarity;
    }

    public int getUltraRarity() {
        return this.ultraRarity;
    }

    public int getInfernoRarity() {
        return this.infernoRarity;
    }

    public int getMinEliteModifiers() {
        return this.minEliteModifiers;
    }

    public int getMaxEliteModifiers() {
        return this.maxEliteModifiers;
    }

    public int getMinUltraModifiers() {
        return this.minUltraModifiers;
    }

    public int getMaxUltraModifiers() {
        return this.maxUltraModifiers;
    }

    public int getMinInfernoModifiers() {
        return this.minInfernoModifiers;
    }

    public int getMaxInfernoModifiers() {
        return this.maxInfernoModifiers;
    }
}

