/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.ranks;

import java.util.Arrays;
import java.util.List;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.StatCollector;
import serverutils.client.gui.ranks.GuiEditRank;
import serverutils.lib.config.ConfigGroup;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.gui.CheckBoxList;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.util.misc.MouseButton;

public class GuiAddPermission
extends GuiButtonListBase {
    private final ConfigGroup group;
    private final ConfigGroup allPerm;

    public GuiAddPermission(ConfigGroup rankPerms, ConfigGroup allPerm) {
        this.group = rankPerms;
        this.allPerm = allPerm;
        this.setHasSearchBox(true);
    }

    @Override
    public void addButtons(Panel panel) {
        panel.add(new PermissionList(panel, this.group));
    }

    @Override
    public boolean mousePressed(MouseButton button) {
        boolean b = super.mousePressed(button);
        if (!b && !this.isMouseOver()) {
            this.parent.closeContextMenu();
            return true;
        }
        return b;
    }

    public class PermissionList
    extends CheckBoxList {
        public PermissionList(Panel parent, ConfigGroup rank) {
            super(parent, false);
            for (ConfigValueInstance inst : GuiAddPermission.this.allPerm.getValues()) {
                PermissionsEntry entry = new PermissionsEntry(inst);
                if (rank.getValueInstance(inst.getId()) != null) {
                    entry.value = 1;
                }
                this.addBox(entry);
            }
        }
    }

    public class PermissionsEntry
    extends CheckBoxList.CheckBoxEntry {
        private final ConfigValueInstance inst;

        public PermissionsEntry(ConfigValueInstance valueInstance) {
            super(valueInstance.getId());
            this.inst = valueInstance;
        }

        @Override
        public void addMouseOverText(List<String> list) {
            ChatComponentTranslation component;
            IChatComponent infoText = this.inst.getInfo();
            if (StatCollector.func_94522_b((String)("permission." + this.name))) {
                list.add(StatCollector.func_74838_a((String)("permission." + this.name)));
            } else if (!(infoText instanceof ChatComponentTranslation) || StatCollector.func_94522_b((String)(component = (ChatComponentTranslation)infoText).func_150268_i())) {
                list.addAll(Arrays.asList(infoText.func_150254_d().split("\n")));
            }
        }

        @Override
        public void onValueChanged() {
            GuiEditRank p = (GuiEditRank)GuiAddPermission.this.parent;
            if (this.value > 0) {
                p.addEntry(this.name);
            } else {
                p.removeEntry(this.name);
            }
        }
    }
}

