/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui.ranks;

import java.util.List;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import serverutils.client.gui.ranks.GuiRanks;
import serverutils.client.gui.ranks.RankInst;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.config.ConfigValueInstance;
import serverutils.lib.gui.CheckBoxList;
import serverutils.lib.gui.Panel;
import serverutils.lib.gui.misc.GuiButtonListBase;
import serverutils.lib.util.StringUtils;

public class GuiSelectRank
extends GuiButtonListBase {
    private final RankInst playerRank;
    private final String username;

    public GuiSelectRank(String username, RankInst p) {
        this.playerRank = p;
        this.username = username;
        this.setTitle(StatCollector.func_74838_a((String)"serverutilities.admin_panel.ranks.select_rank"));
        this.setHasSearchBox(true);
    }

    @Override
    public void onPostInit() {
        this.panelButtons.refreshWidgets();
        super.onPostInit();
    }

    @Override
    public void addButtons(Panel panel) {
        panel.add(new RankList(panel));
    }

    public class RankList
    extends CheckBoxList {
        public RankList(Panel parent) {
            super(parent, false);
            for (RankInst rank : GuiRanks.ranks.values()) {
                ConfigValueInstance val;
                boolean isPlayerOp;
                int defaultRank = 0;
                for (ConfigValueInstance inst : rank.group.getValues()) {
                    if (inst.getId().equals("default_player_rank")) {
                        ++defaultRank;
                    }
                    if (!inst.getId().equals("default_op_rank")) continue;
                    defaultRank += 2;
                }
                String rankId = rank.getId();
                CheckBoxList.CheckBoxEntry entry = new RankEntry(rankId, defaultRank).setDisplayName(StringUtils.firstUppercase(rankId));
                if (((GuiSelectRank)GuiSelectRank.this).playerRank.parents.contains(rankId)) {
                    entry.value = 1;
                }
                boolean bl = isPlayerOp = (val = ((GuiSelectRank)GuiSelectRank.this).playerRank.group.getValueInstance("is_op")) != null && val.getValue().getBoolean();
                if (isPlayerOp && defaultRank >= 2) {
                    entry.setLocked(true);
                }
                this.addBox(entry);
            }
        }
    }

    public class RankEntry
    extends CheckBoxList.CheckBoxEntry {
        public RankEntry(String n, int defaultRank) {
            super(n);
            if (defaultRank == 1) {
                this.setLocked(true);
            }
        }

        @Override
        public void addMouseOverText(List<String> list) {
            if (this.locked) {
                list.add(StatCollector.func_74838_a((String)"serverutilities.admin_panel.ranks.cant_remove"));
            }
            super.addMouseOverText(list);
        }

        @Override
        public String getDisplayName() {
            if (this.locked) {
                return EnumChatFormatting.GOLD + this.displayName;
            }
            return super.getDisplayName();
        }

        @Override
        public void onValueChanged() {
            if (this.value > 0) {
                ((GuiSelectRank)GuiSelectRank.this).playerRank.parents.add(this.name);
                ClientUtils.execClientCommand("/ranks add " + GuiSelectRank.this.username + " " + this.name);
            } else {
                ((GuiSelectRank)GuiSelectRank.this).playerRank.parents.remove(this.name);
                ClientUtils.execClientCommand("/ranks remove " + GuiSelectRank.this.username + " " + this.name);
            }
        }
    }
}

